(** Library (and extension for ocsigenserver) for storing and retrieving
    key/value data in a persistent manner. This module defines a unified
    frontend for a number of different backends. *)

module Functorial : Ocsipersist_lib.Sigs.FUNCTORIAL
(** Functorial frontent. Allows for custom (de)serialisation functions, which
    keeps data human-readable in the backend. *)

module type TABLE = Ocsipersist_lib.Sigs.TABLE
(** Table representation as generated by the functor {!Functorial.Table} *)

module Polymorphic : Ocsipersist_lib.Sigs.POLYMORPHIC
(** Polymorphic frontent. Relies on {!Marshal} for (de)serialisation, which
    means that data will be stored in the backend in a fashion that is not
    necessarily easily readable by non-OCaml-based life forms. If this is an
    issue for you, you can rely on the functorial frontend instead. *)

type 'value table = 'value Polymorphic.table
(** Table representation as generated by the function {!Polymorphic.open_table} *)

module Store : Ocsipersist_lib.Sigs.STORE
(** The variable store allows for the persistent storage of individual
    variables. Relies on {!Stdlib.Marshal} for (de)serialisation, which entails
    the same limitations as for the {!Polymorphic} frontend. If this is an
    issue you can rely on {!Functorial} frontend instead (see {!TABLE.Variable}). *)

type store = Store.store
type 'a variable = 'a Store.t
