/* Copyright 2011 Canonical, Ltd. This software is licensed under the GNU
 * Lesser General Public License version 3 or later (see the file COPYING).
 */

#include "gesture.h"

#include "geissingleton.h"

Gesture::Gesture(QDeclarativeItem* parent)
  : QDeclarativeItem(parent),
    touches_(this),
    devices_(All),
    _UNITY_globalGesture_(false),
    subscription_(NULL)
{}

void Gesture::set_devices(Gesture::DeviceType new_value) {
  if (devices_ != new_value) {
    devices_ = new_value;
    emit devicesChanged();
  }
}

void Gesture::set_subscription(GeisSubscription subscription) {
  DeleteSubscription();
  subscription_ = subscription;
}

void Gesture::set_UNITY_globalGesture(bool new_value) {
  if (_UNITY_globalGesture_ != new_value) {
    _UNITY_globalGesture_ = new_value;
    emit _UNITY_globalGestureChanged();
  }
}

bool Gesture::EnableSubscription() {
  if (!subscription_) {
    qWarning("Attempted to enable non-existent subscription");
    return false;
  }

  GeisStatus status = geis_subscription_activate(subscription_);
  if (status != GEIS_STATUS_SUCCESS) {
    qWarning("Failed to enable subscription");
    return false;
  }

  return true;
}

bool Gesture::DisableSubscription() {
  if (!subscription_) {
    qWarning("Attempted to disable non-existent subscription");
    return false;
  }

  GeisStatus status = geis_subscription_deactivate(subscription_);
  if (status != GEIS_STATUS_SUCCESS) {
    qWarning("Failed to disable subscription");
    return false;
  }

  return true;
}

void Gesture::DeleteSubscription() {
  if (subscription_)
    geis_subscription_delete(subscription_);
  subscription_ = NULL;
}

Gesture::~Gesture() {
  DeleteSubscription();
}

TouchLimits::TouchLimits(QObject* parent)
  : QObject(parent),
    start_(2)
{}

void TouchLimits::set_start(int new_value) {
  if (start_ != new_value) {
    start_ = new_value;
    emit startChanged();
  }
}
