/* Copyright 2011 Canonical, Ltd. This software is licensed under the GNU
 * Lesser General Public License version 3 or later (see the file COPYING).
 */

#include "gestureevent.h"

#include "attributes.h"
#include "device.h"
#include "gesturearea.h"
#include "touch.h"

using geis_attributes::PopulateAttributeMap;

namespace {

Touch touch_pool[5];

}  // namespace

GestureEvent::GestureEvent(GestureArea* area,
                           GeisFrame frame,
                           GeisTouchSet touch_set,
                           Device* device)
  : QDeclarativeItem(area),
    gesture_(area->subscription()),
    accepted_(true),
    device_(device) {
  PopulateAttributeMap< GeisFrame >(frame, &attributes_);

  id_ = geis_frame_id(frame);

  for (GeisSize i = 0; i < geis_frame_touchid_count(frame); ++i) {
    GeisTouchId touch_id = geis_frame_touchid(frame, i);
    GeisTouch touch = geis_touchset_touch_by_id(touch_set, touch_id);

    touch_pool[i].Initialize(touch);
    touches_.append(&touch_pool[i]);
  }
}

void GestureEvent::set_accepted(bool new_value) {
  if (accepted_ != new_value) {
    accepted_ = new_value;
    emit acceptedChanged();
  }
}
