/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_RegisteredSoftwareInventoryProfile.h"

CMPIObjectPath* SoftwareInventory_OpenDRIM_RegisteredSoftwareInventoryProfile_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_RegisteredSoftwareInventoryProfile& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_RegisteredSoftwareInventoryProfile_classnames[0], OpenDRIM_RegisteredSoftwareInventoryProfile_NAMESPACE);

	if (!instance.InstanceID_isNULL)
		op.addKey("InstanceID", instance.InstanceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* SoftwareInventory_OpenDRIM_RegisteredSoftwareInventoryProfile_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_RegisteredSoftwareInventoryProfile& instance) {
	_E_;
	Objectpath op(broker, SoftwareInventory_OpenDRIM_RegisteredSoftwareInventoryProfile_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.RegisteredOrganization_isNULL)
		ci.setProperty("RegisteredOrganization", instance.RegisteredOrganization);

	if (!instance.OtherRegisteredOrganization_isNULL)
		ci.setProperty("OtherRegisteredOrganization", instance.OtherRegisteredOrganization);

	if (!instance.RegisteredName_isNULL)
		ci.setProperty("RegisteredName", instance.RegisteredName);

	if (!instance.RegisteredVersion_isNULL)
		ci.setProperty("RegisteredVersion", instance.RegisteredVersion);

	if (!instance.AdvertiseTypes_isNULL)
		ci.setProperty("AdvertiseTypes", instance.AdvertiseTypes);

	if (!instance.AdvertiseTypeDescriptions_isNULL)
		ci.setProperty("AdvertiseTypeDescriptions", instance.AdvertiseTypeDescriptions);

	_L_;
	return ci.getHdl();
}

void SoftwareInventory_OpenDRIM_RegisteredSoftwareInventoryProfile_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_RegisteredSoftwareInventoryProfile& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	_L_;
}

void SoftwareInventory_OpenDRIM_RegisteredSoftwareInventoryProfile_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_RegisteredSoftwareInventoryProfile& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("RegisteredOrganization", instance.RegisteredOrganization) == OK)
		instance.RegisteredOrganization_isNULL = false;

	if (inst.getProperty("OtherRegisteredOrganization", instance.OtherRegisteredOrganization) == OK)
		instance.OtherRegisteredOrganization_isNULL = false;

	if (inst.getProperty("RegisteredName", instance.RegisteredName) == OK)
		instance.RegisteredName_isNULL = false;

	if (inst.getProperty("RegisteredVersion", instance.RegisteredVersion) == OK)
		instance.RegisteredVersion_isNULL = false;

	if (inst.getProperty("AdvertiseTypes", instance.AdvertiseTypes) == OK)
		instance.AdvertiseTypes_isNULL = false;

	if (inst.getProperty("AdvertiseTypeDescriptions", instance.AdvertiseTypeDescriptions) == OK)
		instance.AdvertiseTypeDescriptions_isNULL = false;

	_L_;
}

