\name{predictValuesLm}
\alias{predictValuesLm}
\title{Predicts values through a linear model}
\description{
This ROT function, called from a LinearModel C++ object, and given a       
sample, is used to predict the corresponding values through the linear     
model. It returns the predicted sample.                                    
}
\usage{
predictValuesLm(x, beta)
}
\arguments{
  \item{x}{A m-by-n matrix containing the explanatory variables.}
  \item{beta}{A n-by-1 vector containng the linear model parameters.}
}
\value{
A m-by-1 vector is returned, containing the predicted values.}
\details{
As it is not asked in LinearModel.getPredict(), no prediction interval 
is returned; it is up to the user to be careful about that. It is also to  
noted that the sample is not assumed to contain the '1's corresponding to  
the intercept parameter.
}
\author{Pierre-Matthieu Pair, Softia for EDF.}
\examples{
set.seed(1)
x <- matrix(runif(40), 10, 4)
r <- matrix(c(1,2,3,4), 4, 1)
y <- x \%*\% r + matrix(rnorm(10, 0, 0.05), 10, 1)
LM <- computeLinearModel(x, y)
predictValuesLm(x, LM$parameterEstimate) 
}
\keyword{multivariate}
