##############################################################################
# Local Security Check Automation Framework
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Revision 1.0
# Date: 2009/01/30
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

import unittest
from parser import fedora


class FedoraParserTestCase(unittest.TestCase):

    ## Initial Setup
    fedora_parser_obj = fedora.Parser()

    def setUp(self):
        ptr = open('./test/unit_test/work/input/msg00905.html', 'r')
        lines = ptr.readlines()
        ptr.close

        self.Html_content = "".join(lines)
        setattr(self.fedora_parser_obj, 'Html_content', self.Html_content)


    def test_getCVE(self):
        print "\nTesting Fedora Parser Test Suite ..."
        req_out_put = 'CVE-2008-0412", "CVE-2008-0413", "CVE-2008-0415", "CVE-2008-0419", "CVE-2008-0591", "CVE-2008-0593", "CVE-2008-0418", "CVE-2008-0592", "CVE-2008-0304", "CVE-2008-0420'

        out_put = self.fedora_parser_obj.getCVE()
        self.assertEquals(out_put, req_out_put)


    def test_getAdvID(self):
        req_out_put = 'FEDORA-2008-2060'

        out_put = self.fedora_parser_obj.getAdvID()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedPackage(self):
        req_out_put = 'thunderbird'

        out_put = self.fedora_parser_obj.getAffectedPackage()
        self.assertEquals(out_put, req_out_put)


    def test_getDescription1(self):
        req_out_put = "  Mozilla Thunderbird is a standalone mail and newsgroup client.\n"

        out_put = self.fedora_parser_obj.getDescription()
        self.assertEquals(out_put, req_out_put)

    def test_getDescription2(self):
        ptr = open('./test/unit_test/work/input/msg00038.html', 'r')
        lines = ptr.readlines()
        ptr.close

        Html_content = "".join(lines)
        setattr(self.fedora_parser_obj, 'Html_content', Html_content)

        req_out_put = "  Core applications for the K Desktop Environment.  Included are: kdm\n  (replacement for xdm), kwin (window manager), konqueror (filemanager,\n  web browser, ftp client, ...), konsole (xterm replacement), kpanel\n  (application starter and desktop pager), kaudio (audio server),\n  kdehelp (viewer for kde help files, info and man pages), kthememgr\n  (system for managing alternate theme packages) plus other KDE\n  components (kcheckpass, kikbd, kscreensaver, kcontrol, kfind,\n  kfontmanager, kmenuedit)\n"

        out_put = self.fedora_parser_obj.getDescription()
        self.assertEquals(out_put, req_out_put)


    def test_getDescription3(self):
        ptr = open('./test/unit_test/work/input/msg00740.html', 'r')
        lines = ptr.readlines()
        ptr.close

        Html_content = "".join(lines)
        setattr(self.fedora_parser_obj, 'Html_content', Html_content)

        req_out_put = "  Clam AntiVirus is an anti-virus toolkit for UNIX. The main purpose of this\n  software is the integration with mail servers (attachment scanning). The\n  package provides a flexible and scalable multi-threaded daemon, a command\n  line scanner, and a tool for automatic updating via Internet. The programs\n  are based on a shared library distributed with the Clam AntiVirus package,\n  which you can use with your own software. The virus database is based on\n  the virus database from OpenAntiVirus, but contains additional signatures\n  (including signatures for popular polymorphic viruses, too) and is KEPT UP\n  TO DATE.\n"

        out_put = self.fedora_parser_obj.getDescription()
        self.assertEquals(out_put, req_out_put)


    def test_getDescription4(self):
        ptr = open('./test/unit_test/work/input/msg00957.html', 'r')
        lines = ptr.readlines()
        ptr.close

        Html_content = "".join(lines)
        setattr(self.fedora_parser_obj, 'Html_content', Html_content)

        req_out_put = "  This package contains the Xen hypervisor and Xen tools, needed to\n  run virtual machines on x86 systems, together with the kernel-xen*\n  packages.  Information on how to use Xen can be found at the Xen\n  project pages.\n  \n  Virtualisation can be used to run multiple versions or multiple\n  Linux distributions on one system, or to test untrusted applications\n  in a sandboxed environment.\n" 

        out_put = self.fedora_parser_obj.getDescription()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedProduct(self):
        req_out_put = ['Fedora 8']

        out_put = self.fedora_parser_obj.getAffectedProduct()
        self.assertEquals(out_put, req_out_put)


    def test_getRPM(self):
        req_out_put = {'FC8': ['thunderbird-2.0.0.12-1.fc8']}

        prod_list = ['Fedora 8']
        out_put = self.fedora_parser_obj.getRPM(prod_list)
        self.assertEquals(out_put, req_out_put)


    def test_formatReference1(self):
        req_out_put = 'https://www.redhat.com/archives/fedora-package-announce/2007-December/msg00890.html'

        main_url = 'https://www.redhat.com/archives/fedora-package-announce/'
        file_name = '2007-December_msg00890.html'
        out_put = self.fedora_parser_obj.formatReference(main_url, file_name)
        self.assertEquals(out_put, req_out_put)


    def test_formatReference2(self):
        req_out_put = 'https://www.redhat.com/archives/fedora-package-announce/2007-December/msg00890.html'

        main_url = 'https://www.redhat.com/archives/fedora-package-announce'
        file_name = '2007-December_msg00890.html'
        out_put = self.fedora_parser_obj.formatReference(main_url, file_name)
        self.assertEquals(out_put, req_out_put)


    def test_parser(self):
        req_out_put = True

        prod_list = ['Fedora 8']
        setattr(self.fedora_parser_obj, 'Platforms', prod_list)
        out_put = self.fedora_parser_obj.parser(self.Html_content)
        self.assertEquals(out_put, req_out_put)


    def test_getYearLinks(self):
        req_out_put = ['https://www.redhat.com/archives/fedora-package-announce/2009-February/thread.html', 'https://www.redhat.com/archives/fedora-package-announce/2009-January/thread.html']

        link = './test/unit_test/work/input/fedora-advisory-main.html'
        year = '2009'
        out_put = self.fedora_parser_obj._getYearLinks(link, year)
        self.assertEquals(out_put, req_out_put)


    def test_getEachAdvLink(self):
        req_out_put = ['https://www.redhat.com/archives/fedora-package-announce/input/msg00260.html', 'https://www.redhat.com/archives/fedora-package-announce/input/msg00221.html', 'https://www.redhat.com/archives/fedora-package-announce/input/msg00220.html', 'https://www.redhat.com/archives/fedora-package-announce/input/msg00211.html', 'https://www.redhat.com/archives/fedora-package-announce/input/msg00194.html', 'https://www.redhat.com/archives/fedora-package-announce/input/msg00188.html', 'https://www.redhat.com/archives/fedora-package-announce/input/msg00187.html', 'https://www.redhat.com/archives/fedora-package-announce/input/msg00137.html', 'https://www.redhat.com/archives/fedora-package-announce/input/msg00103.html', 'https://www.redhat.com/archives/fedora-package-announce/input/msg00096.html', 'https://www.redhat.com/archives/fedora-package-announce/input/msg00082.html', 'https://www.redhat.com/archives/fedora-package-announce/input/msg00043.html', 'https://www.redhat.com/archives/fedora-package-announce/input/msg00034.html', 'https://www.redhat.com/archives/fedora-package-announce/input/msg00025.html']

        link = './test/unit_test/work/input/2009-Feb-thread.html'
        out_put = self.fedora_parser_obj._getEachAdvLink(link)
        self.assertEquals(out_put, req_out_put)


if __name__ == '__main__':
    unittest.main()

