# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1179-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57383);
 script_cve_id("CVE-2006-4089");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1179-1 (alsaplayer)";
 script_name(name);

 desc = "The remote host is missing an update to alsaplayer
announced via advisory DSA 1179-1.

Luigi Auriemma discovered several buffer overflows in alsaplayer, a
PCM player designed for ALSA, that can lead to a crash of the
application and maybe worse outcome.

For the stable distribution (sarge) these problems have been fixed in
version 0.99.76-0.3sarge1.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you upgrade your alsaplayer package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201179-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1179-1 (alsaplayer)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"alsaplayer", ver:"0.99.76-0.3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsaplayer-alsa", ver:"0.99.76-0.3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsaplayer-common", ver:"0.99.76-0.3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsaplayer-daemon", ver:"0.99.76-0.3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsaplayer-esd", ver:"0.99.76-0.3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsaplayer-gtk", ver:"0.99.76-0.3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsaplayer-jack", ver:"0.99.76-0.3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsaplayer-nas", ver:"0.99.76-0.3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsaplayer-oss", ver:"0.99.76-0.3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsaplayer-text", ver:"0.99.76-0.3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsaplayer-xosd", ver:"0.99.76-0.3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libalsaplayer-dev", ver:"0.99.76-0.3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libalsaplayer0", ver:"0.99.76-0.3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
