# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1573-1 (rdesktop)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61023);
 script_cve_id("CVE-2008-1801", "CVE-2008-1802", "CVE-2008-1803");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1573-1 (rdesktop)";
 script_name(name);

 desc = "The remote host is missing an update to rdesktop
announced via advisory DSA 1573-1.

Several remote vulnerabilities have been discovered in rdesktop, a
Remote Desktop Protocol client. The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2008-1801

Remote exploitation of an integer underflow vulnerability allows
attackers to execute arbitrary code with the privileges of the
logged-in user.

CVE-2008-1802

Remote exploitation of a BSS overflow vulnerability allows
attackers to execute arbitrary code with the privileges of the
logged-in user.

CVE-2008-1803

Remote exploitation of an integer signedness vulnerability allows
attackers to execute arbitrary code with the privileges of the
logged-in user.


For the stable distribution (etch), these problems have been fixed in
version 1.5.0-1etch2.

For the unstable distribution (sid), these problems have been fixed in
version 1.5.0-4+cvs20071006.

We recommend that you upgrade your rdesktop package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201573-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1573-1 (rdesktop)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"rdesktop", ver:"1.5.0-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
