# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 539-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53229);
 script_cve_id("CVE-2004-0689");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 539-1 (kdelibs)";
 script_name(name);

 desc = "The remote host is missing an update to kdelibs
announced via advisory DSA 539-1.

The SUSE security team was alerted that in some cases the integrity of
symlinks used by KDE are not ensured and that these symlinks can be
pointing to stale locations.  This can be abused by a local attacker
to create or truncate arbitrary files or to prevent KDE applications
from functioning correctly.

For the stable distribution (woody) this problem has been fixed in
version 2.2.2-13.woody.12.

For the unstable distribution (sid) this problem has been fixed in
version 3.3.0-1.

We recommend that you upgrade your kde packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20539-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 539-1 (kdelibs)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdelibs3-doc", ver:"2.2.2-13.woody.12", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs-dev", ver:"2.2.2-13.woody.12", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs3", ver:"2.2.2-13.woody.12", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs3-bin", ver:"2.2.2-13.woody.12", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs3-cups", ver:"2.2.2-13.woody.12", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libarts", ver:"2.2.2-13.woody.12", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libarts-alsa", ver:"2.2.2-13.woody.12", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libarts-dev", ver:"2.2.2-13.woody.12", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkmid", ver:"2.2.2-13.woody.12", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkmid-alsa", ver:"2.2.2-13.woody.12", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkmid-dev", ver:"2.2.2-13.woody.12", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
