# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-9922 (rubygem-actionpack)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64968);
 script_cve_id("CVE-2009-3009");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Fedora Core 11 FEDORA-2009-9922 (rubygem-actionpack)");

 desc = "The remote host is missing an update to rubygem-actionpack
announced via advisory FEDORA-2009-9922.

Update Information:

A vulnerability is found on Ruby on Rails in the escaping code for the form
helpers, which also affects the rpms shipped in Fedora Project. Attackers who
can inject deliberately malformed unicode strings into the form helpers can
defeat the escaping checks and inject arbitrary HTML. This issue has been tagged
as CVE-2009-3009.    These new rpms will fix this issue.

ChangeLog:

* Wed Sep 23 2009 Mamoru Tasaka  - 2.3.3-2
- Patch for CVE-2009-3009 (bug 520843)

References:

[ 1 ] Bug #520843 - CVE-2009-3009 ruby-activesupport: XSS vulnerability
https://bugzilla.redhat.com/show_bug.cgi?id=520843

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update rubygem-actionpack' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-9922

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-9922 (rubygem-actionpack)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"rubygem-actionpack", rpm:"rubygem-actionpack~2.3.3~2.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
