#
#ADV FreeBSD-SA-05:13.ipfw.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#
                                                                                
if(description)
{
 script_id(53974);
 script_cve_id("CVE-2005-2019");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Security Advisory (FreeBSD-SA-05:13.ipfw.asc)";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-05:13.ipfw.asc

ipfw(8) is a system facility which allows IP packet filtering,
redirecting, and traffic accounting.  ipfw lookup tables are a way to
specify many IP addresses which can be used for packet matching in an
efficient manner.

The ipfw tables lookup code caches the result of the last query.  The
kernel may process multiple packets concurrently, performing several
concurrent table lookups.  Due to an insufficient locking, a cached
result can become corrupted that could cause some addresses to be
incorrectly matched against a lookup table.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-05:13.ipfw.asc
Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Security Advisory (FreeBSD-SA-05:13.ipfw.asc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"5.4", patchlevel:"3")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
