###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_phpmyadmin_sql_bookmark_xss_vuln.nasl 3226 2009-07-02 14:03:29Z jul $
#
# phpMyAdmin SQL bookmark XSS Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800595);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-2284");
  script_bugtraq_id(35543);
  script_name("phpMyAdmin SQL bookmark XSS Vulnerability");
  desc = "

  Overview: This host is running phpMyAdmin and is prone to Cross Site
  Scripting vulnerability.

  Vulnerability Insight:
  This flaw arises because the input passed into SQL bookmarks is not
  adequately sanitised before using it in dynamically generated content.
  
  Impact:
  Successful exploitation will let the attacker cause XSS attacks and
  inject malicious web script or HTML code via a crafted SQL bookmarks.

  Affected Software/OS:
  phpMyAdmin version 3.0.x to 3.2.0.rc1

  Fix:
  Apply the respective patches or upgrade to version 3.2.0.1
  http://www.phpmyadmin.net/home_page/downloads.php
  http://phpmyadmin.svn.sourceforge.net/viewvc/phpmyadmin?view=rev&revision=12608

  *****
  Note: Ignore the warning if above mentioned patches are applied.
  *****

  References:
  http://secunia.com/advisories/35649
  http://www.phpmyadmin.net/home_page/security/PMASA-2009-5.php

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of phpMyAdmin");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("secpod_phpmyadmin_detect_900129.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("version_func.inc");

pmaPort = get_kb_item("Services/www");
if(!pmaPort){
  pmaPort = 80;
}

pmaVer = get_kb_item("www/" + pmaPort + "/phpMyAdmin");
pmaVer = eregmatch(pattern:"^(.+) under (/.*)$", string:pmaVer);

if(pmaVer[1] != NULL)
{
  phpVer = ereg_replace(pattern:"-", string:pmaVer[1], replace:".");
  if(phpVer) 
  {  
    if(version_in_range(version:phpVer, test_version:"3.0",
                        test_version2:"3.2.0.rc1")){
      security_warning(pmaPort);
     }
  }
}
