###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for imagemagick vulnerabilities USN-481-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840131);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "USN", value: "481-1");
  script_cve_id("CVE-2007-1667", "CVE-2007-1797");
  script_name( "Ubuntu Update for imagemagick vulnerabilities USN-481-1");
  desc = "

  Vulnerability Insight:

  Multiple vulnerabilities were found in ImageMagick's handling of DCM and
  WXD image files.  By tricking a user into processing a specially crafted
  image with an application that uses imagemagick, an attacker could
  execute arbitrary code with the user's privileges.

  Affected Software/OS:
  imagemagick vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-July/000554.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of imagemagick vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"imagemagick", ver:"6.2.4.5.dfsg1-0.14ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmagick++9-dev", ver:"6.2.4.5.dfsg1-0.14ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmagick++9c2a", ver:"6.2.4.5.dfsg1-0.14ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmagick9-dev", ver:"6.2.4.5.dfsg1-0.14ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmagick9", ver:"6.2.4.5.dfsg1-0.14ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"perlmagick", ver:"6.2.4.5.dfsg1-0.14ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"imagemagick", ver:"6.2.4.5-0.6ubuntu0.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmagick++9-dev", ver:"6.2.4.5-0.6ubuntu0.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmagick++9c2a", ver:"6.2.4.5-0.6ubuntu0.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmagick9-dev", ver:"6.2.4.5-0.6ubuntu0.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmagick9", ver:"6.2.4.5-0.6ubuntu0.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"perlmagick", ver:"6.2.4.5-0.6ubuntu0.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"imagemagick", ver:"6.2.4.5.dfsg1-0.10ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmagick++9-dev", ver:"6.2.4.5.dfsg1-0.10ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmagick++9c2a", ver:"6.2.4.5.dfsg1-0.10ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmagick9-dev", ver:"6.2.4.5.dfsg1-0.10ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmagick9", ver:"6.2.4.5.dfsg1-0.10ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"perlmagick", ver:"6.2.4.5.dfsg1-0.10ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}