# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-770-1 (clamav)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64145);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Ubuntu USN-770-1 (clamav)";
 script_name(name);

 desc = "The remote host is missing an update to clamav
announced via advisory USN-770-1.

Details follow:

A flaw was discovered in the clamav-milter initscript which caused the
ownership of the current working directory to be changed to the 'clamav'
user. This update attempts to repair the incorrect ownership for standard
system directories, but it is recommended that the following command be
performed to report any other directories that may be affected:

  $ sudo find -H / -type d -user clamav \! -group clamav 2>/dev/null

Systems configured to run clamav as a user other than the default 'clamav'
user will need to adjust the above command accordingly.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 9.04:
  clamav-milter                   0.95.1+dfsg-1ubuntu1.2

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-770-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-770-1 (clamav)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"clamav-base", ver:"0.95.1+dfsg-1ubuntu1.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-docs", ver:"0.95.1+dfsg-1ubuntu1.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-testfiles", ver:"0.95.1+dfsg-1ubuntu1.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-daemon", ver:"0.95.1+dfsg-1ubuntu1.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-dbg", ver:"0.95.1+dfsg-1ubuntu1.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-freshclam", ver:"0.95.1+dfsg-1ubuntu1.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav", ver:"0.95.1+dfsg-1ubuntu1.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav-dev", ver:"0.95.1+dfsg-1ubuntu1.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav6", ver:"0.95.1+dfsg-1ubuntu1.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-milter", ver:"0.95.1+dfsg-1ubuntu1.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
