# Changes of Note
- PCL `--visualize` capability of the `pdal` command line application has been removed.
- `writer.derivative` has been removed. Use [gdaldem](http://www.gdal.org/gdaldem.html) for faster and more featureful equivalent functionality.
- GeoTIFF and Proj.4 are now required dependencies.
- `writers.p2g` has been removed. It was replaced by `writers.gdal` in 1.4, but the P2G writer was essentially unmaintained and we will be using the GDAL one going forward.
- `filters.attribute` was split into `filters.assign` and `filters.overlay` to separate their functionalities
- `filters.pmf` and `filters.outlier` have dropped the `classify` and `extract` options. They now only classify points and leave it downstream filters to ignore/extract classifications as needed.
- `filters.outlier` has changed the default classification for noise points from `18` to `7` to match the LAS classification code for "Low point (noise)".

# Enhancements

- `pdal pipeline` now supports a `--stream` option which will default to one-at-a-time or chunk-at-a-time point processing when all stages in the pipeline support it. You can use this option to control memory consumption -- for example when interpolating a very large file with `writers.gdal`
- `filters.crop` was enhanced to support transformed filter polygons, streaming, and radius cropping.
- `readers.greyhound` updated to support greyhound.io 1.0 release, with the most significant enhancement being support for passing downstream JSON filters.
- `user_data` JSON object can be applied to any PDAL pipeline object and it will be carried through processing. You can use this mechanism for carrying your own information in PDAL pipelines without having to sidecar data. #1427
- `writers.las` now can write `pdal_metadata` and `pdal_pipeline` VLRs for processing history tracking. #1509 #1525
- `metadata`, `schema`, and `spatialreference` objects added to global module for `filters.programmable` and `filters.predicate` Python filters.
- `pdalargs` option for `filters.programmable` and `filters.predicate` allow you to pass in a JSON dictionary to your Python module for override or modification of your script
- Stage tags can be used in pipeline override scenarios
- User-settable VLRs in `writers.las` #1542
- `filters.sort` now supports descending order and uses `std::stable_sort` #1530 (Thanks to new contributor @wrenoud )
- `pdal tindex` will now use data bounds if `filters.hexbin` cannot be loaded for boundaries #1533
- `filters.pmf` and `filters.smrf` improved performance #1531 and #1541
- `filters.assign` now supports [Range](https://www.pdal.io/stages/filters.range.html)-based filters
- `filters.outlier` now accepts a user-specified `class` to override the default value of `7` for points deemed outliers. #1545
- `filters.pmf` and `filters.smrf` now accept a [Range](https://www.pdal.io/stages/ranges.html#ranges) via the `ignore` option to specify values that should be excluded from ground segmentation. #1545
- `filters.pmf` and `filters.smrf` now consider only last returns (when return information is available) as the default behavior. The `last` option can be set to `false` to consider all returns. #1545

## Documentation

- New [About page](https://pdal.io/about.html) adapted from [workshop](https://pdal.io/workshop/)
- New [LAS reading and writing](https://pdal.io/tutorial/las.html) tutorial
- Consolidation of [Python](https://pdal.io/python.html) information

## New filters

- `filters.cluster` - Perform Euclidean cluster extraction, and label each point by its cluster ID. By @chambbj.
- `filters.groupby` - Split incoming PointView into individual PointViews categorically, e.g., by Classification. By @chambbj.
- `filters.locate` - Locate and return the point with the minimum or maximum value for a given dimension. By @chambbj.
- `filters.emf` - Extended Local Maximum filter. By @chambbj.

## New readers
- `readers.mbio` Bathymetric point cloud support for formats supported by the [MB-System](https://www.ldeo.columbia.edu/res/pi/MB-System/) software library




## Bug fixes
- `writers.pgpointcloud` needed to treat table schema correctly  https://github.com/PDAL/PDAL/pull/1540 (thanks @elemoine)
- `pdal density` kernel now supports overriding `filters.hexbin` options #1487
- Arbiter embedded library updated to support setting Curl options (certificate settings, etc).
- Provided a default value for `radius` in `writers.gdal` #1475
- `writers.ply` broken for non-standard dimensions #1556
- No EVLRs for `writers.las` for files < LAS 1.4 #1551
- LAS extra dims handling for standard PDAL dimension names #1555
- LASzip defines #1549

