/*
 * window_main_bgst.cc
 * Copyright (C) Martin Singer 2009-2013 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "window_main_bgst.h"


/*** Section : Background / Stamp *********************************************/

// Constructor
cSection_BgSt::cSection_BgSt( Gtk::Window& ref_window )
:
	Gtk::Table( 4 , 2 , false ),	// y_rows , x_columns , homogenous

	mFCButton_SourceFile( ref_window , _("Background / Stamp - Select source PDF file ...") ),				// parent_window , title
	mFCButton_BgStFile(   ref_window , _("Background / Stamp - Select background or stamp PDF file ...") ),
	mFCDialog_SaveAs(     ref_window , _("Background / Stamp - Save output PDF file as ...") ),

	mLabel_SourceFile( _("Source file:") , Gtk::ALIGN_END , Gtk::ALIGN_CENTER , false ),	// label , xalign , yalign , mnemonic
	mLabel_BgStFile(   _("Insert file:") , Gtk::ALIGN_END , Gtk::ALIGN_CENTER , false ),
	mLabel_Insert(     _("Insert as:")   , Gtk::ALIGN_END , Gtk::ALIGN_CENTER , false ),
	mLabel_Multiple(   _("Multiple:")    , Gtk::ALIGN_END , Gtk::ALIGN_CENTER , false ),

	mRBGroup_BgSt( mRButton_Background.get_group() ),
	mRButton_Background(	mRBGroup_BgSt , _("Background")	, false ),	// group , label , mnemonic
	mRButton_Stamp(			mRBGroup_BgSt , _("Stamp")		, false ),

//	vPageNumbers_SourceFile( 0 ),
	vPageNumbers_BgStFile( 0 )
{
	mHBox_Insert.set_spacing( Pdfchain::SPACING );
	mHBox_Insert.pack_start( mRButton_Background , false , false , 0 );	// widget , expand , fill , padding
	mHBox_Insert.pack_start( mRButton_Stamp      , false , false , 0 );

	mFCButton_SourceFile.set_halign( Gtk::ALIGN_START );
	mHBox_Insert.set_halign( Gtk::ALIGN_START );
	mFCButton_BgStFile.set_halign( Gtk::ALIGN_START );
	mSwitch_Multiple.set_halign( Gtk::ALIGN_START );

	set_spacings( Pdfchain::SPACING );
	attach( mLabel_SourceFile    , 0 , 1 , 0 , 1 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , 0 , 0 );	// row 0 -> 1
	attach( mFCButton_SourceFile , 1 , 2 , 0 , 1 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , 0 , 0 );
	attach( mLabel_BgStFile	     , 0 , 1 , 1 , 2 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , 0 , 0 );	// row 2 -> 3
	attach( mFCButton_BgStFile   , 1 , 2 , 1 , 2 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , 0 , 0 );
	attach( mLabel_Insert        , 0 , 1 , 2 , 3 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , 0 , 0 );	// row 1 -> 2
	attach( mHBox_Insert         , 1 , 2 , 2 , 3 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , 0 , 0 );
	attach( mLabel_Multiple      , 0 , 1 , 3 , 4 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , 0 , 0 );	// row 3 -> 4
	attach( mSwitch_Multiple     , 1 , 2 , 3 , 4 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , 0 , 0 );

//	mFCButton_SourceFile.signal_file_set().connect( sigc::mem_fun(
//		*this , &cSection_BgSt::onFCButton_SourceFile_file_set ) );
		
	mFCButton_BgStFile.signal_file_set().connect( sigc::mem_fun(
		*this , &cSection_BgSt::onFCButton_BgStFile_file_set ) );

	init();
}


// Destructor
cSection_BgSt::~cSection_BgSt()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cSection_BgSt()::~cSection_BgSt()";	//TEST
#endif
}


// Method (public) : clear
void
cSection_BgSt::clear()
{
	init();
	
//	vPageNumbers_SourceFile = 0;
	vPageNumbers_BgStFile   = 0;
	
	return;
}


// Method (public) : create command
std::string
cSection_BgSt::createCommand()
{
	std::string str_command		= "";
	std::string str_sourcefile	= "";
	std::string str_bgstfile	= "";
	std::string str_targetfile	= "";

	if ( "" != ( str_sourcefile = mFCButton_SourceFile.get_filename() ) ) {
		if ( "" != ( str_bgstfile = mFCButton_BgStFile.get_filename() ) ) {

			switch ( mFCDialog_SaveAs.run() ) {
				case Gtk::RESPONSE_OK:
					mFCDialog_SaveAs.hide();

					if ( "" != ( str_targetfile = mFCDialog_SaveAs.get_filename() ) ) {
						str_command = " " + Pdfchain::quote_path( str_sourcefile );

						switch ( mRButton_Background.get_active() ) {
							case true:

								switch ( mSwitch_Multiple.get_active() ) {
									case true:	str_command += " " + Pdfchain::Cmd::BACKGROUND_MULTI;	break;
									case false:	str_command += " " + Pdfchain::Cmd::BACKGROUND;			break;
								}
								break;
							case false:

								switch ( mSwitch_Multiple.get_active() ) {
									case true:	str_command += " " + Pdfchain::Cmd::STAMP_MULTI;		break;
									case false:	str_command += " " + Pdfchain::Cmd::STAMP;				break;
								}
								break;
						}

						str_command += " " + Pdfchain::quote_path( str_bgstfile );
						str_command += " " + Pdfchain::Cmd::OUTPUT;
						str_command += " " + Pdfchain::quote_path( str_targetfile );
					}
					break;
					
				default:
					mFCDialog_SaveAs.hide();
					break;
			}
		}
	}
	
	return str_command;
}


// Method (protected) : init
void
cSection_BgSt::init()
{
	mFCButton_SourceFile.unselect_all();
	mFCButton_BgStFile.unselect_all();
	mRButton_Background.set_active( true );
	mSwitch_Multiple.set_active( false );
	
	return;
}
