\newpage

# References

This section contains reference links used throughout the manual.

## External Links

- **pgagroal**: https://github.com/pgagroal/pgagroal
- **PostgreSQL**: https://www.postgresql.org
- **Rocky Linux**: https://www.rockylinux.org
- **Fedora**: https://getfedora.org/
- **RHEL**: https://www.redhat.com/en/technologies/linux-platforms/enterprise-linux
- **AppStream**: https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/8/html/installing_managing_and_removing_user-space_components/using-appstream_using-appstream
- **FreeBSD**: https://www.freebsd.org/
- **OpenBSD**: http://www.openbsd.org/
- **GCC**: https://gcc.gnu.org
- **CMake**: https://cmake.org
- **Make**: https://www.gnu.org/software/make/
- **libev**: http://software.schmorp.de/pkg/libev.html
- **OpenSSL**: http://www.openssl.org/
- **systemd**: https://www.freedesktop.org/wiki/Software/systemd/
- **rst2man**: https://docutils.sourceforge.io/
- **Pandoc**: https://pandoc.org/
- **Pandoc LaTeX Template**: https://github.com/Wandmalfarbe/pandoc-latex-template
- **TeX Live**: https://www.tug.org/texlive/
- **Clang**: https://clang.llvm.org/
- **Git Squash Guide**: https://www.git-tower.com/learn/git/faq/git-squash
- **ProGit Book**: https://github.com/progit/progit2/releases
- **Prometheus**: https://prometheus.io/
- **Wireshark**: https://www.wireshark.org/
- **pgprtdbg**: https://github.com/jesperpedersen/pgprtdbg
- **ART Paper**: http://www-db.in.tum.de/~leis/papers/ART.pdf
- **libart**: https://github.com/armon/libart

## Documentation

- **Manual (English)**: https://github.com/pgagroal/pgagroal/tree/master/doc/manual/en
- **Main Documentation Folder**: https://github.com/pgagroal/pgagroal/tree/master/doc
- **RPM Documentation**: https://github.com/pgagroal/pgagroal/blob/master/doc/RPM.md
- **Configuration Documentation**: https://github.com/pgagroal/pgagroal/blob/master/doc/CONFIGURATION.md

## Configuration Examples

- **Configuration Examples Folder**: https://github.com/pgagroal/pgagroal/tree/master/doc/etc
- **Sample Configuration**: https://github.com/pgagroal/pgagroal/blob/master/doc/etc/pgagroal.conf
- **HBA Configuration**: https://github.com/pgagroal/pgagroal/blob/master/doc/etc/pgagroal_hba.conf
- **Vault Configuration**: https://github.com/pgagroal/pgagroal/blob/master/doc/etc/pgagroal_vault.conf

## Source Code

### Main Source Files
- **main.c**: https://github.com/pgagroal/pgagroal/blob/master/src/main.c
- **cli.c**: https://github.com/pgagroal/pgagroal/blob/master/src/cli.c
- **admin.c**: https://github.com/pgagroal/pgagroal/blob/master/src/admin.c
- **vault.c**: https://github.com/pgagroal/pgagroal/blob/master/src/vault.c

### Include Files
- **shmem.h**: https://github.com/pgagroal/pgagroal/blob/master/src/include/shmem.h
- **pgagroal.h**: https://github.com/pgagroal/pgagroal/blob/master/src/include/pgagroal.h
- **message.h**: https://github.com/pgagroal/pgagroal/blob/master/src/include/message.h
- **network.h**: https://github.com/pgagroal/pgagroal/blob/master/src/include/network.h
- **memory.h**: https://github.com/pgagroal/pgagroal/blob/master/src/include/memory.h
- **management.h**: https://github.com/pgagroal/pgagroal/blob/master/src/include/management.h
- **remote.h**: https://github.com/pgagroal/pgagroal/blob/master/src/include/remote.h
- **prometheus.h**: https://github.com/pgagroal/pgagroal/blob/master/src/include/prometheus.h
- **logging.h**: https://github.com/pgagroal/pgagroal/blob/master/src/include/logging.h
- **value.h**: https://github.com/pgagroal/pgagroal/blob/master/src/include/value.h
- **deque.h**: https://github.com/pgagroal/pgagroal/blob/master/src/include/deque.h
- **art.h**: https://github.com/pgagroal/pgagroal/blob/master/src/include/art.h
- **json.h**: https://github.com/pgagroal/pgagroal/blob/master/src/include/json.h

### Library Implementation Files
- **message.c**: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/message.c
- **network.c**: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/network.c
- **memory.c**: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/memory.c
- **remote.c**: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/remote.c
- **prometheus.c**: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/prometheus.c
- **logging.c**: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/logging.c
- **value.c**: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/value.c
- **deque.c**: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/deque.c
- **art.c**: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/art.c
- **json.c**: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/json.c

## Contributing

- **Ask Questions**: https://github.com/pgagroal/pgagroal/discussions
- **Report Issues**: https://github.com/pgagroal/pgagroal/issues
- **Feature Requests**: https://github.com/pgagroal/pgagroal/issues
- **Submit Code**: https://github.com/pgagroal/pgagroal/pulls
- **Code of Conduct**: https://github.com/pgagroal/pgagroal/blob/master/CODE_OF_CONDUCT.md
- **Star the Project**: https://github.com/pgagroal/pgagroal/stargazers
- **Follow on Twitter**: https://twitter.com/pgagroal/
- **BSD-3-Clause License**: https://opensource.org/licenses/BSD-3-Clause

<!-- Reference links -->

  [pgagroal]: https://github.com/pgagroal/pgagroal
  [postgresql]: https://www.postgresql.org
  [rocky]: https://www.rockylinux.org
  [fedora]: https://getfedora.org/
  [rhel]: https://www.redhat.com/en/technologies/linux-platforms/enterprise-linux
  [appstream]: https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/8/html/installing_managing_and_removing_user-space_components/using-appstream_using-appstream
  [freebsd]: https://www.freebsd.org/
  [openbsd]: http://www.openbsd.org/
  [gcc]: https://gcc.gnu.org
  [cmake]: https://cmake.org
  [make]: https://www.gnu.org/software/make/
  [libev]: http://software.schmorp.de/pkg/libev.html
  [openssl]: http://www.openssl.org/
  [systemd]: https://www.freedesktop.org/wiki/Software/systemd/
  [rst2man]: https://docutils.sourceforge.io/
  [pandoc]: https://pandoc.org/
  [pandoc_latex_template]: https://github.com/Wandmalfarbe/pandoc-latex-template
  [texlive]: https://www.tug.org/texlive/
  [clang]: https://clang.llvm.org/
  [git_squash]: https://www.git-tower.com/learn/git/faq/git-squash
  [progit]: https://github.com/progit/progit2/releases
  [prometheus]: https://prometheus.io/
  [wireshark]: https://www.wireshark.org/
  [pgprtdbg]: https://github.com/jesperpedersen/pgprtdbg
  [ART_paper]: http://www-db.in.tum.de/~leis/papers/ART.pdf
  [libart]: https://github.com/armon/libart
  [podman]: https://podman.io/

<!-- doc/ -->
[rpm]: https://github.com/pgagroal/pgagroal/blob/master/doc/RPM.md
[configuration]: https://github.com/pgagroal/pgagroal/blob/master/doc/CONFIGURATION.md
[sample]: https://github.com/pgagroal/pgagroal/blob/master/doc/etc/pgagroal.conf

<!-- src/ -->
[main_c]: https://github.com/pgagroal/pgagroal/blob/master/src/main.c
[cli_c]: https://github.com/pgagroal/pgagroal/blob/master/src/cli.c
[admin_c]: https://github.com/pgagroal/pgagroal/blob/master/src/admin.c
[vault_c]: https://github.com/pgagroal/pgagroal/blob/master/src/vault.c
<!-- src/include -->
[shmem_h]: https://github.com/pgagroal/pgagroal/blob/master/src/include/shmem.h
[pgagroal_h]: https://github.com/pgagroal/pgagroal/blob/master/src/include/pgagroal.h
[messge_h]: https://github.com/pgagroal/pgagroal/blob/master/src/include/message.h
[network_h]: https://github.com/pgagroal/pgagroal/blob/master/src/include/network.h
[memory_h]: https://github.com/pgagroal/pgagroal/blob/master/src/include/memory.h
[management_h]: https://github.com/pgagroal/pgagroal/blob/master/src/include/management.h
[remote_h]: https://github.com/pgagroal/pgagroal/blob/master/src/include/remote.h
[prometheus_h]: https://github.com/pgagroal/pgagroal/blob/master/src/include/prometheus.h
[logging_h]: https://github.com/pgagroal/pgagroal/blob/master/src/include/logging.h
[value_h]: https://github.com/pgagroal/pgagroal/blob/master/src/include/value.h
[deque_h]: https://github.com/pgagroal/pgagroal/blob/master/src/include/deque.h
[art_h]: https://github.com/pgagroal/pgagroal/blob/master/src/include/art.h
[json_h]: https://github.com/pgagroal/pgagroal/blob/master/src/include/json.h
<!-- src/libpgagroal -->
[message_c]: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/message.c
[network_c]: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/network.c
[memory_c]: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/memory.c
[remote_c]: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/remote.c
[prometheus_c]: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/prometheus.c
[logging_c]: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/logging.c
[value_c]: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/value.c
[deque_c]: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/deque.c
[art_c]: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/art.c
[json_c]: https://github.com/pgagroal/pgagroal/blob/master/src/libpgagroal/json.c

<!-- Contributing -->
[ask]: https://github.com/pgagroal/pgagroal/discussions
[issue]: https://github.com/pgagroal/pgagroal/issues
[request]: https://github.com/pgagroal/pgagroal/issues
[submission]: https://github.com/pgagroal/pgagroal/pulls
[conduct]: https://github.com/pgagroal/pgagroal/blob/master/CODE_OF_CONDUCT.md
[star]: https://github.com/pgagroal/pgagroal/stargazers
[twitter]: https://twitter.com/pgagroal/
[license]: https://opensource.org/licenses/BSD-3-Clause
