# NaCl example with random direction displacements.

The supercells with random displacements were created by

```
% phonopy --rd 10 --dim 2 2 2 --pa auto --amplitude 0.03 -c POSCAR-unitcell
```

After extracting `force-calcs.tar.xz`, `FORSE_SETS` is generated by

```
% phonopy -f force-calcs/disp-{001..010}/vasprun.xml
```

where displacements information is read from `phonopy_disp.yaml`.

With random displacements, force constants have to be computed using an external
force constants calculator. With installed ALM (https://github.com/ttadano/ALM),
phonon calculation can be performed with `--alm` option, e.g.,

```
% phonopy --nac --band auto -p --alm
```
