/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <src/global/global.h>

#include <src/donnees/general/general.h>
#include <src/planfacile/planfacile.h>

#define SORTIEERREUR	stderr

STOCKAGE(General) general;
/* Structure gnrale de planfacile.
 * Elle doit obligatoirement s'appeller
 * 'general', puisque diverses passes
 * dclarent cette variable en 'extern'.
 */

int main(int argc , char *argv[])
{
	switch(planfacile_planfacile(T_S(general),argc,argv))
	{
		case RESULTAT_OK:
			return 0;
			break;
		case RESULTAT_ERREUR:
			fprintf(SORTIEERREUR,"*** Exception : Mistake in one algorithm ***\n");
			break;
		case RESULTAT_ERREUR_MEMOIRE:
			fprintf(SORTIEERREUR,"*** Exception : Insufficient memory ***\n");
			break;
		case RESULTAT_ERREUR_DOMAINE:
			fprintf(SORTIEERREUR,"*** Exception : Wrong value in data storage ***\n" );
			break;
		case RESULTAT_ERREUR_DEPASSEMENT:
			fprintf(SORTIEERREUR,"*** Exception : Wrong index value ***\n" );
			break;
		case RESULTAT_ERREUR_TAILLE:
			fprintf(SORTIEERREUR,"*** Exception : Unmatched data storage size ***\n" );
			break;
		case RESULTAT_ERREUR_NONTROUVE:
			fprintf(SORTIEERREUR,"*** Exception : Element not found in data storage ***\n" );
			break;
		default:
			fprintf(SORTIEERREUR,"*** Exception : Unexpected error ***\n");
			break;
	}
	fprintf(SORTIEERREUR,"Congratulations  !  You  just  have found  a bug  in  PlanFacile...\n");
	fprintf(SORTIEERREUR,"If  this  bug  is  permanent  and  unknown,  send  your  source  to\n");
	fprintf(SORTIEERREUR,"planfacile@gmail.com, or just notify the position of the exception,\n");
	fprintf(SORTIEERREUR,"if the content  of your  source is confidential.  You might have to\n");
	fprintf(SORTIEERREUR,"recompile  PlanFacile  in debug mode  and  run it  with a debugger.\n\n");
	return 2;
}
