/* Tic-Tac-Toe plasmoid
 * Copyright (C) 2009 Mauro E. Bender <mbender@dc.uba.ar>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef _TICTACTOE_H
#define _TICTACTOE_H

#include <string>

enum GameStatus{ INGAME, TIE, WINNER };

class Tictactoe {
	public:
		Tictactoe(std::string = "Player 1", std::string = "Player 2");
		Tictactoe( const Tictactoe& );
		
		int getValue(int, int) const;
		void setValue(int, int, int);
		
		void setPlayerName(int, std::string );
		std::string getPlayerName(int ) const;
		
		void touch(int, int);
		GameStatus gameStatus();
		bool hasWinner();
		std::string winner();
		
		void reset();
		
		std::string currentPlayer() const;
		Tictactoe& operator=( const Tictactoe& );
	private:
		int _grid[3][3];
		GameStatus _status;
		void checkWinner();
		
		std::string _players[2];
		int _currentPlayer;
};

#endif