dnl This is m4 source.
dnl Process using m4 to produce 'C' language file.
dnl
dnl This file is supposed to be the same as PnetCDF's test_put.m4
dnl
dnl If you see this line, you can ignore the next one.
/* Do not edit this file. It is produced from the corresponding .m4 source */
dnl
/*
 *  Copyright (C) 2003, Northwestern University and Argonne National Laboratory
 *  See COPYRIGHT notice in top-level directory.
 */
/* $Id: tests.h.m4 3558 2017-11-23 01:44:31Z wkliao $ */

#ifndef TESTS_H
#define TESTS_H

#ifdef HAVE_CONFIG_H
#include <config.h> /* output of 'configure' */
#endif

define(`IntType', `ifdef(`PNETCDF',`MPI_Offset',`size_t')')dnl
define(`TestFunc',`ifdef(`PNETCDF',`test_ncmpi_put_$1',`test_nc_put_$1')')dnl
define(`APIFunc',` ifdef(`PNETCDF',`ncmpi_$1',`nc_$1')')dnl

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <limits.h>
#include <float.h>
#define NO_NETCDF_2 1
#include <errno.h>
#include <mpi.h>

#include <pnetcdf.h>
#include <testutils.h>
#include "error.h"

#if defined(_CRAY) && !defined(_CRAYIEEE)
#define CRAYFLOAT 1 /* CRAY Floating point */
#elif defined(_SX) && defined(_FLOAT2)	/* NEC SUPER-UX in CRAY mode */
#define CRAYFLOAT 1 /* CRAY Floating point */
#endif

/* Limits of external types (based on those in ncx.h) */

/* Note: In CDF format specification, NC_CHAR is for text characters, which
 * is considered an 8-bit unsigned integer. Since it is for printable text
 * characters, its values should range from 0 (X_CHAR_MIN) to 255 (X_CHAR_MAX).
 */
#define X_CHAR_MIN	0
#define X_CHAR_MAX	255

#define X_SCHAR_MIN     (-128)
#define X_SCHAR_MAX     127
#define X_UCHAR_MAX     255
#define X_UCHAR_MIN     0
#define X_BYTE_MIN	X_SCHAR_MIN
#define X_BYTE_MAX	X_SCHAR_MAX
#define X_SHORT_MIN	(-32768)
#define X_SHORT_MAX	32767
#define X_INT_MIN	(-2147483647-1)
#define X_INT_MAX	2147483647
#if defined(FLT_MAX_EXP) && FLT_MAX_EXP < 128
/* FLT_MAX < X_FLOAT_MAX */
#define X_FLOAT_MAX	FLT_MAX
#else
#define X_FLOAT_MAX	3.40282347e+38f
#endif
#define X_FLOAT_MIN	(-X_FLOAT_MAX)
#if defined(CRAYFLOAT) && CRAYFLOAT != 0
/* ldexp(1. - ldexp(.5 , -46), 1024) */
#define X_DOUBLE_MAX    1.79769313486230e+308
#else
/* scalb(1. - scalb(.5 , -52), 1024) */
#define X_DOUBLE_MAX	DBL_MAX
#endif
#define X_DOUBLE_MIN	-(DBL_MAX)

#define X_UBYTE_MAX     X_UCHAR_MAX
#define X_UBYTE_MIN     X_UCHAR_MIN
#define X_USHORT_MAX    65535U
#define X_USHORT_MIN    0
#define X_UINT_MAX      4294967295U
#define X_UINT_MIN      0

#ifndef LLONG_MAX
#define LLONG_MAX  0x7fffffffffffffffLL
#endif
#ifndef LLONG_MIN
#define LLONG_MIN (-0x7fffffffffffffffLL-1)
#endif
#ifndef ULLONG_MAX
#define ULLONG_MAX  0xffffffffffffffffULL
#endif

#ifndef X_INT64_MAX
#define X_INT64_MAX    LLONG_MAX
#endif
#ifndef X_INT64_MIN
#define X_INT64_MIN    LLONG_MIN
#endif
#ifndef X_UINT64_MAX
#define X_UINT64_MAX  ULLONG_MAX
#endif
#ifndef X_UINT64_MIN
#define X_UINT64_MIN  ULLONG_MIN
#endif


#if defined(_SX) && _SX != 0 /* NEC SUPER UX */
#if _INT64
#undef  INT_MAX /* workaround cpp bug */
#define INT_MAX  X_INT_MAX
#undef  INT_MIN /* workaround cpp bug */
#define INT_MIN  X_INT_MIN
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  X_INT_MAX
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN  X_INT_MIN
#elif _LONG64
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  4294967295L
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN -4294967295L
#endif
#endif /* _SX */


#ifndef MAX
#define MAX(a,b) ((a) > (b) ? (a) : (b))
#endif /* MAX */

#ifndef MIN
#define MIN(a,b) ((a) < (b) ? (a) : (b))
#endif /* MIN */

#ifndef ABS
#define ABS(x)  ((x) < 0 ? -(x) : (x))
#endif /* ABS */

    /* Parameters of test data */

#define NTYPES      11   /* number of nc_types to test */
#define NDIMS        5
#define NRECS        2
#define NGATTS       NTYPES
#define RECDIM       0
#define MAX_RANK     3
#define MAX_NELS    64
#define MAX_DIM_LEN  4
#define MAX_NATTS    3
/*
 *  #define NVARS 136   when NTYPES==6
 *  #define NVARS 142   when NTYPES==7
 *  #define NVARS 148   when NTYPES==8
 *  #define NVARS 154   when NTYPES==9
 *  #define NVARS 160   when NTYPES==10
 *  #define NVARS 166   when NTYPES==11
 *  c:char, b:byte, s:short, i:int, f:float, d:double, y:ubyte, t:ushort,
 *  u:uint, x:int64, z:uint64
 */
#define NVARS 166

/* Here is how NVARS is acalculated in init_gvars().
MAX_RANK=3
MAX_DIM_LEN==4
max_dim_len[MAX_RANK] = {MAX_DIM_LEN +1, MAX_DIM_LEN, MAX_DIM_LEN };
rank==0, nvars=1      ntypes=NTYPES  (if rank < 2)
rank==1, nvars=5      ntypes=NTYPES  (if rank < 2)
rank==2, nvars=5*4    ntypes=1       (if rank >= 2)
rank==3, nvars=5*4*4  ntypes=1       (if rank >= 2)
nv=1* 6+5* 6+5*4+5*4*4= 6+30+20+80 = 136 (if NTYPES==6)
nv=1* 7+5* 7+5*4+5*4*4= 7+35+20+80 = 142 (if NTYPES==7)
nv=1* 8+5* 8+5*4+5*4*4= 8+40+20+80 = 148 (if NTYPES==8)
nv=1* 9+5* 9+5*4+5*4*4= 9+45+20+80 = 154 (if NTYPES==9)
nv=1*10+5*10+5*4+5*4*4=10+50+20+80 = 160 (if NTYPES==10)
nv=1*11+5*11+5*4+5*4*4=11+55+20+80 = 166 (if NTYPES==11)
*/

/* Limits of internal types */

/* Remove the use of text_min and text_max, becuase in NetCDF, there is no
 * situation that would cause to check the range of a text or NC_CHAR value.
 * In netCDF, a NC_CHAR variable must be read/written/created by netCDF text
 * APIs. Otherwise, NC_ECHAR error will return. In the text APIs, the user
 * buffers will be treated as a text array. For put APIs, a local signed char
 * value (if the local char is signed) will be type-casted to an unsigned char
 * value before writing to the file. For get APIs, an external unsigned char
 * (NC_CHAR) value will be type-casted to a local signed char value. If the
 * local char is unsigned, then no type casting will even happen. Also note
 * that netCDF text APIs never returns NC_ERANGE error code.

#define text_min CHAR_MIN
#define text_max CHAR_MAX
*/

#define uchar_min     0
#define schar_min     SCHAR_MIN
#define short_min     SHRT_MIN
#define int_min       INT_MIN
#define long_min      LONG_MIN
#define float_min     (-FLT_MAX)
#define double_min    (-DBL_MAX)
#define ushort_min    0
#define uint_min      0
#define ulong_min     0
#define int64_min     LLONG_MIN
#define longlong_min  int64_min
#define uint64_min    0
#define ulonglong_min uint64_min

#define uchar_max     UCHAR_MAX
#define schar_max     SCHAR_MAX
#define short_max     SHRT_MAX
#define int_max       INT_MAX
#define long_max      LONG_MAX
#define float_max     FLT_MAX
#define double_max    DBL_MAX
#define ushort_max    USHRT_MAX
#define uint_max      UINT_MAX
#define ulong_max     ULONG_MAX
#define int64_max     LLONG_MAX
#define longlong_max  int64_max
#define uint64_max    ULLONG_MAX
#define ulonglong_max uint64_max



    /* Examples of invalid argument values */

#define BAD_ID -1               /* invalid netCDF ID */
#define BAD_DIMID -1            /* invalid dim ID */
#define BAD_VARID -2            /* invalid var ID */
#define BAD_ATTNUM -1           /* invalid att number */
#define BAD_TYPE (nc_type) 0    /* invalid data type */
#define BAD_FILLMODE -1         /* invalid fill mode */
#define BAD_NAME "a/b"		/* invalid name */
#define BAD_DEFAULT_FORMAT 12	/* invalid default format */

#define LEN_OF(array) ((sizeof array) / (sizeof array[0]))

#ifdef __cplusplus
extern "C" {
#endif

    /* Non-standard internal types */

typedef char text;

    /* Global variables - filenames */

extern char testfile[256];		/* netCDF read-only test data */
extern char scratch[256];		/* netCDF test file for writing */

    /* Global variables - command-line arguments */

extern int read_only;	/* if 1, don't try to change files */
extern int verbose;	/* if 1, print details of tests */
extern int nfails;	/* number of failures in specific test */
extern int use_cdf2;	/* if 1, use CDF-2 format (offset >2GB ) */
extern int extra_flags;	/* if using CDF-2, need extra flags for create*/
extern int max_nmpt;	/* max number of messages per test */


    /* Global variables - test data */

extern char       dim_name[NDIMS][3];
extern IntType    dim_len[NDIMS];
extern char       var_name[NVARS][2+MAX_RANK];
extern nc_type    var_type[NVARS];
extern int        var_rank[NVARS];
extern int        var_dimid[NVARS][MAX_RANK];
extern IntType    var_shape[NVARS][MAX_RANK];
extern IntType    var_nels[NVARS];
extern int        var_natts[NVARS];
extern char       att_name[NVARS][MAX_NATTS][2];
extern char       gatt_name[NGATTS][3];
extern nc_type    att_type[NVARS][NGATTS];
extern nc_type    gatt_type[NGATTS];
extern IntType    att_len[NVARS][MAX_NATTS];
extern IntType    gatt_len[NGATTS];

/* Global variables: MPI data */
extern MPI_Comm comm;
extern MPI_Info info;

/* Macros for accessing attribute test data */
/* varid is -1 for NC_GLOBAL so can do global atts in same loop */

#define VARID(varid)      (varid < 0 ? NC_GLOBAL : varid)
#define NATTS(varid)      (varid < 0 ? numGatts : var_natts[varid])
#define ATT_NAME(varid,j) (varid < 0 ? gatt_name[j] : att_name[varid][j])
#define ATT_TYPE(varid,j) (varid < 0 ? gatt_type[j] : att_type[varid][j])
#define ATT_LEN(varid,j)  (varid < 0 ? gatt_len[j] : att_len[varid][j])

extern const char *s_nc_type(nc_type);

extern int test_ncmpi_strerror(void);
extern int test_ncmpi_open(void);
extern int test_ncmpi_close(void);
extern int test_ncmpi_delete(void);

extern int test_ncmpi_inq(int numGatts, int numVars);
extern int test_ncmpi_inq_natts(int numGatts);
extern int test_ncmpi_inq_ndims(void);
extern int test_ncmpi_inq_nvars(int numVars);
extern int test_ncmpi_inq_unlimdim(void);

extern int test_ncmpi_inq_dimid(void);
extern int test_ncmpi_inq_dim(void);
extern int test_ncmpi_inq_dimlen(void);
extern int test_ncmpi_inq_dimname(void);

extern int test_ncmpi_inq_varid(int numVars);
extern int test_ncmpi_inq_vardimid(int numVars);
extern int test_ncmpi_inq_varname(int numVars);
extern int test_ncmpi_inq_varnatts(int numGatts, int numVars);
extern int test_ncmpi_inq_varndims(int numVars);
extern int test_ncmpi_inq_vartype(int numVars);
extern int test_ncmpi_inq_var(int numVars);

include(`foreach.m4')dnl
include(`utils.m4')dnl
dnl
define(`GETPUTAPI',`extern int dnl
ifdef(`PNETCDF',
ifelse(`$3',`',`test_ncmpi_$1_var$2',`test_ncmpi_$1_var$2_$3'),
ifelse(`$3',`',`test_nc_$1_var$2',`test_nc_$1_var$2_$3'dnl
))`(int numVars);'')
dnl
foreach(`putget', (put, get, iput, iget),
        `foreach(`kind', (, 1, a, s, m),
        `foreach(`itype', (,ITYPE_LIST),
        `GETPUTAPI(putget,kind,itype)'
)')')
dnl
define(`ATTRAPI',`extern int dnl
ifdef(`PNETCDF',
ifelse(`$2',`',`test_ncmpi_$1_att',`test_ncmpi_$1_att_$2'),
ifelse(`$2',`',`test_nc_$1_att',`test_nc_$1_att_$2'dnl
))`(int numGatts, int numVars);'')
dnl
foreach(`putget', (put, get),
        `foreach(`itype', (,ITYPE_LIST),
        `ATTRAPI(putget,itype)'
)')

extern int test_ncmpi_create(void);
extern int test_ncmpi_redef(int numGatts, int numVars);
extern int test_ncmpi_enddef(int numGatts, int numVars);
extern int test_ncmpi_sync(int numGatts, int numVars);
extern int test_ncmpi_abort(int numGatts, int numVars);
extern int test_ncmpi_def_dim(int numVars);
extern int test_ncmpi_rename_dim(void);
extern int test_ncmpi_def_var(int numVars);
extern int test_ncmpi_rename_var(int numVars);
extern int test_ncmpi_copy_att(int numGatts, int numVars);

extern int test_ncmpi_inq_att(int numGatts, int numVars);
extern int test_ncmpi_inq_attname(int numGatts, int numVars);
extern int test_ncmpi_inq_attid(int numGatts, int numVars);
extern int test_ncmpi_inq_attlen(int numGatts, int numVars);
extern int test_ncmpi_inq_atttype(int numGatts, int numVars);

extern int test_ncmpi_rename_att(int numGatts, int numVars);
extern int test_ncmpi_del_att(int numGatts, int numVars);
extern int test_ncmpi_set_fill(int numVars);
extern int test_ncmpi_set_default_format(void);

extern void print_nok(int nok);

#define PRINT_NOK(nok) if (verbose) print("%4d good comparisons.\n",nok);


/*
 * internal types
 */
typedef enum {
	NCT_UNSPECIFIED = 0,
	NCT_UCHAR =	1,	/* unsigned char */
	NCT_TEXT =	16,	/* char */
#define NCT_CHAR NCT_TEXT
	NCT_SCHAR =	17,	/* signed char */
	NCT_SHORT =	18,	/* short */
	NCT_INT =	20,	/* int */
	NCT_LONG =	22,	/* long */
	NCT_FLOAT =	36,	/* float */
	NCT_DOUBLE =	40,	/* double */
	NCT_USHORT =	41,
	NCT_UINT =	42,
	NCT_INT64 =	43,
#define NCT_LONGLONG NCT_INT64
	NCT_UINT64 =	44
#define NCT_ULONGLONG NCT_UINT64
} nct_itype;

extern int
inRange(const double value, const nc_type datatype);

extern int
inRange3(const int cdf_format, const double value, const nc_type datatype, const nct_itype itype);

extern int
equal(const double x, const double y, nc_type extType, nct_itype itype);

extern int
equal2(const double x, const double y, nc_type extType);

extern int
int_vec_eq(const int *v1, const int *v2, const int n);

extern IntType
roll(IntType n);

extern int
toMixedBase(IntType number, int length, const IntType *base, IntType *result);

extern IntType
fromMixedBase(int length, IntType *number, IntType *base);

extern int
nc2dbl(const nc_type datatype, const void *p, double *result);

extern int
dbl2nc(const double d, const nc_type datatype, void *p);

extern double
hash(const nc_type type, const int rank, const IntType *index);

extern double
hash4(const int cdf_format, const nc_type type, const int rank, const IntType *index, const nct_itype itype);

extern void
init_gvars(int numGatts, int numTypes, int numVars);

extern void
def_dims(int ncid);

extern void
def_vars(int ncid, int numVars);

extern void
put_atts(int ncid, int numGatts, int numVars);

extern void
put_vars(int ncid, int numVars);

extern void
write_file(char *filename, int numGatts, int numVars);

extern void
check_dims(int ncid);

extern int
check_vars(int ncid, int numVars);

extern void
check_atts(int ncid, int numGatts, int numVars);

extern void
check_file(char *filename, int numGatts, int numVars);

extern int
nctypelen(nc_type type);

extern MPI_Datatype
nc_mpi_type(nc_type type);

extern char*
ncmpii_err_code_name(int err);

extern int
default_fill_value(int xtype, double *fillp);

dnl
define(`HASH',`extern $1 hash_$1(const int cdf_format, const nc_type type,
       const int rank, const IntType *index, const nct_itype `itype');')dnl
dnl
foreach(`itype',(ITYPE_LIST),`HASH(itype)
')dnl

define(`CHECK_VARS',`extern int check_vars_$1(const char *filename, int numVars);')dnl
dnl
foreach(`itype',(ITYPE_LIST),`CHECK_VARS(itype)
')dnl

define(`CHECK_ATTS',`extern int check_atts_$1(int ncid, int numGatts, int numVars);')dnl
dnl
foreach(`itype',(ITYPE_LIST),`CHECK_ATTS(itype)
')dnl

#ifdef __cplusplus
}
#endif
#
#endif
