/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeEvaluator;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.BestFirst;
import weka.attributeSelection.CfsSubsetEval;
import weka.attributeSelection.Ranker;
import weka.attributeSelection.UnsupervisedAttributeEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class AttributeSelection
extends Filter
implements SupervisedFilter,
OptionHandler {
    static final long serialVersionUID = -296211247688169716L;
    private weka.attributeSelection.AttributeSelection m_trainSelector;
    private ASEvaluation m_ASEvaluator;
    private ASSearch m_ASSearch;
    private String[] m_FilterOptions;
    private int[] m_SelectedAttributes;

    public String globalInfo() {
        return "A supervised attribute filter that can be used to select attributes. It is very flexible and allows various search and evaluation methods to be combined.";
    }

    public AttributeSelection() {
        this.resetOptions();
    }

    public Enumeration listOptions() {
        Enumeration enu;
        Vector<Option> newVector = new Vector<Option>(6);
        newVector.addElement(new Option("\tSets search method for subset evaluators.\n\teg. -S \"weka.attributeSelection.BestFirst -S 8\"", "S", 1, "-S <\"Name of search class [search options]\">"));
        newVector.addElement(new Option("\tSets attribute/subset evaluator.\n\teg. -E \"weka.attributeSelection.CfsSubsetEval -L\"", "E", 1, "-E <\"Name of attribute/subset evaluation class [evaluator options]\">"));
        if (this.m_ASEvaluator != null && this.m_ASEvaluator instanceof OptionHandler) {
            enu = ((OptionHandler)((Object)this.m_ASEvaluator)).listOptions();
            newVector.addElement(new Option("", "", 0, "\nOptions specific to evaluator " + this.m_ASEvaluator.getClass().getName() + ":"));
            while (enu.hasMoreElements()) {
                newVector.addElement((Option)enu.nextElement());
            }
        }
        if (this.m_ASSearch != null && this.m_ASSearch instanceof OptionHandler) {
            enu = ((OptionHandler)((Object)this.m_ASSearch)).listOptions();
            newVector.addElement(new Option("", "", 0, "\nOptions specific to search " + this.m_ASSearch.getClass().getName() + ":"));
            while (enu.hasMoreElements()) {
                newVector.addElement((Option)enu.nextElement());
            }
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        int breakLoc;
        this.resetOptions();
        if (Utils.getFlag('X', options)) {
            throw new Exception("Cross validation is not a valid option when using attribute selection as a Filter.");
        }
        String optionString = Utils.getOption('E', options);
        if (optionString.length() != 0) {
            optionString = optionString.trim();
            breakLoc = optionString.indexOf(32);
            String evalClassName = optionString;
            String evalOptionsString = "";
            String[] evalOptions = null;
            if (breakLoc != -1) {
                evalClassName = optionString.substring(0, breakLoc);
                evalOptionsString = optionString.substring(breakLoc).trim();
                evalOptions = Utils.splitOptions(evalOptionsString);
            }
            this.setEvaluator(ASEvaluation.forName(evalClassName, evalOptions));
        }
        if (this.m_ASEvaluator instanceof AttributeEvaluator) {
            this.setSearch(new Ranker());
        }
        if ((optionString = Utils.getOption('S', options)).length() != 0) {
            optionString = optionString.trim();
            breakLoc = optionString.indexOf(32);
            String SearchClassName = optionString;
            String SearchOptionsString = "";
            String[] SearchOptions = null;
            if (breakLoc != -1) {
                SearchClassName = optionString.substring(0, breakLoc);
                SearchOptionsString = optionString.substring(breakLoc).trim();
                SearchOptions = Utils.splitOptions(SearchOptionsString);
            }
            this.setSearch(ASSearch.forName(SearchClassName, SearchOptions));
        }
        Utils.checkForRemainingOptions(options);
    }

    public String[] getOptions() {
        String[] EvaluatorOptions = new String[]{};
        String[] SearchOptions = new String[]{};
        int current = 0;
        if (this.m_ASEvaluator instanceof OptionHandler) {
            EvaluatorOptions = ((OptionHandler)((Object)this.m_ASEvaluator)).getOptions();
        }
        if (this.m_ASSearch instanceof OptionHandler) {
            SearchOptions = ((OptionHandler)((Object)this.m_ASSearch)).getOptions();
        }
        String[] setOptions = new String[10];
        setOptions[current++] = "-E";
        setOptions[current++] = this.getEvaluator().getClass().getName() + " " + Utils.joinOptions(EvaluatorOptions);
        setOptions[current++] = "-S";
        setOptions[current++] = this.getSearch().getClass().getName() + " " + Utils.joinOptions(SearchOptions);
        while (current < setOptions.length) {
            setOptions[current++] = "";
        }
        return setOptions;
    }

    public String evaluatorTipText() {
        return "Determines how attributes/attribute subsets are evaluated.";
    }

    public void setEvaluator(ASEvaluation evaluator) {
        this.m_ASEvaluator = evaluator;
    }

    public String searchTipText() {
        return "Determines the search method.";
    }

    public void setSearch(ASSearch search) {
        this.m_ASSearch = search;
    }

    public ASEvaluation getEvaluator() {
        return this.m_ASEvaluator;
    }

    public ASSearch getSearch() {
        return this.m_ASSearch;
    }

    public Capabilities getCapabilities() {
        Capabilities result;
        if (this.m_ASEvaluator == null) {
            result = super.getCapabilities();
            result.disableAll();
        } else {
            result = this.m_ASEvaluator.getCapabilities();
            result.enable(Capabilities.Capability.NO_CLASS);
        }
        result.setMinimumNumberInstances(0);
        return result;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isOutputFormatDefined()) {
            this.convertInstance(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isOutputFormatDefined()) {
            this.m_trainSelector.setEvaluator(this.m_ASEvaluator);
            this.m_trainSelector.setSearch(this.m_ASSearch);
            this.m_trainSelector.SelectAttributes(this.getInputFormat());
            this.m_SelectedAttributes = this.m_trainSelector.selectedAttributes();
            if (this.m_SelectedAttributes == null) {
                throw new Exception("No selected attributes\n");
            }
            this.setOutputFormat();
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                this.convertInstance(this.getInputFormat().instance(i));
            }
            this.flushInput();
        }
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    protected void setOutputFormat() throws Exception {
        if (this.m_SelectedAttributes == null) {
            this.setOutputFormat(null);
            return;
        }
        FastVector attributes = new FastVector(this.m_SelectedAttributes.length);
        Instances informat = this.m_ASEvaluator instanceof AttributeTransformer ? ((AttributeTransformer)((Object)this.m_ASEvaluator)).transformedHeader() : this.getInputFormat();
        for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
            attributes.addElement(informat.attribute(this.m_SelectedAttributes[i]).copy());
        }
        Instances outputFormat = new Instances(this.getInputFormat().relationName(), attributes, 0);
        if (!(this.m_ASEvaluator instanceof UnsupervisedSubsetEvaluator) && !(this.m_ASEvaluator instanceof UnsupervisedAttributeEvaluator)) {
            outputFormat.setClassIndex(this.m_SelectedAttributes.length - 1);
        }
        this.setOutputFormat(outputFormat);
    }

    protected void convertInstance(Instance instance) throws Exception {
        double[] newVals = new double[this.getOutputFormat().numAttributes()];
        if (this.m_ASEvaluator instanceof AttributeTransformer) {
            Instance tempInstance = ((AttributeTransformer)((Object)this.m_ASEvaluator)).convertInstance(instance);
            for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
                int current = this.m_SelectedAttributes[i];
                newVals[i] = tempInstance.value(current);
            }
        } else {
            for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
                int current = this.m_SelectedAttributes[i];
                newVals[i] = instance.value(current);
            }
        }
        if (instance instanceof SparseInstance) {
            this.push(new SparseInstance(instance.weight(), newVals));
        } else {
            this.push(new Instance(instance.weight(), newVals));
        }
    }

    protected void resetOptions() {
        this.m_trainSelector = new weka.attributeSelection.AttributeSelection();
        this.setEvaluator(new CfsSubsetEval());
        this.setSearch(new BestFirst());
        this.m_SelectedAttributes = null;
        this.m_FilterOptions = null;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5541 $");
    }

    public static void main(String[] argv) {
        AttributeSelection.runFilter(new AttributeSelection(), argv);
    }
}

