# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class AcceptedAudiences(msrest.serialization.Model):
    """Represents an accepted audience trusted by the cluster.

    :param value: GUID or valid URL representing an accepted audience.
    :type value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AcceptedAudiences, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class AttachedDatabaseConfiguration(ProxyResource):
    """Class representing an attached database configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :ivar provisioning_state: The provisioned state of the resource. Possible values include:
     "Running", "Creating", "Deleting", "Succeeded", "Failed", "Moving".
    :vartype provisioning_state: str or ~kusto_management_client.models.ProvisioningState
    :param database_name: The name of the database which you would like to attach, use * if you
     want to follow all current and future databases.
    :type database_name: str
    :param cluster_resource_id: The resource id of the cluster where the databases you would like
     to attach reside.
    :type cluster_resource_id: str
    :ivar attached_database_names: The list of databases from the clusterResourceId which are
     currently attached to the cluster.
    :vartype attached_database_names: list[str]
    :param default_principals_modification_kind: The default principals modification kind. Possible
     values include: "Union", "Replace", "None".
    :type default_principals_modification_kind: str or
     ~kusto_management_client.models.DefaultPrincipalsModificationKind
    :param table_level_sharing_properties: Table level sharing specifications.
    :type table_level_sharing_properties:
     ~kusto_management_client.models.TableLevelSharingProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'attached_database_names': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'cluster_resource_id': {'key': 'properties.clusterResourceId', 'type': 'str'},
        'attached_database_names': {'key': 'properties.attachedDatabaseNames', 'type': '[str]'},
        'default_principals_modification_kind': {'key': 'properties.defaultPrincipalsModificationKind', 'type': 'str'},
        'table_level_sharing_properties': {'key': 'properties.tableLevelSharingProperties', 'type': 'TableLevelSharingProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AttachedDatabaseConfiguration, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.provisioning_state = None
        self.database_name = kwargs.get('database_name', None)
        self.cluster_resource_id = kwargs.get('cluster_resource_id', None)
        self.attached_database_names = None
        self.default_principals_modification_kind = kwargs.get('default_principals_modification_kind', None)
        self.table_level_sharing_properties = kwargs.get('table_level_sharing_properties', None)


class AttachedDatabaseConfigurationListResult(msrest.serialization.Model):
    """The list attached database configurations operation response.

    :param value: The list of attached database configurations.
    :type value: list[~kusto_management_client.models.AttachedDatabaseConfiguration]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AttachedDatabaseConfiguration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AttachedDatabaseConfigurationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class AttachedDatabaseConfigurationsCheckNameRequest(msrest.serialization.Model):
    """The result returned from a AttachedDatabaseConfigurations check name availability request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Attached database resource name.
    :type name: str
    :ivar type: The type of resource, for instance
     Microsoft.Kusto/clusters/attachedDatabaseConfigurations. Has constant value:
     "Microsoft.Kusto/clusters/attachedDatabaseConfigurations".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Kusto/clusters/attachedDatabaseConfigurations"

    def __init__(
        self,
        **kwargs
    ):
        super(AttachedDatabaseConfigurationsCheckNameRequest, self).__init__(**kwargs)
        self.name = kwargs['name']


class AzureCapacity(msrest.serialization.Model):
    """Azure capacity definition.

    All required parameters must be populated in order to send to Azure.

    :param scale_type: Required. Scale type. Possible values include: "automatic", "manual",
     "none".
    :type scale_type: str or ~kusto_management_client.models.AzureScaleType
    :param minimum: Required. Minimum allowed capacity.
    :type minimum: int
    :param maximum: Required. Maximum allowed capacity.
    :type maximum: int
    :param default: Required. The default capacity that would be used.
    :type default: int
    """

    _validation = {
        'scale_type': {'required': True},
        'minimum': {'required': True},
        'maximum': {'required': True},
        'default': {'required': True},
    }

    _attribute_map = {
        'scale_type': {'key': 'scaleType', 'type': 'str'},
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureCapacity, self).__init__(**kwargs)
        self.scale_type = kwargs['scale_type']
        self.minimum = kwargs['minimum']
        self.maximum = kwargs['maximum']
        self.default = kwargs['default']


class AzureResourceSku(msrest.serialization.Model):
    """Azure resource SKU definition.

    :param resource_type: Resource Namespace and Type.
    :type resource_type: str
    :param sku: The SKU details.
    :type sku: ~kusto_management_client.models.AzureSku
    :param capacity: The number of instances of the cluster.
    :type capacity: ~kusto_management_client.models.AzureCapacity
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'AzureSku'},
        'capacity': {'key': 'capacity', 'type': 'AzureCapacity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureResourceSku, self).__init__(**kwargs)
        self.resource_type = kwargs.get('resource_type', None)
        self.sku = kwargs.get('sku', None)
        self.capacity = kwargs.get('capacity', None)


class AzureSku(msrest.serialization.Model):
    """Azure SKU definition.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. SKU name. Possible values include: "Standard_DS13_v2+1TB_PS",
     "Standard_DS13_v2+2TB_PS", "Standard_DS14_v2+3TB_PS", "Standard_DS14_v2+4TB_PS",
     "Standard_D13_v2", "Standard_D14_v2", "Standard_L8s", "Standard_L16s", "Standard_L8s_v2",
     "Standard_L16s_v2", "Standard_D11_v2", "Standard_D12_v2", "Standard_L4s", "Dev(No
     SLA)_Standard_D11_v2", "Standard_E64i_v3", "Standard_E80ids_v4", "Standard_E2a_v4",
     "Standard_E4a_v4", "Standard_E8a_v4", "Standard_E16a_v4", "Standard_E8as_v4+1TB_PS",
     "Standard_E8as_v4+2TB_PS", "Standard_E16as_v4+3TB_PS", "Standard_E16as_v4+4TB_PS", "Dev(No
     SLA)_Standard_E2a_v4".
    :type name: str or ~kusto_management_client.models.AzureSkuName
    :param capacity: The number of instances of the cluster.
    :type capacity: int
    :param tier: Required. SKU tier. Possible values include: "Basic", "Standard".
    :type tier: str or ~kusto_management_client.models.AzureSkuTier
    """

    _validation = {
        'name': {'required': True},
        'tier': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureSku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.capacity = kwargs.get('capacity', None)
        self.tier = kwargs['tier']


class CheckNameRequest(msrest.serialization.Model):
    """The result returned from a database check name availability request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Resource name.
    :type name: str
    :param type: Required. The type of resource, for instance Microsoft.Kusto/clusters/databases.
     Possible values include: "Microsoft.Kusto/clusters/databases",
     "Microsoft.Kusto/clusters/attachedDatabaseConfigurations".
    :type type: str or ~kusto_management_client.models.Type
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.type = kwargs['type']


class CheckNameResult(msrest.serialization.Model):
    """The result returned from a check name availability request.

    :param name_available: Specifies a Boolean value that indicates if the name is available.
    :type name_available: bool
    :param name: The name that was checked.
    :type name: str
    :param message: Message indicating an unavailable name due to a conflict, or a description of
     the naming rules that are violated.
    :type message: str
    :param reason: Message providing the reason why the given name is invalid. Possible values
     include: "Invalid", "AlreadyExists".
    :type reason: str or ~kusto_management_client.models.Reason
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameResult, self).__init__(**kwargs)
        self.name_available = kwargs.get('name_available', None)
        self.name = kwargs.get('name', None)
        self.message = kwargs.get('message', None)
        self.reason = kwargs.get('reason', None)


class CloudErrorBody(msrest.serialization.Model):
    """An error response from Kusto.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for displaying in a
     user interface.
    :type message: str
    :param target: The target of the particular error. For example, the name of the property in
     error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~kusto_management_client.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']


class Cluster(TrackedResource):
    """Class representing a Kusto cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param sku: Required. The SKU of the cluster.
    :type sku: ~kusto_management_client.models.AzureSku
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~kusto_management_client.models.SystemData
    :param zones: The availability zones of the cluster.
    :type zones: list[str]
    :param identity: The identity of the cluster, if configured.
    :type identity: ~kusto_management_client.models.Identity
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar state: The state of the resource. Possible values include: "Creating", "Unavailable",
     "Running", "Deleting", "Deleted", "Stopping", "Stopped", "Starting", "Updating".
    :vartype state: str or ~kusto_management_client.models.State
    :ivar provisioning_state: The provisioned state of the resource. Possible values include:
     "Running", "Creating", "Deleting", "Succeeded", "Failed", "Moving".
    :vartype provisioning_state: str or ~kusto_management_client.models.ProvisioningState
    :ivar uri: The cluster URI.
    :vartype uri: str
    :ivar data_ingestion_uri: The cluster data ingestion URI.
    :vartype data_ingestion_uri: str
    :ivar state_reason: The reason for the cluster's current state.
    :vartype state_reason: str
    :param trusted_external_tenants: The cluster's external tenants.
    :type trusted_external_tenants: list[~kusto_management_client.models.TrustedExternalTenant]
    :param optimized_autoscale: Optimized auto scale definition.
    :type optimized_autoscale: ~kusto_management_client.models.OptimizedAutoscale
    :param enable_disk_encryption: A boolean value that indicates if the cluster's disks are
     encrypted.
    :type enable_disk_encryption: bool
    :param enable_streaming_ingest: A boolean value that indicates if the streaming ingest is
     enabled.
    :type enable_streaming_ingest: bool
    :param virtual_network_configuration: Virtual network definition.
    :type virtual_network_configuration:
     ~kusto_management_client.models.VirtualNetworkConfiguration
    :param key_vault_properties: KeyVault properties for the cluster encryption.
    :type key_vault_properties: ~kusto_management_client.models.KeyVaultProperties
    :param enable_purge: A boolean value that indicates if the purge operations are enabled.
    :type enable_purge: bool
    :ivar language_extensions: List of the cluster's language extensions.
    :vartype language_extensions: ~kusto_management_client.models.LanguageExtensionsList
    :param enable_double_encryption: A boolean value that indicates if double encryption is
     enabled.
    :type enable_double_encryption: bool
    :param public_network_access: Public network access to the cluster is enabled by default. When
     disabled, only private endpoint connection to the cluster is allowed. Possible values include:
     "Enabled", "Disabled". Default value: "Enabled".
    :type public_network_access: str or ~kusto_management_client.models.PublicNetworkAccess
    :param allowed_ip_range_list: The list of ips in the format of CIDR allowed to connect to the
     cluster.
    :type allowed_ip_range_list: list[str]
    :param engine_type: The engine type. Possible values include: "V2", "V3". Default value: "V3".
    :type engine_type: str or ~kusto_management_client.models.EngineType
    :param accepted_audiences: The cluster's accepted audiences.
    :type accepted_audiences: list[~kusto_management_client.models.AcceptedAudiences]
    :param enable_auto_stop: A boolean value that indicates if the cluster could be automatically
     stopped (due to lack of data or no activity for many days).
    :type enable_auto_stop: bool
    :param restrict_outbound_network_access: Whether or not to restrict outbound network access.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include:
     "Enabled", "Disabled".
    :type restrict_outbound_network_access: str or
     ~kusto_management_client.models.ClusterNetworkAccessFlag
    :param allowed_fqdn_list: List of allowed FQDNs(Fully Qualified Domain Name) for egress from
     Cluster.
    :type allowed_fqdn_list: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'system_data': {'readonly': True},
        'etag': {'readonly': True},
        'state': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'uri': {'readonly': True},
        'data_ingestion_uri': {'readonly': True},
        'state_reason': {'readonly': True},
        'language_extensions': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'AzureSku'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'etag': {'key': 'etag', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'data_ingestion_uri': {'key': 'properties.dataIngestionUri', 'type': 'str'},
        'state_reason': {'key': 'properties.stateReason', 'type': 'str'},
        'trusted_external_tenants': {'key': 'properties.trustedExternalTenants', 'type': '[TrustedExternalTenant]'},
        'optimized_autoscale': {'key': 'properties.optimizedAutoscale', 'type': 'OptimizedAutoscale'},
        'enable_disk_encryption': {'key': 'properties.enableDiskEncryption', 'type': 'bool'},
        'enable_streaming_ingest': {'key': 'properties.enableStreamingIngest', 'type': 'bool'},
        'virtual_network_configuration': {'key': 'properties.virtualNetworkConfiguration', 'type': 'VirtualNetworkConfiguration'},
        'key_vault_properties': {'key': 'properties.keyVaultProperties', 'type': 'KeyVaultProperties'},
        'enable_purge': {'key': 'properties.enablePurge', 'type': 'bool'},
        'language_extensions': {'key': 'properties.languageExtensions', 'type': 'LanguageExtensionsList'},
        'enable_double_encryption': {'key': 'properties.enableDoubleEncryption', 'type': 'bool'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'allowed_ip_range_list': {'key': 'properties.allowedIpRangeList', 'type': '[str]'},
        'engine_type': {'key': 'properties.engineType', 'type': 'str'},
        'accepted_audiences': {'key': 'properties.acceptedAudiences', 'type': '[AcceptedAudiences]'},
        'enable_auto_stop': {'key': 'properties.enableAutoStop', 'type': 'bool'},
        'restrict_outbound_network_access': {'key': 'properties.restrictOutboundNetworkAccess', 'type': 'str'},
        'allowed_fqdn_list': {'key': 'properties.allowedFqdnList', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Cluster, self).__init__(**kwargs)
        self.sku = kwargs['sku']
        self.system_data = None
        self.zones = kwargs.get('zones', None)
        self.identity = kwargs.get('identity', None)
        self.etag = None
        self.state = None
        self.provisioning_state = None
        self.uri = None
        self.data_ingestion_uri = None
        self.state_reason = None
        self.trusted_external_tenants = kwargs.get('trusted_external_tenants', None)
        self.optimized_autoscale = kwargs.get('optimized_autoscale', None)
        self.enable_disk_encryption = kwargs.get('enable_disk_encryption', False)
        self.enable_streaming_ingest = kwargs.get('enable_streaming_ingest', False)
        self.virtual_network_configuration = kwargs.get('virtual_network_configuration', None)
        self.key_vault_properties = kwargs.get('key_vault_properties', None)
        self.enable_purge = kwargs.get('enable_purge', False)
        self.language_extensions = None
        self.enable_double_encryption = kwargs.get('enable_double_encryption', False)
        self.public_network_access = kwargs.get('public_network_access', "Enabled")
        self.allowed_ip_range_list = kwargs.get('allowed_ip_range_list', None)
        self.engine_type = kwargs.get('engine_type', "V3")
        self.accepted_audiences = kwargs.get('accepted_audiences', None)
        self.enable_auto_stop = kwargs.get('enable_auto_stop', True)
        self.restrict_outbound_network_access = kwargs.get('restrict_outbound_network_access', None)
        self.allowed_fqdn_list = kwargs.get('allowed_fqdn_list', None)


class ClusterCheckNameRequest(msrest.serialization.Model):
    """The result returned from a cluster check name availability request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Cluster name.
    :type name: str
    :ivar type: The type of resource, Microsoft.Kusto/clusters. Has constant value:
     "Microsoft.Kusto/clusters".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Kusto/clusters"

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterCheckNameRequest, self).__init__(**kwargs)
        self.name = kwargs['name']


class ClusterListResult(msrest.serialization.Model):
    """The list Kusto clusters operation response.

    :param value: The list of Kusto clusters.
    :type value: list[~kusto_management_client.models.Cluster]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Cluster]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ClusterPrincipalAssignment(ProxyResource):
    """Class representing a cluster principal assignment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param principal_id: The principal ID assigned to the cluster principal. It can be a user
     email, application ID, or security group name.
    :type principal_id: str
    :param role: Cluster principal role. Possible values include: "AllDatabasesAdmin",
     "AllDatabasesViewer".
    :type role: str or ~kusto_management_client.models.ClusterPrincipalRole
    :param tenant_id: The tenant id of the principal.
    :type tenant_id: str
    :param principal_type: Principal type. Possible values include: "App", "Group", "User".
    :type principal_type: str or ~kusto_management_client.models.PrincipalType
    :ivar tenant_name: The tenant name of the principal.
    :vartype tenant_name: str
    :ivar principal_name: The principal name.
    :vartype principal_name: str
    :ivar provisioning_state: The provisioned state of the resource. Possible values include:
     "Running", "Creating", "Deleting", "Succeeded", "Failed", "Moving".
    :vartype provisioning_state: str or ~kusto_management_client.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tenant_name': {'readonly': True},
        'principal_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'role': {'key': 'properties.role', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'principal_type': {'key': 'properties.principalType', 'type': 'str'},
        'tenant_name': {'key': 'properties.tenantName', 'type': 'str'},
        'principal_name': {'key': 'properties.principalName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterPrincipalAssignment, self).__init__(**kwargs)
        self.principal_id = kwargs.get('principal_id', None)
        self.role = kwargs.get('role', None)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.principal_type = kwargs.get('principal_type', None)
        self.tenant_name = None
        self.principal_name = None
        self.provisioning_state = None


class ClusterPrincipalAssignmentCheckNameRequest(msrest.serialization.Model):
    """A principal assignment check name availability request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Principal Assignment resource name.
    :type name: str
    :ivar type: The type of resource, Microsoft.Kusto/clusters/principalAssignments. Has constant
     value: "Microsoft.Kusto/clusters/principalAssignments".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Kusto/clusters/principalAssignments"

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterPrincipalAssignmentCheckNameRequest, self).__init__(**kwargs)
        self.name = kwargs['name']


class ClusterPrincipalAssignmentListResult(msrest.serialization.Model):
    """The list Kusto cluster principal assignments operation response.

    :param value: The list of Kusto cluster principal assignments.
    :type value: list[~kusto_management_client.models.ClusterPrincipalAssignment]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ClusterPrincipalAssignment]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterPrincipalAssignmentListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ClusterUpdate(Resource):
    """Class representing an update to a Kusto cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Resource location.
    :type location: str
    :param sku: The SKU of the cluster.
    :type sku: ~kusto_management_client.models.AzureSku
    :param identity: The identity of the cluster, if configured.
    :type identity: ~kusto_management_client.models.Identity
    :ivar state: The state of the resource. Possible values include: "Creating", "Unavailable",
     "Running", "Deleting", "Deleted", "Stopping", "Stopped", "Starting", "Updating".
    :vartype state: str or ~kusto_management_client.models.State
    :ivar provisioning_state: The provisioned state of the resource. Possible values include:
     "Running", "Creating", "Deleting", "Succeeded", "Failed", "Moving".
    :vartype provisioning_state: str or ~kusto_management_client.models.ProvisioningState
    :ivar uri: The cluster URI.
    :vartype uri: str
    :ivar data_ingestion_uri: The cluster data ingestion URI.
    :vartype data_ingestion_uri: str
    :ivar state_reason: The reason for the cluster's current state.
    :vartype state_reason: str
    :param trusted_external_tenants: The cluster's external tenants.
    :type trusted_external_tenants: list[~kusto_management_client.models.TrustedExternalTenant]
    :param optimized_autoscale: Optimized auto scale definition.
    :type optimized_autoscale: ~kusto_management_client.models.OptimizedAutoscale
    :param enable_disk_encryption: A boolean value that indicates if the cluster's disks are
     encrypted.
    :type enable_disk_encryption: bool
    :param enable_streaming_ingest: A boolean value that indicates if the streaming ingest is
     enabled.
    :type enable_streaming_ingest: bool
    :param virtual_network_configuration: Virtual network definition.
    :type virtual_network_configuration:
     ~kusto_management_client.models.VirtualNetworkConfiguration
    :param key_vault_properties: KeyVault properties for the cluster encryption.
    :type key_vault_properties: ~kusto_management_client.models.KeyVaultProperties
    :param enable_purge: A boolean value that indicates if the purge operations are enabled.
    :type enable_purge: bool
    :ivar language_extensions: List of the cluster's language extensions.
    :vartype language_extensions: ~kusto_management_client.models.LanguageExtensionsList
    :param enable_double_encryption: A boolean value that indicates if double encryption is
     enabled.
    :type enable_double_encryption: bool
    :param public_network_access: Public network access to the cluster is enabled by default. When
     disabled, only private endpoint connection to the cluster is allowed. Possible values include:
     "Enabled", "Disabled". Default value: "Enabled".
    :type public_network_access: str or ~kusto_management_client.models.PublicNetworkAccess
    :param allowed_ip_range_list: The list of ips in the format of CIDR allowed to connect to the
     cluster.
    :type allowed_ip_range_list: list[str]
    :param engine_type: The engine type. Possible values include: "V2", "V3". Default value: "V3".
    :type engine_type: str or ~kusto_management_client.models.EngineType
    :param accepted_audiences: The cluster's accepted audiences.
    :type accepted_audiences: list[~kusto_management_client.models.AcceptedAudiences]
    :param enable_auto_stop: A boolean value that indicates if the cluster could be automatically
     stopped (due to lack of data or no activity for many days).
    :type enable_auto_stop: bool
    :param restrict_outbound_network_access: Whether or not to restrict outbound network access.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include:
     "Enabled", "Disabled".
    :type restrict_outbound_network_access: str or
     ~kusto_management_client.models.ClusterNetworkAccessFlag
    :param allowed_fqdn_list: List of allowed FQDNs(Fully Qualified Domain Name) for egress from
     Cluster.
    :type allowed_fqdn_list: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'uri': {'readonly': True},
        'data_ingestion_uri': {'readonly': True},
        'state_reason': {'readonly': True},
        'language_extensions': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'AzureSku'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'data_ingestion_uri': {'key': 'properties.dataIngestionUri', 'type': 'str'},
        'state_reason': {'key': 'properties.stateReason', 'type': 'str'},
        'trusted_external_tenants': {'key': 'properties.trustedExternalTenants', 'type': '[TrustedExternalTenant]'},
        'optimized_autoscale': {'key': 'properties.optimizedAutoscale', 'type': 'OptimizedAutoscale'},
        'enable_disk_encryption': {'key': 'properties.enableDiskEncryption', 'type': 'bool'},
        'enable_streaming_ingest': {'key': 'properties.enableStreamingIngest', 'type': 'bool'},
        'virtual_network_configuration': {'key': 'properties.virtualNetworkConfiguration', 'type': 'VirtualNetworkConfiguration'},
        'key_vault_properties': {'key': 'properties.keyVaultProperties', 'type': 'KeyVaultProperties'},
        'enable_purge': {'key': 'properties.enablePurge', 'type': 'bool'},
        'language_extensions': {'key': 'properties.languageExtensions', 'type': 'LanguageExtensionsList'},
        'enable_double_encryption': {'key': 'properties.enableDoubleEncryption', 'type': 'bool'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'allowed_ip_range_list': {'key': 'properties.allowedIpRangeList', 'type': '[str]'},
        'engine_type': {'key': 'properties.engineType', 'type': 'str'},
        'accepted_audiences': {'key': 'properties.acceptedAudiences', 'type': '[AcceptedAudiences]'},
        'enable_auto_stop': {'key': 'properties.enableAutoStop', 'type': 'bool'},
        'restrict_outbound_network_access': {'key': 'properties.restrictOutboundNetworkAccess', 'type': 'str'},
        'allowed_fqdn_list': {'key': 'properties.allowedFqdnList', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterUpdate, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs.get('location', None)
        self.sku = kwargs.get('sku', None)
        self.identity = kwargs.get('identity', None)
        self.state = None
        self.provisioning_state = None
        self.uri = None
        self.data_ingestion_uri = None
        self.state_reason = None
        self.trusted_external_tenants = kwargs.get('trusted_external_tenants', None)
        self.optimized_autoscale = kwargs.get('optimized_autoscale', None)
        self.enable_disk_encryption = kwargs.get('enable_disk_encryption', False)
        self.enable_streaming_ingest = kwargs.get('enable_streaming_ingest', False)
        self.virtual_network_configuration = kwargs.get('virtual_network_configuration', None)
        self.key_vault_properties = kwargs.get('key_vault_properties', None)
        self.enable_purge = kwargs.get('enable_purge', False)
        self.language_extensions = None
        self.enable_double_encryption = kwargs.get('enable_double_encryption', False)
        self.public_network_access = kwargs.get('public_network_access', "Enabled")
        self.allowed_ip_range_list = kwargs.get('allowed_ip_range_list', None)
        self.engine_type = kwargs.get('engine_type', "V3")
        self.accepted_audiences = kwargs.get('accepted_audiences', None)
        self.enable_auto_stop = kwargs.get('enable_auto_stop', True)
        self.restrict_outbound_network_access = kwargs.get('restrict_outbound_network_access', None)
        self.allowed_fqdn_list = kwargs.get('allowed_fqdn_list', None)


class ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties(msrest.serialization.Model):
    """ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class Database(ProxyResource):
    """Class representing a Kusto database.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ReadOnlyFollowingDatabase, ReadWriteDatabase.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param kind: Required. Kind of the database.Constant filled by server.  Possible values
     include: "ReadWrite", "ReadOnlyFollowing".
    :type kind: str or ~kusto_management_client.models.Kind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'ReadOnlyFollowing': 'ReadOnlyFollowingDatabase', 'ReadWrite': 'ReadWriteDatabase'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Database, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.kind = 'Database'  # type: str


class DatabaseListResult(msrest.serialization.Model):
    """The list Kusto databases operation response.

    :param value: The list of Kusto databases.
    :type value: list[~kusto_management_client.models.Database]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Database]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class DatabasePrincipal(msrest.serialization.Model):
    """A class representing database principal entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param role: Required. Database principal role. Possible values include: "Admin", "Ingestor",
     "Monitor", "User", "UnrestrictedViewer", "Viewer".
    :type role: str or ~kusto_management_client.models.DatabasePrincipalRole
    :param name: Required. Database principal name.
    :type name: str
    :param type: Required. Database principal type. Possible values include: "App", "Group",
     "User".
    :type type: str or ~kusto_management_client.models.DatabasePrincipalType
    :param fqn: Database principal fully qualified name.
    :type fqn: str
    :param email: Database principal email if exists.
    :type email: str
    :param app_id: Application id - relevant only for application principal type.
    :type app_id: str
    :ivar tenant_name: The tenant name of the principal.
    :vartype tenant_name: str
    """

    _validation = {
        'role': {'required': True},
        'name': {'required': True},
        'type': {'required': True},
        'tenant_name': {'readonly': True},
    }

    _attribute_map = {
        'role': {'key': 'role', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'fqn': {'key': 'fqn', 'type': 'str'},
        'email': {'key': 'email', 'type': 'str'},
        'app_id': {'key': 'appId', 'type': 'str'},
        'tenant_name': {'key': 'tenantName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabasePrincipal, self).__init__(**kwargs)
        self.role = kwargs['role']
        self.name = kwargs['name']
        self.type = kwargs['type']
        self.fqn = kwargs.get('fqn', None)
        self.email = kwargs.get('email', None)
        self.app_id = kwargs.get('app_id', None)
        self.tenant_name = None


class DatabasePrincipalAssignment(ProxyResource):
    """Class representing a database principal assignment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param principal_id: The principal ID assigned to the database principal. It can be a user
     email, application ID, or security group name.
    :type principal_id: str
    :param role: Database principal role. Possible values include: "Admin", "Ingestor", "Monitor",
     "User", "UnrestrictedViewer", "Viewer".
    :type role: str or ~kusto_management_client.models.DatabasePrincipalRole
    :param tenant_id: The tenant id of the principal.
    :type tenant_id: str
    :param principal_type: Principal type. Possible values include: "App", "Group", "User".
    :type principal_type: str or ~kusto_management_client.models.PrincipalType
    :ivar tenant_name: The tenant name of the principal.
    :vartype tenant_name: str
    :ivar principal_name: The principal name.
    :vartype principal_name: str
    :ivar provisioning_state: The provisioned state of the resource. Possible values include:
     "Running", "Creating", "Deleting", "Succeeded", "Failed", "Moving".
    :vartype provisioning_state: str or ~kusto_management_client.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tenant_name': {'readonly': True},
        'principal_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'role': {'key': 'properties.role', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'principal_type': {'key': 'properties.principalType', 'type': 'str'},
        'tenant_name': {'key': 'properties.tenantName', 'type': 'str'},
        'principal_name': {'key': 'properties.principalName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabasePrincipalAssignment, self).__init__(**kwargs)
        self.principal_id = kwargs.get('principal_id', None)
        self.role = kwargs.get('role', None)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.principal_type = kwargs.get('principal_type', None)
        self.tenant_name = None
        self.principal_name = None
        self.provisioning_state = None


class DatabasePrincipalAssignmentCheckNameRequest(msrest.serialization.Model):
    """A principal assignment check name availability request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Principal Assignment resource name.
    :type name: str
    :ivar type: The type of resource, Microsoft.Kusto/clusters/databases/principalAssignments. Has
     constant value: "Microsoft.Kusto/clusters/databases/principalAssignments".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Kusto/clusters/databases/principalAssignments"

    def __init__(
        self,
        **kwargs
    ):
        super(DatabasePrincipalAssignmentCheckNameRequest, self).__init__(**kwargs)
        self.name = kwargs['name']


class DatabasePrincipalAssignmentListResult(msrest.serialization.Model):
    """The list Kusto database principal assignments operation response.

    :param value: The list of Kusto database principal assignments.
    :type value: list[~kusto_management_client.models.DatabasePrincipalAssignment]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DatabasePrincipalAssignment]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabasePrincipalAssignmentListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class DatabasePrincipalListRequest(msrest.serialization.Model):
    """The list Kusto database principals operation request.

    :param value: The list of Kusto database principals.
    :type value: list[~kusto_management_client.models.DatabasePrincipal]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DatabasePrincipal]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabasePrincipalListRequest, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class DatabasePrincipalListResult(msrest.serialization.Model):
    """The list Kusto database principals operation response.

    :param value: The list of Kusto database principals.
    :type value: list[~kusto_management_client.models.DatabasePrincipal]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DatabasePrincipal]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabasePrincipalListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class DatabaseStatistics(msrest.serialization.Model):
    """A class that contains database statistics information.

    :param size: The database size - the total size of compressed data and index in bytes.
    :type size: float
    """

    _attribute_map = {
        'size': {'key': 'size', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseStatistics, self).__init__(**kwargs)
        self.size = kwargs.get('size', None)


class DataConnection(ProxyResource):
    """Class representing an data connection.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: EventGridDataConnection, EventHubDataConnection, IotHubDataConnection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param kind: Required. Kind of the endpoint for the data connection.Constant filled by server.
     Possible values include: "EventHub", "EventGrid", "IotHub".
    :type kind: str or ~kusto_management_client.models.DataConnectionKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'EventGrid': 'EventGridDataConnection', 'EventHub': 'EventHubDataConnection', 'IotHub': 'IotHubDataConnection'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataConnection, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.kind = 'DataConnection'  # type: str


class DataConnectionCheckNameRequest(msrest.serialization.Model):
    """A data connection check name availability request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Data Connection name.
    :type name: str
    :ivar type: The type of resource, Microsoft.Kusto/clusters/databases/dataConnections. Has
     constant value: "Microsoft.Kusto/clusters/databases/dataConnections".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Kusto/clusters/databases/dataConnections"

    def __init__(
        self,
        **kwargs
    ):
        super(DataConnectionCheckNameRequest, self).__init__(**kwargs)
        self.name = kwargs['name']


class DataConnectionListResult(msrest.serialization.Model):
    """The list Kusto data connections operation response.

    :param value: The list of Kusto data connections.
    :type value: list[~kusto_management_client.models.DataConnection]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataConnection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataConnectionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class DataConnectionValidation(msrest.serialization.Model):
    """Class representing an data connection validation.

    :param data_connection_name: The name of the data connection.
    :type data_connection_name: str
    :param properties: The data connection properties to validate.
    :type properties: ~kusto_management_client.models.DataConnection
    """

    _attribute_map = {
        'data_connection_name': {'key': 'dataConnectionName', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DataConnection'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataConnectionValidation, self).__init__(**kwargs)
        self.data_connection_name = kwargs.get('data_connection_name', None)
        self.properties = kwargs.get('properties', None)


class DataConnectionValidationListResult(msrest.serialization.Model):
    """The list Kusto data connection validation result.

    :param value: The list of Kusto data connection validation errors.
    :type value: list[~kusto_management_client.models.DataConnectionValidationResult]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataConnectionValidationResult]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataConnectionValidationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class DataConnectionValidationResult(msrest.serialization.Model):
    """The result returned from a data connection validation request.

    :param error_message: A message which indicates a problem in data connection validation.
    :type error_message: str
    """

    _attribute_map = {
        'error_message': {'key': 'errorMessage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataConnectionValidationResult, self).__init__(**kwargs)
        self.error_message = kwargs.get('error_message', None)


class DiagnoseVirtualNetworkResult(msrest.serialization.Model):
    """DiagnoseVirtualNetworkResult.

    :param findings: The list of network connectivity diagnostic finding.
    :type findings: list[str]
    """

    _attribute_map = {
        'findings': {'key': 'findings', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiagnoseVirtualNetworkResult, self).__init__(**kwargs)
        self.findings = kwargs.get('findings', None)


class EndpointDependency(msrest.serialization.Model):
    """A domain name that a service is reached at, including details of the current connection status.

    :param domain_name: The domain name of the dependency.
    :type domain_name: str
    :param endpoint_details: The ports used when connecting to DomainName.
    :type endpoint_details: list[~kusto_management_client.models.EndpointDetail]
    """

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'endpoint_details': {'key': 'endpointDetails', 'type': '[EndpointDetail]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EndpointDependency, self).__init__(**kwargs)
        self.domain_name = kwargs.get('domain_name', None)
        self.endpoint_details = kwargs.get('endpoint_details', None)


class EndpointDetail(msrest.serialization.Model):
    """Current TCP connectivity information from the Kusto cluster to a single endpoint.

    :param port: The port an endpoint is connected to.
    :type port: int
    """

    _attribute_map = {
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EndpointDetail, self).__init__(**kwargs)
        self.port = kwargs.get('port', None)


class EventGridDataConnection(DataConnection):
    """Class representing an Event Grid data connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param kind: Required. Kind of the endpoint for the data connection.Constant filled by server.
     Possible values include: "EventHub", "EventGrid", "IotHub".
    :type kind: str or ~kusto_management_client.models.DataConnectionKind
    :param storage_account_resource_id: The resource ID of the storage account where the data
     resides.
    :type storage_account_resource_id: str
    :param event_hub_resource_id: The resource ID where the event grid is configured to send
     events.
    :type event_hub_resource_id: str
    :param consumer_group: The event hub consumer group.
    :type consumer_group: str
    :param table_name: The table where the data should be ingested. Optionally the table
     information can be added to each message.
    :type table_name: str
    :param mapping_rule_name: The mapping rule to be used to ingest the data. Optionally the
     mapping information can be added to each message.
    :type mapping_rule_name: str
    :param data_format: The data format of the message. Optionally the data format can be added to
     each message. Possible values include: "MULTIJSON", "JSON", "CSV", "TSV", "SCSV", "SOHSV",
     "PSV", "TXT", "RAW", "SINGLEJSON", "AVRO", "TSVE", "PARQUET", "ORC", "APACHEAVRO",
     "W3CLOGFILE".
    :type data_format: str or ~kusto_management_client.models.EventGridDataFormat
    :param ignore_first_record: A Boolean value that, if set to true, indicates that ingestion
     should ignore the first record of every file.
    :type ignore_first_record: bool
    :param blob_storage_event_type: The name of blob storage event type to process. Possible values
     include: "Microsoft.Storage.BlobCreated", "Microsoft.Storage.BlobRenamed".
    :type blob_storage_event_type: str or ~kusto_management_client.models.BlobStorageEventType
    :ivar provisioning_state: The provisioned state of the resource. Possible values include:
     "Running", "Creating", "Deleting", "Succeeded", "Failed", "Moving".
    :vartype provisioning_state: str or ~kusto_management_client.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'storage_account_resource_id': {'key': 'properties.storageAccountResourceId', 'type': 'str'},
        'event_hub_resource_id': {'key': 'properties.eventHubResourceId', 'type': 'str'},
        'consumer_group': {'key': 'properties.consumerGroup', 'type': 'str'},
        'table_name': {'key': 'properties.tableName', 'type': 'str'},
        'mapping_rule_name': {'key': 'properties.mappingRuleName', 'type': 'str'},
        'data_format': {'key': 'properties.dataFormat', 'type': 'str'},
        'ignore_first_record': {'key': 'properties.ignoreFirstRecord', 'type': 'bool'},
        'blob_storage_event_type': {'key': 'properties.blobStorageEventType', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventGridDataConnection, self).__init__(**kwargs)
        self.kind = 'EventGrid'  # type: str
        self.storage_account_resource_id = kwargs.get('storage_account_resource_id', None)
        self.event_hub_resource_id = kwargs.get('event_hub_resource_id', None)
        self.consumer_group = kwargs.get('consumer_group', None)
        self.table_name = kwargs.get('table_name', None)
        self.mapping_rule_name = kwargs.get('mapping_rule_name', None)
        self.data_format = kwargs.get('data_format', None)
        self.ignore_first_record = kwargs.get('ignore_first_record', None)
        self.blob_storage_event_type = kwargs.get('blob_storage_event_type', None)
        self.provisioning_state = None


class EventHubDataConnection(DataConnection):
    """Class representing an event hub data connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param kind: Required. Kind of the endpoint for the data connection.Constant filled by server.
     Possible values include: "EventHub", "EventGrid", "IotHub".
    :type kind: str or ~kusto_management_client.models.DataConnectionKind
    :param event_hub_resource_id: The resource ID of the event hub to be used to create a data
     connection.
    :type event_hub_resource_id: str
    :param consumer_group: The event hub consumer group.
    :type consumer_group: str
    :param table_name: The table where the data should be ingested. Optionally the table
     information can be added to each message.
    :type table_name: str
    :param mapping_rule_name: The mapping rule to be used to ingest the data. Optionally the
     mapping information can be added to each message.
    :type mapping_rule_name: str
    :param data_format: The data format of the message. Optionally the data format can be added to
     each message. Possible values include: "MULTIJSON", "JSON", "CSV", "TSV", "SCSV", "SOHSV",
     "PSV", "TXT", "RAW", "SINGLEJSON", "AVRO", "TSVE", "PARQUET", "ORC", "APACHEAVRO",
     "W3CLOGFILE".
    :type data_format: str or ~kusto_management_client.models.EventHubDataFormat
    :param event_system_properties: System properties of the event hub.
    :type event_system_properties: list[str]
    :param compression: The event hub messages compression type. Possible values include: "None",
     "GZip". Default value: "None".
    :type compression: str or ~kusto_management_client.models.Compression
    :ivar provisioning_state: The provisioned state of the resource. Possible values include:
     "Running", "Creating", "Deleting", "Succeeded", "Failed", "Moving".
    :vartype provisioning_state: str or ~kusto_management_client.models.ProvisioningState
    :param managed_identity_resource_id: The resource ID of a managed identity (system or user
     assigned) to be used to authenticate with event hub.
    :type managed_identity_resource_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'event_hub_resource_id': {'key': 'properties.eventHubResourceId', 'type': 'str'},
        'consumer_group': {'key': 'properties.consumerGroup', 'type': 'str'},
        'table_name': {'key': 'properties.tableName', 'type': 'str'},
        'mapping_rule_name': {'key': 'properties.mappingRuleName', 'type': 'str'},
        'data_format': {'key': 'properties.dataFormat', 'type': 'str'},
        'event_system_properties': {'key': 'properties.eventSystemProperties', 'type': '[str]'},
        'compression': {'key': 'properties.compression', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'managed_identity_resource_id': {'key': 'properties.managedIdentityResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventHubDataConnection, self).__init__(**kwargs)
        self.kind = 'EventHub'  # type: str
        self.event_hub_resource_id = kwargs.get('event_hub_resource_id', None)
        self.consumer_group = kwargs.get('consumer_group', None)
        self.table_name = kwargs.get('table_name', None)
        self.mapping_rule_name = kwargs.get('mapping_rule_name', None)
        self.data_format = kwargs.get('data_format', None)
        self.event_system_properties = kwargs.get('event_system_properties', None)
        self.compression = kwargs.get('compression', "None")
        self.provisioning_state = None
        self.managed_identity_resource_id = kwargs.get('managed_identity_resource_id', None)


class FollowerDatabaseDefinition(msrest.serialization.Model):
    """A class representing follower database request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param cluster_resource_id: Required. Resource id of the cluster that follows a database owned
     by this cluster.
    :type cluster_resource_id: str
    :param attached_database_configuration_name: Required. Resource name of the attached database
     configuration in the follower cluster.
    :type attached_database_configuration_name: str
    :ivar database_name: The database name owned by this cluster that was followed. * in case
     following all databases.
    :vartype database_name: str
    """

    _validation = {
        'cluster_resource_id': {'required': True},
        'attached_database_configuration_name': {'required': True},
        'database_name': {'readonly': True},
    }

    _attribute_map = {
        'cluster_resource_id': {'key': 'clusterResourceId', 'type': 'str'},
        'attached_database_configuration_name': {'key': 'attachedDatabaseConfigurationName', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FollowerDatabaseDefinition, self).__init__(**kwargs)
        self.cluster_resource_id = kwargs['cluster_resource_id']
        self.attached_database_configuration_name = kwargs['attached_database_configuration_name']
        self.database_name = None


class FollowerDatabaseListResult(msrest.serialization.Model):
    """The list Kusto database principals operation response.

    :param value: The list of follower database result.
    :type value: list[~kusto_management_client.models.FollowerDatabaseDefinition]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FollowerDatabaseDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FollowerDatabaseListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :param type: Required. The type of managed identity used. The type 'SystemAssigned,
     UserAssigned' includes both an implicitly created identity and a set of user-assigned
     identities. The type 'None' will remove all identities. Possible values include: "None",
     "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned".
    :type type: str or ~kusto_management_client.models.IdentityType
    :param user_assigned_identities: The list of user identities associated with the Kusto cluster.
     The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~kusto_management_client.models.ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs['type']
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class IotHubDataConnection(DataConnection):
    """Class representing an iot hub data connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param kind: Required. Kind of the endpoint for the data connection.Constant filled by server.
     Possible values include: "EventHub", "EventGrid", "IotHub".
    :type kind: str or ~kusto_management_client.models.DataConnectionKind
    :param iot_hub_resource_id: The resource ID of the Iot hub to be used to create a data
     connection.
    :type iot_hub_resource_id: str
    :param consumer_group: The iot hub consumer group.
    :type consumer_group: str
    :param table_name: The table where the data should be ingested. Optionally the table
     information can be added to each message.
    :type table_name: str
    :param mapping_rule_name: The mapping rule to be used to ingest the data. Optionally the
     mapping information can be added to each message.
    :type mapping_rule_name: str
    :param data_format: The data format of the message. Optionally the data format can be added to
     each message. Possible values include: "MULTIJSON", "JSON", "CSV", "TSV", "SCSV", "SOHSV",
     "PSV", "TXT", "RAW", "SINGLEJSON", "AVRO", "TSVE", "PARQUET", "ORC", "APACHEAVRO",
     "W3CLOGFILE".
    :type data_format: str or ~kusto_management_client.models.IotHubDataFormat
    :param event_system_properties: System properties of the iot hub.
    :type event_system_properties: list[str]
    :param shared_access_policy_name: The name of the share access policy.
    :type shared_access_policy_name: str
    :ivar provisioning_state: The provisioned state of the resource. Possible values include:
     "Running", "Creating", "Deleting", "Succeeded", "Failed", "Moving".
    :vartype provisioning_state: str or ~kusto_management_client.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'iot_hub_resource_id': {'key': 'properties.iotHubResourceId', 'type': 'str'},
        'consumer_group': {'key': 'properties.consumerGroup', 'type': 'str'},
        'table_name': {'key': 'properties.tableName', 'type': 'str'},
        'mapping_rule_name': {'key': 'properties.mappingRuleName', 'type': 'str'},
        'data_format': {'key': 'properties.dataFormat', 'type': 'str'},
        'event_system_properties': {'key': 'properties.eventSystemProperties', 'type': '[str]'},
        'shared_access_policy_name': {'key': 'properties.sharedAccessPolicyName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubDataConnection, self).__init__(**kwargs)
        self.kind = 'IotHub'  # type: str
        self.iot_hub_resource_id = kwargs.get('iot_hub_resource_id', None)
        self.consumer_group = kwargs.get('consumer_group', None)
        self.table_name = kwargs.get('table_name', None)
        self.mapping_rule_name = kwargs.get('mapping_rule_name', None)
        self.data_format = kwargs.get('data_format', None)
        self.event_system_properties = kwargs.get('event_system_properties', None)
        self.shared_access_policy_name = kwargs.get('shared_access_policy_name', None)
        self.provisioning_state = None


class KeyVaultProperties(msrest.serialization.Model):
    """Properties of the key vault.

    :param key_name: The name of the key vault key.
    :type key_name: str
    :param key_version: The version of the key vault key.
    :type key_version: str
    :param key_vault_uri: The Uri of the key vault.
    :type key_vault_uri: str
    :param user_identity: The user assigned identity (ARM resource id) that has access to the key.
    :type user_identity: str
    """

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
        'key_version': {'key': 'keyVersion', 'type': 'str'},
        'key_vault_uri': {'key': 'keyVaultUri', 'type': 'str'},
        'user_identity': {'key': 'userIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.key_name = kwargs.get('key_name', None)
        self.key_version = kwargs.get('key_version', None)
        self.key_vault_uri = kwargs.get('key_vault_uri', None)
        self.user_identity = kwargs.get('user_identity', None)


class LanguageExtension(msrest.serialization.Model):
    """The language extension object.

    :param language_extension_name: The language extension name. Possible values include: "PYTHON",
     "R".
    :type language_extension_name: str or ~kusto_management_client.models.LanguageExtensionName
    """

    _attribute_map = {
        'language_extension_name': {'key': 'languageExtensionName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LanguageExtension, self).__init__(**kwargs)
        self.language_extension_name = kwargs.get('language_extension_name', None)


class LanguageExtensionsList(msrest.serialization.Model):
    """The list of language extension objects.

    :param value: The list of language extensions.
    :type value: list[~kusto_management_client.models.LanguageExtension]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LanguageExtension]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LanguageExtensionsList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ListResourceSkusResult(msrest.serialization.Model):
    """List of available SKUs for a Kusto Cluster.

    :param value: The collection of available SKUs for an existing resource.
    :type value: list[~kusto_management_client.models.AzureResourceSku]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AzureResourceSku]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListResourceSkusResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ManagedPrivateEndpoint(ProxyResource):
    """Class representing a managed private endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~kusto_management_client.models.SystemData
    :param private_link_resource_id: The ARM resource ID of the resource for which the managed
     private endpoint is created.
    :type private_link_resource_id: str
    :param private_link_resource_region: The region of the resource to which the managed private
     endpoint is created.
    :type private_link_resource_region: str
    :param group_id: The groupId in which the managed private endpoint is created.
    :type group_id: str
    :param request_message: The user request message.
    :type request_message: str
    :ivar provisioning_state: The provisioned state of the resource. Possible values include:
     "Running", "Creating", "Deleting", "Succeeded", "Failed", "Moving".
    :vartype provisioning_state: str or ~kusto_management_client.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'private_link_resource_id': {'key': 'properties.privateLinkResourceId', 'type': 'str'},
        'private_link_resource_region': {'key': 'properties.privateLinkResourceRegion', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'request_message': {'key': 'properties.requestMessage', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedPrivateEndpoint, self).__init__(**kwargs)
        self.system_data = None
        self.private_link_resource_id = kwargs.get('private_link_resource_id', None)
        self.private_link_resource_region = kwargs.get('private_link_resource_region', None)
        self.group_id = kwargs.get('group_id', None)
        self.request_message = kwargs.get('request_message', None)
        self.provisioning_state = None


class ManagedPrivateEndpointListResult(msrest.serialization.Model):
    """The list managed private endpoints operation response.

    :param value: The list of managed private endpoints.
    :type value: list[~kusto_management_client.models.ManagedPrivateEndpoint]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedPrivateEndpoint]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedPrivateEndpointListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ManagedPrivateEndpointsCheckNameRequest(msrest.serialization.Model):
    """The result returned from a managedPrivateEndpoints check name availability request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Managed private endpoint resource name.
    :type name: str
    :ivar type: The type of resource, for instance
     Microsoft.Kusto/clusters/managedPrivateEndpoints. Has constant value:
     "Microsoft.Kusto/clusters/managedPrivateEndpoints".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Kusto/clusters/managedPrivateEndpoints"

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedPrivateEndpointsCheckNameRequest, self).__init__(**kwargs)
        self.name = kwargs['name']


class Operation(msrest.serialization.Model):
    """A REST API operation.

    :param name: This is of the format {provider}/{resource}/{operation}.
    :type name: str
    :param display: The object that describes the operation.
    :type display: ~kusto_management_client.models.OperationDisplay
    :param origin: The intended executor of the operation.
    :type origin: str
    :param properties: Any object.
    :type properties: any
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)
        self.properties = kwargs.get('properties', None)


class OperationDisplay(msrest.serialization.Model):
    """The object that describes the operation.

    :param provider: Friendly name of the resource provider.
    :type provider: str
    :param operation: For example: read, write, delete.
    :type operation: str
    :param resource: The resource type on which the operation is performed.
    :type resource: str
    :param description: The friendly name of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.operation = kwargs.get('operation', None)
        self.resource = kwargs.get('resource', None)
        self.description = kwargs.get('description', None)


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list REST API operations. It contains a list of operations and a URL nextLink to get the next set of results.

    :param value: The list of operations supported by the resource provider.
    :type value: list[~kusto_management_client.models.Operation]
    :param next_link: The URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class OperationResult(msrest.serialization.Model):
    """Operation Result Entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: ID of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar status: status of the Operation result. Possible values include: "Succeeded", "Canceled",
     "Failed", "Running".
    :vartype status: str or ~kusto_management_client.models.Status
    :param start_time: The operation start time.
    :type start_time: ~datetime.datetime
    :param end_time: The operation end time.
    :type end_time: ~datetime.datetime
    :param percent_complete: Percentage completed.
    :type percent_complete: float
    :param code: The code of the error.
    :type code: str
    :param message: The error message.
    :type message: str
    :param operation_kind: The kind of the operation.
    :type operation_kind: str
    :param operation_state: The state of the operation.
    :type operation_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'status': {'readonly': True},
        'percent_complete': {'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'percent_complete': {'key': 'percentComplete', 'type': 'float'},
        'code': {'key': 'error.code', 'type': 'str'},
        'message': {'key': 'error.message', 'type': 'str'},
        'operation_kind': {'key': 'properties.operationKind', 'type': 'str'},
        'operation_state': {'key': 'properties.operationState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationResult, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.status = None
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.percent_complete = kwargs.get('percent_complete', None)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.operation_kind = kwargs.get('operation_kind', None)
        self.operation_state = kwargs.get('operation_state', None)


class OptimizedAutoscale(msrest.serialization.Model):
    """A class that contains the optimized auto scale definition.

    All required parameters must be populated in order to send to Azure.

    :param version: Required. The version of the template defined, for instance 1.
    :type version: int
    :param is_enabled: Required. A boolean value that indicate if the optimized autoscale feature
     is enabled or not.
    :type is_enabled: bool
    :param minimum: Required. Minimum allowed instances count.
    :type minimum: int
    :param maximum: Required. Maximum allowed instances count.
    :type maximum: int
    """

    _validation = {
        'version': {'required': True},
        'is_enabled': {'required': True},
        'minimum': {'required': True},
        'maximum': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'int'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OptimizedAutoscale, self).__init__(**kwargs)
        self.version = kwargs['version']
        self.is_enabled = kwargs['is_enabled']
        self.minimum = kwargs['minimum']
        self.maximum = kwargs['maximum']


class OutboundNetworkDependenciesEndpoint(ProxyResource):
    """Endpoints accessed for a common purpose that the Kusto Service Environment requires outbound network access to.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param category: The type of service accessed by the Kusto Service Environment, e.g., Azure
     Storage, Azure SQL Database, and Azure Active Directory.
    :type category: str
    :param endpoints: The endpoints that the Kusto Service Environment reaches the service at.
    :type endpoints: list[~kusto_management_client.models.EndpointDependency]
    :ivar provisioning_state: The provisioned state of the resource. Possible values include:
     "Running", "Creating", "Deleting", "Succeeded", "Failed", "Moving".
    :vartype provisioning_state: str or ~kusto_management_client.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'endpoints': {'key': 'properties.endpoints', 'type': '[EndpointDependency]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OutboundNetworkDependenciesEndpoint, self).__init__(**kwargs)
        self.etag = None
        self.category = kwargs.get('category', None)
        self.endpoints = kwargs.get('endpoints', None)
        self.provisioning_state = None


class OutboundNetworkDependenciesEndpointListResult(msrest.serialization.Model):
    """Collection of Outbound Environment Endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~kusto_management_client.models.OutboundNetworkDependenciesEndpoint]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OutboundNetworkDependenciesEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OutboundNetworkDependenciesEndpointListResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class PrivateEndpointConnection(ProxyResource):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~kusto_management_client.models.SystemData
    :ivar private_endpoint: Private endpoint which the connection belongs to.
    :vartype private_endpoint: ~kusto_management_client.models.PrivateEndpointProperty
    :param private_link_service_connection_state: Connection State of the Private Endpoint
     Connection.
    :type private_link_service_connection_state:
     ~kusto_management_client.models.PrivateLinkServiceConnectionStateProperty
    :ivar group_id: Group id of the private endpoint.
    :vartype group_id: str
    :ivar provisioning_state: Provisioning state of the private endpoint.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'private_endpoint': {'readonly': True},
        'group_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpointProperty'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionStateProperty'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.system_data = None
        self.private_endpoint = None
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.group_id = None
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """A list of private endpoint connections.

    :param value: Array of private endpoint connections.
    :type value: list[~kusto_management_client.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrivateEndpointProperty(msrest.serialization.Model):
    """Private endpoint which the connection belongs to.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource id of the private endpoint.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointProperty, self).__init__(**kwargs)
        self.id = None


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~kusto_management_client.models.SystemData
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource required zone names.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
        'required_zone_names': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.system_data = None
        self.group_id = None
        self.required_members = None
        self.required_zone_names = None


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    :param value: Array of private link resources.
    :type value: list[~kusto_management_client.models.PrivateLinkResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrivateLinkServiceConnectionStateProperty(msrest.serialization.Model):
    """Connection State of the Private Endpoint Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param status: The private link service connection status.
    :type status: str
    :param description: The private link service connection description.
    :type description: str
    :ivar actions_required: Any action that is required beyond basic workflow (approve/ reject/
     disconnect).
    :vartype actions_required: str
    """

    _validation = {
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionStateProperty, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.description = kwargs.get('description', None)
        self.actions_required = None


class ReadOnlyFollowingDatabase(Database):
    """Class representing a read only following database.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param kind: Required. Kind of the database.Constant filled by server.  Possible values
     include: "ReadWrite", "ReadOnlyFollowing".
    :type kind: str or ~kusto_management_client.models.Kind
    :ivar provisioning_state: The provisioned state of the resource. Possible values include:
     "Running", "Creating", "Deleting", "Succeeded", "Failed", "Moving".
    :vartype provisioning_state: str or ~kusto_management_client.models.ProvisioningState
    :ivar soft_delete_period: The time the data should be kept before it stops being accessible to
     queries in TimeSpan.
    :vartype soft_delete_period: ~datetime.timedelta
    :param hot_cache_period: The time the data should be kept in cache for fast queries in
     TimeSpan.
    :type hot_cache_period: ~datetime.timedelta
    :ivar statistics: The statistics of the database.
    :vartype statistics: ~kusto_management_client.models.DatabaseStatistics
    :ivar leader_cluster_resource_id: The name of the leader cluster.
    :vartype leader_cluster_resource_id: str
    :ivar attached_database_configuration_name: The name of the attached database configuration
     cluster.
    :vartype attached_database_configuration_name: str
    :ivar principals_modification_kind: The principals modification kind of the database. Possible
     values include: "Union", "Replace", "None".
    :vartype principals_modification_kind: str or
     ~kusto_management_client.models.PrincipalsModificationKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'provisioning_state': {'readonly': True},
        'soft_delete_period': {'readonly': True},
        'statistics': {'readonly': True},
        'leader_cluster_resource_id': {'readonly': True},
        'attached_database_configuration_name': {'readonly': True},
        'principals_modification_kind': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'soft_delete_period': {'key': 'properties.softDeletePeriod', 'type': 'duration'},
        'hot_cache_period': {'key': 'properties.hotCachePeriod', 'type': 'duration'},
        'statistics': {'key': 'properties.statistics', 'type': 'DatabaseStatistics'},
        'leader_cluster_resource_id': {'key': 'properties.leaderClusterResourceId', 'type': 'str'},
        'attached_database_configuration_name': {'key': 'properties.attachedDatabaseConfigurationName', 'type': 'str'},
        'principals_modification_kind': {'key': 'properties.principalsModificationKind', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReadOnlyFollowingDatabase, self).__init__(**kwargs)
        self.kind = 'ReadOnlyFollowing'  # type: str
        self.provisioning_state = None
        self.soft_delete_period = None
        self.hot_cache_period = kwargs.get('hot_cache_period', None)
        self.statistics = None
        self.leader_cluster_resource_id = None
        self.attached_database_configuration_name = None
        self.principals_modification_kind = None


class ReadWriteDatabase(Database):
    """Class representing a read write database.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param kind: Required. Kind of the database.Constant filled by server.  Possible values
     include: "ReadWrite", "ReadOnlyFollowing".
    :type kind: str or ~kusto_management_client.models.Kind
    :ivar provisioning_state: The provisioned state of the resource. Possible values include:
     "Running", "Creating", "Deleting", "Succeeded", "Failed", "Moving".
    :vartype provisioning_state: str or ~kusto_management_client.models.ProvisioningState
    :param soft_delete_period: The time the data should be kept before it stops being accessible to
     queries in TimeSpan.
    :type soft_delete_period: ~datetime.timedelta
    :param hot_cache_period: The time the data should be kept in cache for fast queries in
     TimeSpan.
    :type hot_cache_period: ~datetime.timedelta
    :ivar statistics: The statistics of the database.
    :vartype statistics: ~kusto_management_client.models.DatabaseStatistics
    :ivar is_followed: Indicates whether the database is followed.
    :vartype is_followed: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'provisioning_state': {'readonly': True},
        'statistics': {'readonly': True},
        'is_followed': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'soft_delete_period': {'key': 'properties.softDeletePeriod', 'type': 'duration'},
        'hot_cache_period': {'key': 'properties.hotCachePeriod', 'type': 'duration'},
        'statistics': {'key': 'properties.statistics', 'type': 'DatabaseStatistics'},
        'is_followed': {'key': 'properties.isFollowed', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReadWriteDatabase, self).__init__(**kwargs)
        self.kind = 'ReadWrite'  # type: str
        self.provisioning_state = None
        self.soft_delete_period = kwargs.get('soft_delete_period', None)
        self.hot_cache_period = kwargs.get('hot_cache_period', None)
        self.statistics = None
        self.is_followed = None


class Script(ProxyResource):
    """Class representing a database script.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~kusto_management_client.models.SystemData
    :param script_url: The url to the KQL script blob file.
    :type script_url: str
    :param script_url_sas_token: The SaS token.
    :type script_url_sas_token: str
    :param force_update_tag: A unique string. If changed the script will be applied again.
    :type force_update_tag: str
    :param continue_on_errors: Flag that indicates whether to continue if one of the command fails.
    :type continue_on_errors: bool
    :ivar provisioning_state: The provisioned state of the resource. Possible values include:
     "Running", "Creating", "Deleting", "Succeeded", "Failed", "Moving".
    :vartype provisioning_state: str or ~kusto_management_client.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'script_url': {'key': 'properties.scriptUrl', 'type': 'str'},
        'script_url_sas_token': {'key': 'properties.scriptUrlSasToken', 'type': 'str'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'continue_on_errors': {'key': 'properties.continueOnErrors', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Script, self).__init__(**kwargs)
        self.system_data = None
        self.script_url = kwargs.get('script_url', None)
        self.script_url_sas_token = kwargs.get('script_url_sas_token', None)
        self.force_update_tag = kwargs.get('force_update_tag', None)
        self.continue_on_errors = kwargs.get('continue_on_errors', False)
        self.provisioning_state = None


class ScriptCheckNameRequest(msrest.serialization.Model):
    """A script name availability request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Script name.
    :type name: str
    :ivar type: The type of resource, Microsoft.Kusto/clusters/databases/scripts. Has constant
     value: "Microsoft.Kusto/clusters/databases/scripts".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Kusto/clusters/databases/scripts"

    def __init__(
        self,
        **kwargs
    ):
        super(ScriptCheckNameRequest, self).__init__(**kwargs)
        self.name = kwargs['name']


class ScriptListResult(msrest.serialization.Model):
    """The list Kusto database script operation response.

    :param value: The list of Kusto scripts.
    :type value: list[~kusto_management_client.models.Script]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Script]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScriptListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class SkuDescription(msrest.serialization.Model):
    """The Kusto SKU description of given resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The resource type.
    :vartype resource_type: str
    :ivar name: The name of the SKU.
    :vartype name: str
    :ivar tier: The tier of the SKU.
    :vartype tier: str
    :ivar locations: The set of locations that the SKU is available.
    :vartype locations: list[str]
    :ivar location_info: Locations and zones.
    :vartype location_info: list[~kusto_management_client.models.SkuLocationInfoItem]
    :ivar restrictions: The restrictions because of which SKU cannot be used.
    :vartype restrictions: list[any]
    """

    _validation = {
        'resource_type': {'readonly': True},
        'name': {'readonly': True},
        'tier': {'readonly': True},
        'locations': {'readonly': True},
        'location_info': {'readonly': True},
        'restrictions': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'location_info': {'key': 'locationInfo', 'type': '[SkuLocationInfoItem]'},
        'restrictions': {'key': 'restrictions', 'type': '[object]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuDescription, self).__init__(**kwargs)
        self.resource_type = None
        self.name = None
        self.tier = None
        self.locations = None
        self.location_info = None
        self.restrictions = None


class SkuDescriptionList(msrest.serialization.Model):
    """The list of the EngagementFabric SKU descriptions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: SKU descriptions.
    :vartype value: list[~kusto_management_client.models.SkuDescription]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SkuDescription]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuDescriptionList, self).__init__(**kwargs)
        self.value = None


class SkuLocationInfoItem(msrest.serialization.Model):
    """The locations and zones info for SKU.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The available location of the SKU.
    :type location: str
    :param zones: The available zone of the SKU.
    :type zones: list[str]
    """

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuLocationInfoItem, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.zones = kwargs.get('zones', None)


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~kusto_management_client.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~kusto_management_client.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class TableLevelSharingProperties(msrest.serialization.Model):
    """Tables that will be included and excluded in the follower database.

    :param tables_to_include: List of tables to include in the follower database.
    :type tables_to_include: list[str]
    :param tables_to_exclude: List of tables to exclude from the follower database.
    :type tables_to_exclude: list[str]
    :param external_tables_to_include: List of external tables to include in the follower database.
    :type external_tables_to_include: list[str]
    :param external_tables_to_exclude: List of external tables exclude from the follower database.
    :type external_tables_to_exclude: list[str]
    :param materialized_views_to_include: List of materialized views to include in the follower
     database.
    :type materialized_views_to_include: list[str]
    :param materialized_views_to_exclude: List of materialized views exclude from the follower
     database.
    :type materialized_views_to_exclude: list[str]
    """

    _attribute_map = {
        'tables_to_include': {'key': 'tablesToInclude', 'type': '[str]'},
        'tables_to_exclude': {'key': 'tablesToExclude', 'type': '[str]'},
        'external_tables_to_include': {'key': 'externalTablesToInclude', 'type': '[str]'},
        'external_tables_to_exclude': {'key': 'externalTablesToExclude', 'type': '[str]'},
        'materialized_views_to_include': {'key': 'materializedViewsToInclude', 'type': '[str]'},
        'materialized_views_to_exclude': {'key': 'materializedViewsToExclude', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TableLevelSharingProperties, self).__init__(**kwargs)
        self.tables_to_include = kwargs.get('tables_to_include', None)
        self.tables_to_exclude = kwargs.get('tables_to_exclude', None)
        self.external_tables_to_include = kwargs.get('external_tables_to_include', None)
        self.external_tables_to_exclude = kwargs.get('external_tables_to_exclude', None)
        self.materialized_views_to_include = kwargs.get('materialized_views_to_include', None)
        self.materialized_views_to_exclude = kwargs.get('materialized_views_to_exclude', None)


class TrustedExternalTenant(msrest.serialization.Model):
    """Represents a tenant ID that is trusted by the cluster.

    :param value: GUID representing an external tenant.
    :type value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrustedExternalTenant, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class VirtualNetworkConfiguration(msrest.serialization.Model):
    """A class that contains virtual network definition.

    All required parameters must be populated in order to send to Azure.

    :param subnet_id: Required. The subnet resource id.
    :type subnet_id: str
    :param engine_public_ip_id: Required. Engine service's public IP address resource id.
    :type engine_public_ip_id: str
    :param data_management_public_ip_id: Required. Data management's service public IP address
     resource id.
    :type data_management_public_ip_id: str
    """

    _validation = {
        'subnet_id': {'required': True},
        'engine_public_ip_id': {'required': True},
        'data_management_public_ip_id': {'required': True},
    }

    _attribute_map = {
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'engine_public_ip_id': {'key': 'enginePublicIpId', 'type': 'str'},
        'data_management_public_ip_id': {'key': 'dataManagementPublicIpId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkConfiguration, self).__init__(**kwargs)
        self.subnet_id = kwargs['subnet_id']
        self.engine_public_ip_id = kwargs['engine_public_ip_id']
        self.data_management_public_ip_id = kwargs['data_management_public_ip_id']
