/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef SINGLEMSGSHISTORYMODEL_H
#define SINGLEMSGSHISTORYMODEL_H

#include "treemodel.h"

class MessageTreeItem;
class SingleMsgsHistory;
class SingleMessage;
/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class SingleMsgsHistoryModel : public TreeModel
{
  Q_OBJECT
  public:
    enum TreeLayout{IpUserDate, Date};
    enum Columns{DateCol = 0, IpCol = 1, NicknameCol = 2, MessageCol = 3};

  private:
    TreeLayout         m_currentLayout;
    SingleMsgsHistory* m_messages;
    MessageTreeItem*   m_incoming;
    MessageTreeItem*   m_outgoing;

    /// \brief children of m_incoming and m_outgoing
    QMap<QString, MessageTreeItem*> m_secondLevelItems;

    int m_sortingOrder;
    int m_sortingColumn;

  public:
    SingleMsgsHistoryModel(QObject *parent = 0);
    ~SingleMsgsHistoryModel();

    void init();

    void rebuildTree(int);
    void addMessage(SingleMessage*);
    void appendIn3lvl(TreeItem*);

    void sort(int column, Qt::SortOrder order = Qt::AscendingOrder);

    void update(){emit layoutChanged();}

  protected:
    TreeItem* createRootItem();
};

#endif
