\name{GSVAdata-package}
\alias{GSVAdata-package}
\alias{GSVAdata}
\docType{data}
\title{
Data employed in the vignette of the GSVA package.
}
\description{
This package contains data employed in the vignette of the GSVA package.
}

\section{Data sets}{
  \itemize{
    \item \code{\link{geneprotExpCostaEtAl2021}} Bulk RNA-seq data by Costa et al. (2021).
    \item \code{\link{leukemia}} Leukemia data by Armstrong et al. (2002) from
          the Broad Institute.
    \item \code{\link{c2BroadSets}} C2 canonical pathways from the MSigDB 3.0
          database of gene sets at the Broad Institute (Subramanian et al. 2005;
          Liberzon et al., 2011).
    \item \code{\link{gbm_VerhaakEtAl}} TCGA Glioblastoma Multiforme microarray
          expression data from Verhaak et al. (2010).
    \item \code{\link{brainTxDbSets}} Gene sets signatures specific to four
          different brain cell types derived from murine models (Cahoy et al., 2008).
    \item \code{\link{commonPickrellHuang}} Matching microarray and RNA-seq data
          from human lymphoblastoid cell lines (Huang et al., 2007; Pickrell et al., 2010).
    \item \code{\link{annotEntrez220212}} Annotation data on gene length and G+C
          content from NCBI at \url{http://www.ncbi.nlm.nih.gov}.
    \item \code{\link{genderGenesEntrez}} Entrez genes with documented sex-specific
          expression (Skaletsky et al., 2003; Carrel and Willard, 2005).
  }
}

\author{
S. Haenzelmann, J. Guinney and R. Castelo
}

\references{
S.A. Armstrong, J.E. Staunton, L.B. Silverman, R. Pieters, M.L. den Boer,
M.D. Minden, S.E. Sallan, E.S. Lander, T.R. Golub and S.J. Korsmeyer.
MLL translocations specify a distinct gene expression profile that distinguishes a unique leukemia. \emph{Nat Genet} 30:41-47, 2002.

J.D. Cahoy, B. Emery, A. Kaushal, L.C. Foo, J.L. Zamanian, et al.
A transcriptome database for astrocytes, neurons, and oligodendrocytes: a
new resource for understanding brain development and function.
\emph{J Neurosci}, 28:264-278, 2008.

L. Carrel and H.F. Willard. X-inactivation profile reveals extensive
variability in X-linked gene expression in females.
\emph{Nature}, 434:400--404, 2005.

D. Costa, N. Bonet, A. Sole, J.M. Gonzalez de Aledo-Castillo, E. Sabido,
F. Casals, C. Rovira, A. Nadal, J.L. Marin, T. Cobo and R. Castelo. Genome-wide
postnatal changes in immunity following fetal inflammatory response.
\emph{FEBS Journal}, 288:2311-2331, 2021. \url{https://doi.org/10.1111/febs.15578}.

R.S. Huang, S. Duan, W.K. Bleibel, E.O. Kistner, W. Zhang, T.A. Clark,
T.X. Chen, A.C. Schweitzer, J.E. Blume, N.J. Cox and M.E. Dolan,
\emph{Proc. Natl. Acad. Sci. USA}, 104(23):9758-9763, 2007.

A. Liberzon, A. Subramanian, R. Pinchback, H. Thorvaldsdottir, P. Tamayo,
J.P. Mesirov. Molecular signatures database (MSigDB) 3.0. \emph{Bioinformatics},
27(12):1739-40, 2011.

J.K. Pickrell, J.C. Marioni, A.A Pai, J.F. Degner, B.E. Engelhardt,
E. Nkadori, J.B Veyrieras, M. Stephens, Y. Gilad, and J.K. Pritchard,
\emph{Nature}, 464:768-772, 2010.

H.S. Skaletsky, T. Kuroda-Kawaguchi, P.J. Minx, H.S. Cordum, L. Hillier,
L.G. Brown, S. Repping, T. Pyntikova, J. Ali, T. Bieri, A. Chinwalla,
A. Delehaunty, K. Delehaunty, H. Du, G. Fewell, L. Fulton, T. Graves,
S.F. Hou, P. Latrielle, S. Leonard, E. Mardis, R. Maupin, J. McPherson,
T. Miner, W. Nash, C. Nguyen, P. Ozersky, K. Pepin, S. Rock, T. Rohlfing,
K. Scott, B. Schultz, C. Strong, A. Tin-Wollam, S.P. Yang, R.H. Waterston,
R.K. Wilson, S. Rozen, and D.C. Page. The male-specific region of the
human Y chromosome is a mosaic of discrete sequence classes.
\emph{Nature}, 423:825--837, 2003.

A. Subramanian, P. Tamayo, V.K. Mootha, S. Mukherjee, B.L. Ebert, M.A. Gillette,
A. Paulovich, S.L. Pomeroy, T.R. Golub, E.S. Lander, J.P. Mesirov. Gene set
enrichment analysis: a knowledge-based approach for interpreting genome-wide
expression profiles. \emph{Proc. Natl. Acad. Sci. USA}, 102(43):15545-50, 2005.

R.G.W. Verhaak, K.A. Hoadley, E. Purdom, V. Wang, Y. Qi, et al.
Integrated genomic analysis identifies clinically relevant subtypes of
glioblastoma characterized by abnormalities in PDGFRA, IDH1, EGFR, and
NF1. \emph{Cancer Cell}, 17:98-110, 2010.
}

\keyword{dataset}
