% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{has.edges}
\alias{has.edges}
\alias{is.isolate}
\alias{has.edges.network}
\title{Determine if specified vertices of a network have any edges (are not
isolates)}
\usage{
has.edges(net, v = seq_len(network.size(net)), ...)

\method{has.edges}{network}(net, v = seq_len(network.size(net)), ...)
}
\arguments{
\item{net}{a \code{\link{network}} object to be queried}

\item{v}{integer vector of vertex ids to check}

\item{...}{additional arguments to methods}
}
\value{
returns a logical vector with the same length as v, with TRUE if the
vertex is involved in any edges, FALSE if it is an isolate.
}
\description{
Returns a logical value for each specified vertex, indicating if it has any
incident (in or out) edges.  Checks all vertices by default
}
\examples{

test<-network.initialize(5)
test[1,2]<-1
has.edges(test)
has.edges(test,v=5)

}
\author{
skyebend
}
