% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_xml.R
\name{update_xml}
\alias{update_xml}
\title{Update documents with XML data}
\usage{
update_xml(conn, files, name, commit = TRUE, optimize = FALSE,
  max_segments = 1, expunge_deletes = FALSE, wait_searcher = TRUE,
  soft_commit = FALSE, prepare_commit = NULL, wt = "json", raw = FALSE,
  ...)
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{files}{Path to a single file to load into Solr}

\item{name}{(character) Name of the core or collection}

\item{commit}{(logical) If \code{TRUE}, documents immediately searchable. 
Deafult: \code{TRUE}}

\item{optimize}{Should index optimization be performed before the method returns. 
Default: \code{FALSE}}

\item{max_segments}{optimizes down to at most this number of segments. Default: 1}

\item{expunge_deletes}{merge segments with deletes away. Default: \code{FALSE}}

\item{wait_searcher}{block until a new searcher is opened and registered as the 
main query searcher, making the changes visible. Default: \code{TRUE}}

\item{soft_commit}{perform a soft commit - this will refresh the 'view' of the 
index in a more performant manner, but without "on-disk" guarantees. 
Default: \code{FALSE}}

\item{prepare_commit}{The prepareCommit command is an expert-level API that 
calls Lucene's IndexWriter.prepareCommit(). Not passed by default}

\item{wt}{(character) One of json (default) or xml. If json, uses 
\code{\link[jsonlite]{fromJSON}} to parse. If xml, uses 
\code{\link[xml2]{read_xml}} to parse}

\item{raw}{(logical) If \code{TRUE}, returns raw data in format specified by 
\code{wt} param}

\item{...}{curl options passed on to \code{\link[crul]{HttpClient}}}
}
\description{
Update documents with XML data
}
\details{
You likely may not be able to run this function against many 
public Solr services, but should work locally.
}
\examples{
\dontrun{
# start Solr: bin/solr start -f -c -p 8983

# connect
(conn <- SolrClient$new())

# create a collection
if (!conn$collection_exists("books")) {
  conn$collection_create(name = "books", numShards = 2)
}

# Add documents
file <- system.file("examples", "books.xml", package = "solrium")
cat(readLines(file), sep = "\\n")
conn$update_xml(file, "books")

# Update commands - can include many varying commands
## Add files
file <- system.file("examples", "books2_delete.xml", package = "solrium")
cat(readLines(file), sep = "\\n")
conn$update_xml(file, "books")

## Delete files
file <- system.file("examples", "updatecommands_delete.xml",
package = "solrium")
cat(readLines(file), sep = "\\n")
conn$update_xml(file, "books")

## Add and delete in the same document
## Add a document first, that we can later delete
ss <- list(list(id = 456, name = "cat"))
conn$add(ss, "books")
## Now add a new document, and delete the one we just made
file <- system.file("examples", "add_delete.xml", package = "solrium")
cat(readLines(file), sep = "\\n")
conn$update_xml(file, "books")
}
}
\seealso{
Other update: \code{\link{update_csv}},
  \code{\link{update_json}}
}
