% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/time_symbols.R
\name{stri_datetime_symbols}
\alias{stri_datetime_symbols}
\title{[DRAFT API] List Localizable Date-Time Formatting Data}
\usage{
stri_datetime_symbols(locale = NULL, context = "standalone",
  width = "wide")
}
\arguments{
\item{locale}{\code{NULL} or \code{""} for default locale,
or a single string with locale identifier}

\item{context}{single string; one of: \code{"format"}, \code{"standalone"}}

\item{width}{single string; one of: \code{"abbreviated"}, \code{"wide"}, \code{"narrow"}}
}
\value{
Returns a list with the following named components:
\enumerate{
\item \code{Month} - month names,
\item \code{Weekday} - weekday names,
\item \code{Quarter} - quarter names,
\item \code{AmPm} - AM/PM names,
\item \code{Era} - era names.
}
}
\description{
Returns a list of all localizable date-time formatting data,
including month and weekday names, localized AM/PM strings, etc.
}
\details{
\code{context} stands for a selector for date formatting context
and \code{width} - for date formatting width.
}
\examples{
stri_datetime_symbols() # uses the Gregorian calendar in most locales
stri_datetime_symbols("@calendar=hebrew")
stri_datetime_symbols("he_IL@calendar=hebrew")
stri_datetime_symbols("@calendar=islamic")
stri_datetime_symbols("@calendar=persian")
stri_datetime_symbols("@calendar=indian")
stri_datetime_symbols("@calendar=coptic")
stri_datetime_symbols("@calendar=japanese")

stri_datetime_symbols("ja_JP_TRADITIONAL") # uses the Japanese calendar by default
stri_datetime_symbols("th_TH_TRADITIONAL") # uses the Buddhist calendar

stri_datetime_symbols("pl_PL", context="format")
stri_datetime_symbols("pl_PL", context="standalone")

stri_datetime_symbols(width="wide")
stri_datetime_symbols(width="abbreviated")
stri_datetime_symbols(width="narrow")
}
\references{
\emph{Calendar} - ICU User Guide,
\url{http://userguide.icu-project.org/datetime/calendar}

\emph{DateFormatSymbols} class -- ICU API Documentation,
\url{http://icu-project.org/apiref/icu4c/classicu_1_1DateFormatSymbols.html}

\emph{Formatting Dates and Times} -- ICU User Guide,
\url{http://userguide.icu-project.org/formatparse/datetime}
}
\seealso{
Other datetime: \code{\link{stri_datetime_add}},
  \code{\link{stri_datetime_add<-}};
  \code{\link{stri_datetime_create}};
  \code{\link{stri_datetime_fields}};
  \code{\link{stri_datetime_format}},
  \code{\link{stri_datetime_format}},
  \code{\link{stri_datetime_parse}};
  \code{\link{stri_datetime_fstr}};
  \code{\link{stri_datetime_now}};
  \code{\link{stri_timezone_get}},
  \code{\link{stri_timezone_set}};
  \code{\link{stri_timezone_info}};
  \code{\link{stri_timezone_list}}
}

