#include "rheolef.h"
using namespace rheolef;
using namespace std;
int main(int argc, char**argv) {
  field uh, ph;
  cin >> catchmark("u")  >> uh
      >> catchmark("p")  >> ph;
  const space& Vh = uh.get_space();
  const space& Qh = ph.get_space();
  form mp (Qh, Qh, "mass");
  form a  (Vh, Vh, "2D_D");
  form b (Vh, Qh, "div"); b = -b;
  ssk<Float> fact_mp = ldlt(mp.uu);
  field m_ru = a*uh + b.trans_mult(ph);
  field m_rp = b*uh;
  m_ru["top"] = m_ru["bottom"] = 0;
  if (Vh.dimension() == 3) {
    m_ru["front"] = m_ru["back"] = 0;
    m_ru[1]["left"] = m_ru[1]["right"] = 0;
  } else {
    m_ru["left"] = m_ru["right"] = 0;
  }
  field rp (Qh);
  rp.u = fact_mp.solve(m_rp.u);
  Float res_u = m_ru.u.max_abs();
  Float res_p = sqrt(mp(rp,rp));
  Float res = max(res_u, res_p);
  cerr << "check: residue(uh) = " << res_u << endl;
  cerr << "check: residue(ph) = " << res_p << endl;
  cerr << "check: residue = " << res << endl;
  check_macro (res < 1e-5, "unexpected residue");
  Float p_constant = mp(ph, field(Qh,1.));
  cerr << "m(p,1) = " << p_constant << endl;
  return 0;
}
