% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.workspace-functions.R
\name{.rk.with.window.hints}
\alias{.rk.with.window.hints}
\alias{rk.with.window.hints}
\title{Control window placement and style}
\usage{
.rk.with.window.hints(expr, placement = "", name = "", style = "")
}
\arguments{
\item{expr}{Expression to evaluate, unsually an expression that is expected to create exactly one
new window.}

\item{placement}{a character string specifying either "attached" or "detached" placement, or
(if left empty) the default placement for the type of window created.}

\item{name}{character string specifing a named position. If a name is given, and this position is
not yet known, the placement hint (see above) will be followed. If later a second window is
created with the same given name, it will replace the first window.}

\item{style}{character string specifing a style hint. Currently, this can either be "preview" or
"" (default), with most types of window not implementing any special behavior for "preview".}
}
\value{
\code{NULL}, invisibly.
}
\description{
\code{.rk.with.window.hints} can be used to make windows appear in a specific
location: attached, detached, or in a named position where a previous window is
found. (The latter used for preview windows, importantly). It can also be used to pass
"style" hints, importantly indicating that the window is a preview window. All specifications
affect newly created windows, only, not existing ones.
}
\details{
NOTE: This function is still somewhat experimental, and it is not guaranteed that
it will remain in place, with compatible parameters.
}
\examples{

## Not run
.rk.with.window.hints ({
   RK ()
   plot (1, 1)
}, "attached")
## End not run

}
\author{
Thomas Friedrichsmeier \email{rkward-devel@kde.org}
}
\keyword{utilities}

