use once_cell::sync::Lazy;

use crate::Color;

#[derive(Debug, Clone)]
pub struct NamedColor {
    pub name: &'static str,
    pub color: Color,
}

fn named_color(name: &'static str, r: u8, g: u8, b: u8) -> NamedColor {
    NamedColor {
        name,
        color: Color::from_rgb(r, g, b),
    }
}

pub static NAMED_COLORS: Lazy<[NamedColor; 148]> = Lazy::new(|| {
    [
        named_color("aliceblue", 240, 248, 255),
        named_color("antiquewhite", 250, 235, 215),
        named_color("aqua", 0, 255, 255),
        named_color("aquamarine", 127, 255, 212),
        named_color("azure", 240, 255, 255),
        named_color("beige", 245, 245, 220),
        named_color("bisque", 255, 228, 196),
        named_color("black", 0, 0, 0),
        named_color("blanchedalmond", 255, 235, 205),
        named_color("blue", 0, 0, 255),
        named_color("blueviolet", 138, 43, 226),
        named_color("brown", 165, 42, 42),
        named_color("burlywood", 222, 184, 135),
        named_color("cadetblue", 95, 158, 160),
        named_color("chartreuse", 127, 255, 0),
        named_color("chocolate", 210, 105, 30),
        named_color("coral", 255, 127, 80),
        named_color("cornflowerblue", 100, 149, 237),
        named_color("cornsilk", 255, 248, 220),
        named_color("crimson", 220, 20, 60),
        named_color("cyan", 0, 255, 255),
        named_color("darkblue", 0, 0, 139),
        named_color("darkcyan", 0, 139, 139),
        named_color("darkgoldenrod", 184, 134, 11),
        named_color("darkgray", 169, 169, 169),
        named_color("darkgreen", 0, 100, 0),
        named_color("darkgrey", 169, 169, 169),
        named_color("darkkhaki", 189, 183, 107),
        named_color("darkmagenta", 139, 0, 139),
        named_color("darkolivegreen", 85, 107, 47),
        named_color("darkorange", 255, 140, 0),
        named_color("darkorchid", 153, 50, 204),
        named_color("darkred", 139, 0, 0),
        named_color("darksalmon", 233, 150, 122),
        named_color("darkseagreen", 143, 188, 143),
        named_color("darkslateblue", 72, 61, 139),
        named_color("darkslategray", 47, 79, 79),
        named_color("darkslategrey", 47, 79, 79),
        named_color("darkturquoise", 0, 206, 209),
        named_color("darkviolet", 148, 0, 211),
        named_color("deeppink", 255, 20, 147),
        named_color("deepskyblue", 0, 191, 255),
        named_color("dimgray", 105, 105, 105),
        named_color("dimgrey", 105, 105, 105),
        named_color("dodgerblue", 30, 144, 255),
        named_color("firebrick", 178, 34, 34),
        named_color("floralwhite", 255, 250, 240),
        named_color("forestgreen", 34, 139, 34),
        named_color("fuchsia", 255, 0, 255),
        named_color("gainsboro", 220, 220, 220),
        named_color("ghostwhite", 248, 248, 255),
        named_color("gold", 255, 215, 0),
        named_color("goldenrod", 218, 165, 32),
        named_color("gray", 128, 128, 128),
        named_color("green", 0, 128, 0),
        named_color("greenyellow", 173, 255, 47),
        named_color("grey", 128, 128, 128),
        named_color("honeydew", 240, 255, 240),
        named_color("hotpink", 255, 105, 180),
        named_color("indianred", 205, 92, 92),
        named_color("indigo", 75, 0, 130),
        named_color("ivory", 255, 255, 240),
        named_color("khaki", 240, 230, 140),
        named_color("lavender", 230, 230, 250),
        named_color("lavenderblush", 255, 240, 245),
        named_color("lawngreen", 124, 252, 0),
        named_color("lemonchiffon", 255, 250, 205),
        named_color("lightblue", 173, 216, 230),
        named_color("lightcoral", 240, 128, 128),
        named_color("lightcyan", 224, 255, 255),
        named_color("lightgoldenrodyellow", 250, 250, 210),
        named_color("lightgray", 211, 211, 211),
        named_color("lightgreen", 144, 238, 144),
        named_color("lightgrey", 211, 211, 211),
        named_color("lightpink", 255, 182, 193),
        named_color("lightsalmon", 255, 160, 122),
        named_color("lightseagreen", 32, 178, 170),
        named_color("lightskyblue", 135, 206, 250),
        named_color("lightslategray", 119, 136, 153),
        named_color("lightslategrey", 119, 136, 153),
        named_color("lightsteelblue", 176, 196, 222),
        named_color("lightyellow", 255, 255, 224),
        named_color("lime", 0, 255, 0),
        named_color("limegreen", 50, 205, 50),
        named_color("linen", 250, 240, 230),
        named_color("magenta", 255, 0, 255),
        named_color("maroon", 128, 0, 0),
        named_color("mediumaquamarine", 102, 205, 170),
        named_color("mediumblue", 0, 0, 205),
        named_color("mediumorchid", 186, 85, 211),
        named_color("mediumpurple", 147, 112, 219),
        named_color("mediumseagreen", 60, 179, 113),
        named_color("mediumslateblue", 123, 104, 238),
        named_color("mediumspringgreen", 0, 250, 154),
        named_color("mediumturquoise", 72, 209, 204),
        named_color("mediumvioletred", 199, 21, 133),
        named_color("midnightblue", 25, 25, 112),
        named_color("mintcream", 245, 255, 250),
        named_color("mistyrose", 255, 228, 225),
        named_color("moccasin", 255, 228, 181),
        named_color("navajowhite", 255, 222, 173),
        named_color("navy", 0, 0, 128),
        named_color("oldlace", 253, 245, 230),
        named_color("olive", 128, 128, 0),
        named_color("olivedrab", 107, 142, 35),
        named_color("orange", 255, 165, 0),
        named_color("orangered", 255, 69, 0),
        named_color("orchid", 218, 112, 214),
        named_color("palegoldenrod", 238, 232, 170),
        named_color("palegreen", 152, 251, 152),
        named_color("paleturquoise", 175, 238, 238),
        named_color("palevioletred", 219, 112, 147),
        named_color("papayawhip", 255, 239, 213),
        named_color("peachpuff", 255, 218, 185),
        named_color("peru", 205, 133, 63),
        named_color("pink", 255, 192, 203),
        named_color("plum", 221, 160, 221),
        named_color("powderblue", 176, 224, 230),
        named_color("purple", 128, 0, 128),
        named_color("rebeccapurple", 102, 51, 153),
        named_color("red", 255, 0, 0),
        named_color("rosybrown", 188, 143, 143),
        named_color("royalblue", 65, 105, 225),
        named_color("saddlebrown", 139, 69, 19),
        named_color("salmon", 250, 128, 114),
        named_color("sandybrown", 244, 164, 96),
        named_color("seagreen", 46, 139, 87),
        named_color("seashell", 255, 245, 238),
        named_color("sienna", 160, 82, 45),
        named_color("silver", 192, 192, 192),
        named_color("skyblue", 135, 206, 235),
        named_color("slateblue", 106, 90, 205),
        named_color("slategray", 112, 128, 144),
        named_color("slategrey", 112, 128, 144),
        named_color("snow", 255, 250, 250),
        named_color("springgreen", 0, 255, 127),
        named_color("steelblue", 70, 130, 180),
        named_color("tan", 210, 180, 140),
        named_color("teal", 0, 128, 128),
        named_color("thistle", 216, 191, 216),
        named_color("tomato", 255, 99, 71),
        named_color("turquoise", 64, 224, 208),
        named_color("violet", 238, 130, 238),
        named_color("wheat", 245, 222, 179),
        named_color("white", 255, 255, 255),
        named_color("whitesmoke", 245, 245, 245),
        named_color("yellow", 255, 255, 0),
        named_color("yellowgreen", 154, 205, 50),
    ]
});
