#!/bin/sh
[ "$1" = "-h" ] && cat <<tac

This example tests the following features of the sanitizer:

  - Defanging scanning of message/partial parts
  - Recursive scanning of message/partial parts

tac


$ANOMY/bin/sanitizer.pl -nofprot $SAN_CONF \
    'header_rev = 0' \
    'feat_testing = 1' \
    'file_list_2_policy = accept' \
    'file_list_2 = (?i)\.(txt|html)$' \
    'feat_no_partial = 1' \
    'feat_log_inline = 1' \
    'feat_log_stderr = 0' <<EOF 2>test.log >test.out
From xxx@example.com  Thu Aug  3 07:32:10 2000
Return-Path: <xxx@example.com>
Received: from example.com (root@example.com [149.144.245.5])
	by example.com (8.9.3/8.9.3) with ESMTP id HAA01305
	for <bre@example.com>; Thu, 3 Aug 2000 07:32:03 GMT
From: xxx@example.com
Date: Thu, 3 Aug 2000 06:39:59 GMT
Message-Id: <200008030639.GAA23780@example.com>
MIME-Version: 1.0
Sender: xxx@example.com
To: fake@example.com
Content-Type: multipart/mixed; boundary="=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV"

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: message/partial; id="test"; number=1; total=2
Content-Transfer-Encoding: 8bit

From xxx@example.com  Thu Aug  3 07:32:10 2000
Return-Path: <xxx@example.com>
Received: from example.com (root@example.com [149.144.245.5])
	by example.com (8.9.3/8.9.3) with ESMTP id HAA01305
	for <bre@example.com>; Thu, 3 Aug 2000 07:32:03 GMT
From: xxx@example.com
Date: Thu, 3 Aug 2000 06:39:59 GMT
Message-Id: <200008030639.GAA23780@example.com>
MIME-Version: 1.0
Sender: xxx@example.com
To: fake@example.com
Content-Type: text/plain;
Content-Disposition: attachment; filename="evil.com"

Evil dot com!

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV--
EOF


$ANOMY/bin/sanitizer.pl $SAN_CONF \
    'header_rev = 0' \
    'feat_testing = 1' \
    'file_list_2_policy = accept' \
    'file_list_2 = (?i)\.(txt|html)$' \
    'feat_no_partial = 1' \
    'feat_log_inline = 1' \
    'feat_log_stderr = 0' <<EOF 2>>test.log >>test.out
From xxx@example.com  Thu Aug  3 07:32:10 2000
Return-Path: <xxx@example.com>
Received: from example.com (root@example.com [149.144.245.5])
	by example.com (8.9.3/8.9.3) with ESMTP id HAA01305
	for <bre@example.com>; Thu, 3 Aug 2000 07:32:03 GMT
From: xxx@example.com
Date: Thu, 3 Aug 2000 06:39:59 GMT
Message-Id: <200008030639.GAA23780@example.com>
MIME-Version: 1.0
Sender: xxx@example.com
To: fake@example.com
Content-Type: message/partial; id="test"; number=2; total=2
Content-Transfer-Encoding: 8bit

More evil!
EOF
