from __future__ import print_function
from _mock import _Mock

release = __import__('IPython.core.release', fromlist=['release'])


default_banner_parts = _Mock()

default_gui_banner_parts = _Mock()

page_guiref = _Mock()

sys = _Mock()

cl_usage = "=========\n IPython\n=========\n\nTools for Interactive Computing in Python\n=========================================\n\n    A Python shell with automatic history (input and output), dynamic object\n    introspection, easier configuration, command completion, access to the\n    system shell and more.  IPython can also be embedded in running programs.\n\n\nUsage\n\n    ipython [subcommand] [options] [-c cmd | -m mod | file] [--] [arg] ...\n\n    If invoked with no options, it executes the file and exits, passing the\n    remaining arguments to the script, just as if you had specified the same\n    command with python. You may need to specify `--` before args to be passed\n    to the script, to prevent IPython from attempting to parse them. If you\n    specify the option `-i` before the filename, it will enter an interactive\n    IPython session after running the script, rather than exiting. Files ending\n    in .py will be treated as normal Python, but files ending in .ipy can\n    contain special IPython syntax (magic commands, shell expansions, etc.).\n\n    Almost all configuration in IPython is available via the command-line. Do\n    `ipython --help-all` to see all available options.  For persistent\n    configuration, look into your `ipython_config.py` configuration file for\n    details.\n\n    This file is typically installed in the `IPYTHONDIR` directory, and there\n    is a separate configuration directory for each profile. The default profile\n    directory will be located in $IPYTHONDIR/profile_default. For Linux users,\n    IPYTHONDIR defaults to `$HOME/.config/ipython`, and for other Unix systems\n    to `$HOME/.ipython`.  For Windows users, $HOME resolves to C:\\Documents\n    and Settings\\YourUserName in most instances.\n\n    To initialize a profile with the default configuration file, do::\n\n      $> ipython profile create\n\n    and start editing `IPYTHONDIR/profile_default/ipython_config.py`\n\n    In IPython's documentation, we will refer to this directory as\n    `IPYTHONDIR`, you can change its default location by creating an\n    environment variable with this name and setting it to the desired path.\n\n    For more information, see the manual available in HTML and PDF in your\n    installation, or online at http://ipython.org/documentation.html.\n"

default_banner = 'Python 2.7.6 (default, Nov 21 2013, 15:55:38) [GCC]\nType "copyright", "credits" or "license" for more information.\n\nIPython 1.0.0 -- An enhanced Interactive Python.\n?         -> Introduction and overview of IPython\'s features.\n%quickref -> Quick reference.\nhelp      -> Python\'s own help system.\nobject?   -> Details about \'object\', use \'object??\' for extra details.\n'

default_gui_banner = 'Python 2.7.6 (default, Nov 21 2013, 15:55:38) [GCC]\nType "copyright", "credits" or "license" for more information.\n\nIPython 1.0.0 -- An enhanced Interactive Python.\n?         -> Introduction and overview of IPython\'s features.\n%quickref -> Quick reference.\nhelp      -> Python\'s own help system.\nobject?   -> Details about \'object\', use \'object??\' for extra details.\n%guiref   -> A brief reference about the graphical user interface.\n'

gui_note = '%guiref   -> A brief reference about the graphical user interface.\n'

gui_reference = '===============================\n The graphical IPython console\n===============================\n\nThis console is designed to emulate the look, feel and workflow of a terminal\nenvironment, while adding a number of enhancements that are simply not possible\nin a real terminal, such as inline syntax highlighting, true multiline editing,\ninline graphics and much more.\n\nThis quick reference document contains the basic information you\'ll need to\nknow to make the most efficient use of it.  For the various command line\noptions available at startup, type ``ipython qtconsole --help`` at the command line.\n\n\nMultiline editing\n=================\n\nThe graphical console is capable of true multiline editing, but it also tries\nto behave intuitively like a terminal when possible.  If you are used to\nIPython\'s old terminal behavior, you should find the transition painless, and\nonce you learn a few basic keybindings it will be a much more efficient\nenvironment.\n\nFor single expressions or indented blocks, the console behaves almost like the\nterminal IPython: single expressions are immediately evaluated, and indented\nblocks are evaluated once a single blank line is entered::\n\n    In [1]: print "Hello IPython!"  # Enter was pressed at the end of the line\n    Hello IPython!\n\n    In [2]: for i in range(10):\n       ...: \tprint i,\n       ...:\n    0 1 2 3 4 5 6 7 8 9\n\nIf you want to enter more than one expression in a single input block\n(something not possible in the terminal), you can use ``Control-Enter`` at the\nend of your first line instead of ``Enter``.  At that point the console goes\ninto \'cell mode\' and even if your inputs are not indented, it will continue\naccepting arbitrarily many lines until either you enter an extra blank line or\nyou hit ``Shift-Enter`` (the key binding that forces execution).  When a\nmultiline cell is entered, IPython analyzes it and executes its code producing\nan ``Out[n]`` prompt only for the last expression in it, while the rest of the\ncell is executed as if it was a script.  An example should clarify this::\n\n    In [3]: x=1  # Hit C-Enter here\n       ...: y=2  # from now on, regular Enter is sufficient\n       ...: z=3\n       ...: x**2  # This does *not* produce an Out[] value\n       ...: x+y+z  # Only the last expression does\n       ...:\n    Out[3]: 6\n\nThe behavior where an extra blank line forces execution is only active if you\nare actually typing at the keyboard each line, and is meant to make it mimic\nthe IPython terminal behavior.  If you paste a long chunk of input (for example\na long script copied form an editor or web browser), it can contain arbitrarily\nmany intermediate blank lines and they won\'t cause any problems.  As always,\nyou can then make it execute by appending a blank line *at the end* or hitting\n``Shift-Enter`` anywhere within the cell.\n\nWith the up arrow key, you can retrieve previous blocks of input that contain\nmultiple lines.  You can move inside of a multiline cell like you would in any\ntext editor.  When you want it executed, the simplest thing to do is to hit the\nforce execution key, ``Shift-Enter`` (though you can also navigate to the end\nand append a blank line by using ``Enter`` twice).\n\nIf you\'ve edited a multiline cell and accidentally navigate out of it with the\nup or down arrow keys, IPython will clear the cell and replace it with the\ncontents of the one above or below that you navigated to.  If this was an\naccident and you want to retrieve the cell you were editing, use the Undo\nkeybinding, ``Control-z``.\n\n\nKey bindings\n============\n\nThe IPython console supports most of the basic Emacs line-oriented keybindings,\nin addition to some of its own.\n\nThe keybinding prefixes mean:\n\n- ``C``: Control\n- ``S``: Shift\n- ``M``: Meta (typically the Alt key)\n\nThe keybindings themselves are:\n\n- ``Enter``: insert new line (may cause execution, see above).\n- ``C-Enter``: *force* new line, *never* causes execution.\n- ``S-Enter``: *force* execution regardless of where cursor is, no newline added.\n- ``Up``: step backwards through the history.\n- ``Down``: step forwards through the history.\n- ``S-Up``: search backwards through the history (like ``C-r`` in bash).\n- ``S-Down``: search forwards through the history.\n- ``C-c``: copy highlighted text to clipboard (prompts are automatically stripped).\n- ``C-S-c``: copy highlighted text to clipboard (prompts are not stripped).\n- ``C-v``: paste text from clipboard.\n- ``C-z``: undo (retrieves lost text if you move out of a cell with the arrows).\n- ``C-S-z``: redo.\n- ``C-o``: move to \'other\' area, between pager and terminal.\n- ``C-l``: clear terminal.\n- ``C-a``: go to beginning of line.\n- ``C-e``: go to end of line.\n- ``C-u``: kill from cursor to the begining of the line.\n- ``C-k``: kill from cursor to the end of the line.\n- ``C-y``: yank (paste)\n- ``C-p``: previous line (like up arrow)\n- ``C-n``: next line (like down arrow)\n- ``C-f``: forward (like right arrow)\n- ``C-b``: back (like left arrow)\n- ``C-d``: delete next character, or exits if input is empty\n- ``M-<``: move to the beginning of the input region.\n- ``M->``: move to the end of the input region.\n- ``M-d``: delete next word.\n- ``M-Backspace``: delete previous word.\n- ``C-.``: force a kernel restart (a confirmation dialog appears).\n- ``C-+``: increase font size.\n- ``C--``: decrease font size.\n- ``C-M-Space``: toggle full screen. (Command-Control-Space on Mac OS X)\n\nThe IPython pager\n=================\n\nIPython will show long blocks of text from many sources using a builtin pager.\nYou can control where this pager appears with the ``--paging`` command-line\nflag:\n\n- ``inside`` [default]: the pager is overlaid on top of the main terminal. You\n  must quit the pager to get back to the terminal (similar to how a pager such\n  as ``less`` or ``more`` works).\n\n- ``vsplit``: the console is made double-tall, and the pager appears on the\n  bottom area when needed.  You can view its contents while using the terminal.\n\n- ``hsplit``: the console is made double-wide, and the pager appears on the\n  right area when needed.  You can view its contents while using the terminal.\n\n- ``none``: the console never pages output.\n\nIf you use the vertical or horizontal paging modes, you can navigate between\nterminal and pager as follows:\n\n- Tab key: goes from pager to terminal (but not the other way around).\n- Control-o: goes from one to another always.\n- Mouse: click on either.\n\nIn all cases, the ``q`` or ``Escape`` keys quit the pager (when used with the\nfocus on the pager area).\n\nRunning subprocesses\n====================\n\nThe graphical IPython console uses the ``pexpect`` module to run subprocesses\nwhen you type ``!command``.  This has a number of advantages (true asynchronous\noutput from subprocesses as well as very robust termination of rogue\nsubprocesses with ``Control-C``), as well as some limitations.  The main\nlimitation is that you can *not* interact back with the subprocess, so anything\nthat invokes a pager or expects you to type input into it will block and hang\n(you can kill it with ``Control-C``).\n\nWe have provided as magics ``%less`` to page files (aliased to ``%more``),\n``%clear`` to clear the terminal, and ``%man`` on Linux/OSX.  These cover the\nmost common commands you\'d want to call in your subshell and that would cause\nproblems if invoked via ``!cmd``, but you need to be aware of this limitation.\n\nDisplay\n=======\n\nThe IPython console can now display objects in a variety of formats, including\nHTML, PNG and SVG. This is accomplished using the display functions in\n``IPython.core.display``::\n\n    In [4]: from IPython.core.display import display, display_html\n\n    In [5]: from IPython.core.display import display_png, display_svg\n\nPython objects can simply be passed to these functions and the appropriate\nrepresentations will be displayed in the console as long as the objects know\nhow to compute those representations. The easiest way of teaching objects how\nto format themselves in various representations is to define special methods\nsuch as: ``_repr_html_``, ``_repr_svg_`` and ``_repr_png_``. IPython\'s display formatters\ncan also be given custom formatter functions for various types::\n\n    In [6]: ip = get_ipython()\n\n    In [7]: html_formatter = ip.display_formatter.formatters[\'text/html\']\n\n    In [8]: html_formatter.for_type(Foo, foo_to_html)\n\nFor further details, see ``IPython.core.formatters``.\n\nInline matplotlib graphics\n==========================\n\nThe IPython console is capable of displaying matplotlib figures inline, in SVG\nor PNG format.  If started with the ``matplotlib=inline``, then all figures are\nrendered inline automatically (PNG by default).  If started with ``--matplotlib``\nor ``matplotlib=<your backend>``, then a GUI backend will be used, but IPython\'s\n``display()`` and ``getfigs()`` functions can be used to view plots inline::\n\n    In [9]: display(*getfigs())    # display all figures inline\n\n    In[10]: display(*getfigs(1,2)) # display figures 1 and 2 inline\n'

interactive_usage = '\nIPython -- An enhanced Interactive Python\n=========================================\n\nIPython offers a combination of convenient shell features, special commands\nand a history mechanism for both input (command history) and output (results\ncaching, similar to Mathematica). It is intended to be a fully compatible\nreplacement for the standard Python interpreter, while offering vastly\nimproved functionality and flexibility.\n\nAt your system command line, type \'ipython -h\' to see the command line\noptions available. This document only describes interactive features.\n\nMAIN FEATURES\n-------------\n\n* Access to the standard Python help. As of Python 2.1, a help system is\n  available with access to object docstrings and the Python manuals. Simply\n  type \'help\' (no quotes) to access it.\n\n* Magic commands: type %magic for information on the magic subsystem.\n\n* System command aliases, via the %alias command or the configuration file(s).\n\n* Dynamic object information:\n\n  Typing ?word or word? prints detailed information about an object.  If\n  certain strings in the object are too long (docstrings, code, etc.) they get\n  snipped in the center for brevity.\n\n  Typing ??word or word?? gives access to the full information without\n  snipping long strings. Long strings are sent to the screen through the less\n  pager if longer than the screen, printed otherwise.\n\n  The ?/?? system gives access to the full source code for any object (if\n  available), shows function prototypes and other useful information.\n\n  If you just want to see an object\'s docstring, type \'%pdoc object\' (without\n  quotes, and without % if you have automagic on).\n\n  Both %pdoc and ?/?? give you access to documentation even on things which are\n  not explicitely defined. Try for example typing {}.get? or after import os,\n  type os.path.abspath??. The magic functions %pdef, %source and %file operate\n  similarly.\n\n* Completion in the local namespace, by typing TAB at the prompt.\n\n  At any time, hitting tab will complete any available python commands or\n  variable names, and show you a list of the possible completions if there\'s\n  no unambiguous one. It will also complete filenames in the current directory.\n\n  This feature requires the readline and rlcomplete modules, so it won\'t work\n  if your Python lacks readline support (such as under Windows).\n\n* Search previous command history in two ways (also requires readline):\n\n  - Start typing, and then use Ctrl-p (previous,up) and Ctrl-n (next,down) to\n    search through only the history items that match what you\'ve typed so\n    far. If you use Ctrl-p/Ctrl-n at a blank prompt, they just behave like\n    normal arrow keys.\n\n  - Hit Ctrl-r: opens a search prompt. Begin typing and the system searches\n    your history for lines that match what you\'ve typed so far, completing as\n    much as it can.\n\n  - %hist: search history by index (this does *not* require readline).\n\n* Persistent command history across sessions.\n\n* Logging of input with the ability to save and restore a working session.\n\n* System escape with !. Typing !ls will run \'ls\' in the current directory.\n\n* The reload command does a \'deep\' reload of a module: changes made to the\n  module since you imported will actually be available without having to exit.\n\n* Verbose and colored exception traceback printouts. See the magic xmode and\n  xcolor functions for details (just type %magic).\n\n* Input caching system:\n\n  IPython offers numbered prompts (In/Out) with input and output caching. All\n  input is saved and can be retrieved as variables (besides the usual arrow\n  key recall).\n\n  The following GLOBAL variables always exist (so don\'t overwrite them!):\n  _i: stores previous input.\n  _ii: next previous.\n  _iii: next-next previous.\n  _ih : a list of all input _ih[n] is the input from line n.\n\n  Additionally, global variables named _i<n> are dynamically created (<n>\n  being the prompt counter), such that _i<n> == _ih[<n>]\n\n  For example, what you typed at prompt 14 is available as _i14 and _ih[14].\n\n  You can create macros which contain multiple input lines from this history,\n  for later re-execution, with the %macro function.\n\n  The history function %hist allows you to see any part of your input history\n  by printing a range of the _i variables. Note that inputs which contain\n  magic functions (%) appear in the history with a prepended comment. This is\n  because they aren\'t really valid Python code, so you can\'t exec them.\n\n* Output caching system:\n\n  For output that is returned from actions, a system similar to the input\n  cache exists but using _ instead of _i. Only actions that produce a result\n  (NOT assignments, for example) are cached. If you are familiar with\n  Mathematica, IPython\'s _ variables behave exactly like Mathematica\'s %\n  variables.\n\n  The following GLOBAL variables always exist (so don\'t overwrite them!):\n  _ (one underscore): previous output.\n  __ (two underscores): next previous.\n  ___ (three underscores): next-next previous.\n\n  Global variables named _<n> are dynamically created (<n> being the prompt\n  counter), such that the result of output <n> is always available as _<n>.\n\n  Finally, a global dictionary named _oh exists with entries for all lines\n  which generated output.\n\n* Directory history:\n\n  Your history of visited directories is kept in the global list _dh, and the\n  magic %cd command can be used to go to any entry in that list.\n\n* Auto-parentheses and auto-quotes (adapted from Nathan Gray\'s LazyPython)\n\n  1. Auto-parentheses\n        \n     Callable objects (i.e. functions, methods, etc) can be invoked like\n     this (notice the commas between the arguments)::\n       \n         In [1]: callable_ob arg1, arg2, arg3\n       \n     and the input will be translated to this::\n       \n         callable_ob(arg1, arg2, arg3)\n       \n     This feature is off by default (in rare cases it can produce\n     undesirable side-effects), but you can activate it at the command-line\n     by starting IPython with `--autocall 1`, set it permanently in your\n     configuration file, or turn on at runtime with `%autocall 1`.\n\n     You can force auto-parentheses by using \'/\' as the first character\n     of a line.  For example::\n       \n          In [1]: /globals             # becomes \'globals()\'\n       \n     Note that the \'/\' MUST be the first character on the line!  This\n     won\'t work::\n       \n          In [2]: print /globals    # syntax error\n\n     In most cases the automatic algorithm should work, so you should\n     rarely need to explicitly invoke /. One notable exception is if you\n     are trying to call a function with a list of tuples as arguments (the\n     parenthesis will confuse IPython)::\n       \n          In [1]: zip (1,2,3),(4,5,6)  # won\'t work\n       \n     but this will work::\n       \n          In [2]: /zip (1,2,3),(4,5,6)\n          ------> zip ((1,2,3),(4,5,6))\n          Out[2]= [(1, 4), (2, 5), (3, 6)]\n\n     IPython tells you that it has altered your command line by\n     displaying the new command line preceded by -->.  e.g.::\n       \n          In [18]: callable list\n          -------> callable (list)\n\n  2. Auto-Quoting\n    \n     You can force auto-quoting of a function\'s arguments by using \',\' as\n     the first character of a line.  For example::\n       \n          In [1]: ,my_function /home/me   # becomes my_function("/home/me")\n\n     If you use \';\' instead, the whole argument is quoted as a single\n     string (while \',\' splits on whitespace)::\n       \n          In [2]: ,my_function a b c   # becomes my_function("a","b","c")\n          In [3]: ;my_function a b c   # becomes my_function("a b c")\n\n     Note that the \',\' MUST be the first character on the line!  This\n     won\'t work::\n       \n          In [4]: x = ,my_function /home/me    # syntax error\n'

interactive_usage_min = 'An enhanced console for Python.\nSome of its features are:\n- Readline support if the readline library is present.\n- Tab completion in the local namespace.\n- Logging of input, see command-line options.\n- System shell escape via ! , eg !ls.\n- Magic commands, starting with a % (like %ls, %pwd, %cd, etc.)\n- Keeps track of locally defined variables via %who, %whos.\n- Show object information with a ? eg ?x or x? (use ?? for more info).\n'

quick_guide = "?         -> Introduction and overview of IPython's features.\n%quickref -> Quick reference.\nhelp      -> Python's own help system.\nobject?   -> Details about 'object', use 'object??' for extra details.\n"

quick_reference = '\nIPython -- An enhanced Interactive Python - Quick Reference Card\n================================================================\n\nobj?, obj??      : Get help, or more help for object (also works as\n                   ?obj, ??obj).\n?foo.*abc*       : List names in \'foo\' containing \'abc\' in them.\n%magic           : Information about IPython\'s \'magic\' % functions.\n\nMagic functions are prefixed by % or %%, and typically take their arguments\nwithout parentheses, quotes or even commas for convenience.  Line magics take a\nsingle % and cell magics are prefixed with two %%.\n\nExample magic function calls:\n\n%alias d ls -F   : \'d\' is now an alias for \'ls -F\'\nalias d ls -F    : Works if \'alias\' not a python name\nalist = %alias   : Get list of aliases to \'alist\'\ncd /usr/share    : Obvious. cd -<tab> to choose from visited dirs.\n%cd??            : See help AND source for magic %cd\n%timeit x=10     : time the \'x=10\' statement with high precision.\n%%timeit x=2**100\nx**100           : time \'x*100\' with a setup of \'x=2**100\'; setup code is not\n                   counted.  This is an example of a cell magic.\n\nSystem commands:\n\n!cp a.txt b/     : System command escape, calls os.system()\ncp a.txt b/      : after %rehashx, most system commands work without !\ncp ${f}.txt $bar : Variable expansion in magics and system commands\nfiles = !ls /usr : Capture sytem command output\nfiles.s, files.l, files.n: "a b c", [\'a\',\'b\',\'c\'], \'a\\nb\\nc\'\n\nHistory:\n\n_i, _ii, _iii    : Previous, next previous, next next previous input\n_i4, _ih[2:5]    : Input history line 4, lines 2-4\nexec _i81        : Execute input history line #81 again\n%rep 81          : Edit input history line #81\n_, __, ___       : previous, next previous, next next previous output\n_dh              : Directory history\n_oh              : Output history\n%hist            : Command history. \'%hist -g foo\' search history for \'foo\'\n\nAutocall:\n\nf 1,2            : f(1,2)  # Off by default, enable with %autocall magic.\n/f 1,2           : f(1,2) (forced autoparen)\n,f 1 2           : f("1","2")\n;f 1 2           : f("1 2")\n\nRemember: TAB completion works in many contexts, not just file names\nor python names.\n\nThe following magic functions are currently available:\n\n'



