/* Public domain. */

#include "uint32.h"
#include "biguint.h"

void bu_div (uint32 const *a, uint32 const *b, uint32 *q, uint32 *r, unsigned int n)
{
  register unsigned int blen = bu_len(b, n) ;
  if (!blen) { q[0] = 1/0 ; return ; }
  else if ((blen == 1) && (b[0] == 1))
  {
    bu_copy(q, a, n) ;
    bu_zero(r, n) ;
  }
  else if (bu_cmp(a, b, n) < 0)
  {
    bu_zero(q, n) ;
    bu_copy(r, a, n) ;
  }
  else bu_div_unsafe(a, b, q, r, n) ;
}
