/* Public domain. */

#include "uint32.h"
#include "bytestr.h"
#include "fmtscan.h"
#include "biguint.h"

unsigned int bu_scan (char const *s, uint32 *x, unsigned int *n)
{
  char fmt[9] = "\0\0\0\0\0\0\0\0" ;
  unsigned int i = 0 ;
  unsigned int len = ucharn_findlen(s) ;
  if (!len) return 0 ;
  if (len > BIGUINT_MAXLIMBS << 3) len = BIGUINT_MAXLIMBS << 3 ;
  *n = len >> 3 ;
  if (len & 7)
  {
    byte_copy(fmt, len & 7, s) ;
    uint32_xscan(fmt, x + *n) ;
  }
  for (; i < *n ; i++)
  {
    byte_copy(fmt, 8, s + len - 8 - (i << 3)) ;
    uint32_xscan(fmt, x + i) ;
  }
  return len ;
}
