9.4 Ticks

# Ticks verwenden

Beim Live-Coding wirst Du in Deinen Loops sehr oft Ringe verwenden. Aus 
einem Ring wirst Du Noten für Melodien, Pausen für Rhythmen, 
Akkordfolgen, Klangvariatonen und ähnliches entnehmen.

## Ticks und Ringe

Das Tick-System ist ein *sehr* praktisches Werkzeug, um in einem
`live_loop` mit Ringen zu hantieren. Du kannst damit einen *Ring
durchticken*. Hier ein Beispiel:

```
live_loop :arp do
  play (scale :e3, :minor_pentatonic).tick, release: 0.1
  sleep 0.125
end
```

In diesem Beispiel tickt der Code einmal jede Note der pentatonischen 
E3-Moll-Tonleiter durch. Dafür fügst Du einfach ein `.tick` hinter der 
Tonleiter-Deklaration an. Dieser Tick gilt nur für diese Live-Loop und 
jede Live-Loop kann seinen eigenen, unabhängigen Tick haben:

```
live_loop :arp do
  play (scale :e3, :minor_pentatonic).tick, release: 0.1
  sleep 0.125
end

live_loop :arp2 do
  use_synth :dsaw
  play (scale :e2, :minor_pentatonic, num_octaves: 3).tick, release: 0.25
  sleep 0.25
end
```

## Tick

Du kannst auch den aktuellen Tick mit der Standard-Funktion `tick`
abfragen und den Wert als Index verwenden:

```
live_loop :arp do
  idx = tick
  play (scale :e3, :minor_pentatonic)[idx], release: 0.1
  sleep 0.125
end
```

Aber eigentlich ist es viel einfacher, wenn Du `.tick` am Ende anfügst. 
Die `tick`-Funktion kannst Du benutzen, wenn Du aufwändigere Dinge machen möchtest; oder wenn du Ticks für andere Dinge verwenden möchtest als Werte aus einem Ring anzusteuern.

## Look

Die Magie des Ticks ist, dass er sich nach jedem Aufruf erhöht, so dass 
Du bei der nächsten Verwendung auch den nächsten Tick bekommst. In den 
Beispielen findest Du einige Sonic-Pi-Codes, die `.tick` verwenden, 
schau sie Dir mal näher an.

Manchmal willst Du aber den aktuellen Tick benutzen, *ohne dass er 
gleich um einen Wert weiter tickt*. Dafür gibt es die `look`-Funktion. 
Du kannst sie wie zuvor mit `look` als Funktion aufrufen oder mit 
`.look` an einen Ring anfügen.

## Namen für Ticks

Gelegentlich wirst Du auch mal mehr als einen Tick pro 
Live-Loop brauchen. Gib den Ticks dafür Namen:

```
live_loop :arp do
  play (scale :e3, :minor_pentatonic).tick(:foo), release: 0.1
  sleep (ring 0.125, 0.25).tick(:bar)
end
```

In diesem Beispiel markiert ein Tick die Position in der Tonleiter, ein 
zweiter Tick wählt die Pausenwerte. Beide Ticks befinden sich im 
gleichen Live-Loop, also geben wir ihnen zur Unterscheidung eindeutige 
Namen. Du kennst das Prinzip schon von den Live-Loops - einfach ein `:` 
gefolgt vom Namen. Im Beispiel heißt der eine Tick `:foo` und der 
andere `:bar`. Willst Du die Tick-Werte mit `look` nur abfragen, musst 
Du ebenso den Namen nennen.

## Mach's nicht zu kompliziert

Mit Ticks kannst Du viele großartige Dinge machen, aber versuche nicht, 
gleich alles in diesem Kapitel zu lernen und anzuwenden. Für den Anfang 
reicht es völlig, wenn Du nur durch einen Ring durchtickst und das 
Prinzip kennenlernst. Damit kannst Du in Deinen `live_loop`s schon eine 
Menge anfangen.

Schau Dir die Dokumentation an, Du wirst dort viele praktische 
Beispiele entdecken. Viel Spaß beim Durchticken!

