2.2 シンセのパラメータ

# シンセのパラメータ：Amp と Pan

Sonic Piはあらゆる音を作りだし、コントロールするためのパラメータの全てを提供します。
どんな音符を演奏するのか、そしてどんなサンプルをトリガー（きっかけ）にするのかはあなた次第です。
このチュートリアルでは、これらの多くをカバーするそれぞれについての詳細なドキュメントが
ヘルプシステムにあります。しかし、これから最も有用なのうちの2つ、*Amplitude(振幅)*と*Pan(パン)*を紹介します。
まずはパラメータを見てみましょう。

## パラメータ

Sonic Piはシンセのためにパラメータ(変数)という概念を備えています。
パラメータは、あなたが耳にするサウンドの特徴をコントロールしたり、
変更するための手段で、演奏に反映されます。シンセはそれぞれ細かく音を
チューニングするためのパラメータを持っています。
Sonic Piには、`amp:`（音量）やエンベロープ・パラメータ(ほかのセクションで紹介します)のような、
多くのサウンドに共通するパラメータを持っています。

パラメータには2つの主要な役割があり、ひとつはその名前(制御の名前)、もうひとつは
数値（あなたが制御したい値）です。例えば、`cheese:`いうパラメータがあったとして、 
`1`の値にセットしたいとします。

パラメータは、play`の後にカンマ`,`を入れて、その後、`amp:`(コロン : を忘れずに)のような
パラメータの名前、スペース、そしてパラメータの値、というように渡していきます。例えば、

```
play 50, cheese: 1
```

(cheese: は無効なパラメータです。例として使っています。)

カンマを使って区切り、複数のパラメータを使用することができます。

```
play 50, cheese: 1, beans: 0.5
```

パラメータの順番は問題ではないので、以下は同じものです。


```
play 50, beans: 0.5, cheese: 1
```

シンセで認識されないパラメータは無視されます(`cheese` (チーズ)と`beans`(豆)などは明らかに馬鹿げた名前でしょう！)

もし偶然同じパラメータを2回、違う値で使った場合は、最後のものが有効になります。
例えば、ここでの`beans:`は、0.5 ではなく 2 の値が採用されます。

```
play 50, beans: 0.5, cheese: 3, eggs: 0.1, beans: 2
```

Sonic Piの中の命令には多くのパラメータが用意されているので、その使い方に
ちょっとだけ時間を使って、習得しましょう！

それでは最初のパラメータ`amp:`で演奏してみましょう。

## アンプ（増幅）

アンプは音の大きさをコンピュータで表したものです。高アンプは大きな音を生成し、
低アンプは静かな音を生み出します。Sonic Piは時間と音符を数字を使って表現するので、
アンプにも数字を使用します。1 の値が通常の音量であるのに対して、0はサイレントです（何もきこえませんよ）。
2、10、100 というふうに、アンプを上げることができます。ただし、全体の音を増幅しすぎると、
大きな音になりすぎないように、Sonic Piはコンプレッサー(圧縮)と呼ばれる
効果を使用して確実な音量に抑えることを覚えておいてください。これは多くの場合、音がこもって
奇妙に聞こえます。ですから、圧縮を防ぐために0から0.5のような値で使用してみてください。


## 音量を上げる

音の大きさを変えるために、 amp: パラメータを使います。
例として、半分の音量で演奏するために、0.5 にしてみます。

```
play 60, amp: 0.5
```

倍の音量で演奏するために、2 にしてみます。

```
play 60, amp: 2
```

 `amp:`パラメータは、関連付けられている`play`への命令だけを変更します。
 ですから、この例では、最初の命令は半分の音量になり、次にはデフォルト（1の値）に戻ります。

```
play 60, amp: 0.5
sleep 0.5
play 65
```

もちろん、それぞれの命令で異なった`amp:`の値を設定して演奏することもできます。
```
play 50, amp: 0.1
sleep 0.25
play 55, amp: 0.2
sleep 0.25
play 57, amp: 0.4
sleep 0.25
play 62, amp: 1
```

## パンニング

もうひとつの面白いパラメータは`pan:`です。ステレオで音の位置を制御します。
左に音をパンすることは左のスピーカーから音が聞こえることを意味し、
右にパンすれば右のスピーカーから聞こえます。値としては、-1 は最も左、
0 は中心、1 は最も右、というようにステレオの領域で表現することができます。
もちろん、音の正確な位置をコントロールするために、-1 から 1 の間のどの値でも使用することができます。

左のスピーカーから音を鳴らしてみましょう。

```
play 60, pan: -1
```

では、右のスピーカーから鳴らします。

```
play 60, pan: 1
```

最後に元の通り、中心から鳴らしてみます（通常の位置です）。

```
play 60, pan: 0
```

では、続けてあなたの音のアンプやパンを変えて楽しんでみましょう！
