/*----------------------------------------------------------------------------
 *
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

#include "eas_sndlib.h"

/*----------------------------------------------------------------------------
 * Articulations
 *----------------------------------------------------------------------------
*/
const S_ARTICULATION testArticulations[] =
{
    { /* articulation 0 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 1 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        100, 0, 19, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 2 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        100, 34, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 3 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        100, 86, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 4 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        100, 172, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 5 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        100, 345, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 6 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        100, 517, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 7 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        100, 689, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 8 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        100, 861, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 9 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        100, 1723, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 10 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        100, 0, 191, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 11 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        100, 0, 382, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 12 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        100, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 13 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        100, 0, 1903, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 14 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        100, 0, 3804, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 15 */
        { 1902, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 16 */
        { 380, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 17 */
        { 190, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 18 */
        { 38, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 19 */
        { 19, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 20 */
        { 10, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 21 */
        { 5, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 22 */
        { 32767, 17213, 0, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 23 */
        { 32767, 28809, 0, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 24 */
        { 32767, 30725, 0, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 25 */
        { 32767, 32349, 0, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 26 */
        { 32767, 32558, 0, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 27 */
        { 32767, 32663, 0, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 28 */
        { 32767, 32715, 0, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 29 */
        { 32767, 30725, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 30 */
        { 32767, 30725, 3566, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 31 */
        { 32767, 30725, 42, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 32 */
        { 32767, 30725, 5, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 33 */
        { 32767, 30725, 2, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 34 */
        { 32767, 0, 32767, 17213 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 35 */
        { 32767, 0, 32767, 28809 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 36 */
        { 32767, 0, 32767, 30725 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 37 */
        { 32767, 0, 32767, 32349 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 38 */
        { 32767, 0, 32767, 32558 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 39 */
        { 32767, 0, 32767, 32663 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 40 */
        { 32767, 0, 32767, 32715 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 41 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 190, 0, 0, 0, 1, 0, 0
    },
    { /* articulation 42 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 189, 0, 0, 0, 3, 0, 0
    },
    { /* articulation 43 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 190, 0, 0, 0, 4, 0, 0
    },
    { /* articulation 44 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 190, 0, 0, 0, 6, 0, 0
    },
    { /* articulation 45 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        -1200, 0, 190, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 46 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        -600, 0, 190, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 47 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        -100, 0, 190, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 48 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        -50, 0, 190, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 49 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        50, 0, 190, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 50 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        100, 0, 190, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 51 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        600, 0, 190, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 52 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        1200, 0, 190, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 53 */
        { 32767, 0, 32767, 0 },
        { 190, 190, 0, 0 },
        0, 0, 951, -1200, 0, 0, 0, 0, 0
    },
    { /* articulation 54 */
        { 32767, 0, 32767, 0 },
        { 190, 190, 0, 0 },
        0, 0, 951, -600, 0, 0, 0, 0, 0
    },
    { /* articulation 55 */
        { 32767, 0, 32767, 0 },
        { 190, 190, 0, 0 },
        0, 0, 951, -100, 0, 0, 0, 0, 0
    },
    { /* articulation 56 */
        { 32767, 0, 32767, 0 },
        { 190, 190, 0, 0 },
        0, 0, 951, -50, 0, 0, 0, 0, 0
    },
    { /* articulation 57 */
        { 32767, 0, 32767, 0 },
        { 190, 190, 0, 0 },
        0, 0, 951, 50, 0, 0, 0, 0, 0
    },
    { /* articulation 58 */
        { 32767, 0, 32767, 0 },
        { 190, 190, 0, 0 },
        0, 0, 951, 100, 0, 0, 0, 0, 0
    },
    { /* articulation 59 */
        { 32767, 0, 32767, 0 },
        { 190, 190, 0, 0 },
        0, 0, 951, 600, 0, 0, 0, 0, 0
    },
    { /* articulation 60 */
        { 32767, 0, 32767, 0 },
        { 190, 190, 0, 0 },
        0, 0, 951, 1200, 0, 0, 0, 0, 0
    },
    { /* articulation 61 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 5535, 0, 0, 0
    },
    { /* articulation 62 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 7121, 0, 0, 0
    },
    { /* articulation 63 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 8321, 0, 0, 0
    },
    { /* articulation 64 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 9906, 0, 0, 0
    },
    { /* articulation 65 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 11106, 0, 0, 0
    },
    { /* articulation 66 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 9521, 0, 0, 0
    },
    { /* articulation 67 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 9521, 0, 8, 0
    },
    { /* articulation 68 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 9521, 0, 16, 0
    },
    { /* articulation 69 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 9521, 0, 24, 0
    },
    { /* articulation 70 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 9521, 0, 30, 0
    },
    { /* articulation 71 */
        { 32767, 0, 32767, 0 },
        { 190, 190, 0, 0 },
        0, 0, 951, 0, -6400, 9521, 0, 0, 0
    },
    { /* articulation 72 */
        { 32767, 0, 32767, 0 },
        { 190, 190, 0, 0 },
        0, 0, 951, 0, -3200, 9521, 0, 0, 0
    },
    { /* articulation 73 */
        { 32767, 0, 32767, 0 },
        { 190, 190, 0, 0 },
        0, 0, 951, 0, -1600, 9521, 0, 0, 0
    },
    { /* articulation 74 */
        { 32767, 0, 32767, 0 },
        { 190, 190, 0, 0 },
        0, 0, 951, 0, -800, 9521, 0, 0, 0
    },
    { /* articulation 75 */
        { 32767, 0, 32767, 0 },
        { 190, 190, 0, 0 },
        0, 0, 951, 0, 800, 7121, 0, 0, 0
    },
    { /* articulation 76 */
        { 190, 30725, 32767, 0 },
        { 190, 190, 0, 0 },
        0, 0, 951, 0, 1600, 7121, 0, 0, 0
    },
    { /* articulation 77 */
        { 32767, 0, 32767, 0 },
        { 190, 190, 0, 0 },
        0, 0, 951, 0, 3200, 7121, 0, 0, 0
    },
    { /* articulation 78 */
        { 32767, 0, 32767, 0 },
        { 190, 190, 0, 0 },
        0, 0, 951, 0, 6400, 7121, 0, 0, 0
    },
    { /* articulation 79 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 190, 0, 0, 11106, 0, 0, 0
    },
    { /* articulation 80 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 191, 0, 0, 11106, 0, 0, 0
    },
    { /* articulation 81 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 190, 0, 0, 7121, 0, 0, 0
    },
    { /* articulation 82 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, -63
    },
    { /* articulation 83 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, -50
    },
    { /* articulation 84 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, -37
    },
    { /* articulation 85 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, -25
    },
    { /* articulation 86 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, -12
    },
    { /* articulation 87 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 12
    },
    { /* articulation 88 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 25
    },
    { /* articulation 89 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 37
    },
    { /* articulation 90 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 50
    },
    { /* articulation 91 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 0, 0, 0, 63
    },
    { /* articulation 92 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 9907, 0, 0, 0
    },
    { /* articulation 93 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 10574, 0, 0, 0
    },
    { /* articulation 94 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 11373, 0, 0, 0
    },
    { /* articulation 95 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 951, 0, 0, 11376, 0, 0, 0
    },
    { /* articulation 96 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        100, 0, 949, 0, 0, 0, 0, 0, 0
    }
}; /*end Articulations */

/*----------------------------------------------------------------------------
 * Regions
 *----------------------------------------------------------------------------
*/
const S_WT_REGION testRegions[] =
{
    { { 32769, 0, 127 }, -6000, 32767, 101, 301, 4, 0 }, /* region 0 */
    { { 1, 0, 60 }, -6000, 32767, 101, 301, 4, 2 }, /* region 1 */
    { { 1, 61, 61 }, -6000, 32767, 101, 301, 4, 3 }, /* region 2 */
    { { 1, 62, 62 }, -6000, 32767, 101, 301, 4, 4 }, /* region 3 */
    { { 1, 63, 63 }, -6000, 32767, 101, 301, 4, 5 }, /* region 4 */
    { { 1, 64, 64 }, -6000, 32767, 101, 301, 4, 6 }, /* region 5 */
    { { 1, 65, 65 }, -6000, 32767, 101, 301, 4, 7 }, /* region 6 */
    { { 1, 66, 66 }, -6000, 32767, 101, 301, 4, 8 }, /* region 7 */
    { { 32769, 67, 127 }, -6000, 32767, 101, 301, 4, 9 }, /* region 8 */
    { { 32769, 0, 127 }, -6005, 32767, 3, 171, 5, 0 }, /* region 9 */
    { { 32768, 0, 127 }, -6555, 32767, 0, 0, 2, 0 }, /* region 10 */
    { { 32770, 0, 127 }, -6000, 32767, 0, 0, 0, 0 }, /* region 11 */
    { { 1, 60, 60 }, -6000, 32767, 101, 301, 4, 0 }, /* region 12 */
    { { 1, 61, 61 }, -6100, 16422, 101, 151, 4, 0 }, /* region 13 */
    { { 1, 62, 62 }, -6200, 8231, 101, 151, 4, 0 }, /* region 14 */
    { { 1, 63, 63 }, -6300, 2067, 101, 151, 4, 0 }, /* region 15 */
    { { 1, 64, 64 }, -6400, 130, 101, 151, 4, 0 }, /* region 16 */
    { { 32769, 65, 65 }, -6500, 1, 101, 151, 4, 0 }, /* region 17 */
    { { 1, 60, 60 }, -6000, 32767, 101, 301, 4, 0 }, /* region 18 */
    { { 1, 61, 61 }, -6200, 32767, 101, 151, 4, 0 }, /* region 19 */
    { { 1, 62, 62 }, -6400, 32767, 101, 151, 4, 0 }, /* region 20 */
    { { 1, 63, 63 }, -6600, 32767, 101, 151, 4, 0 }, /* region 21 */
    { { 1, 64, 64 }, -6800, 32767, 101, 151, 4, 0 }, /* region 22 */
    { { 1, 65, 65 }, -7000, 32767, 101, 151, 4, 0 }, /* region 23 */
    { { 1, 66, 66 }, -7200, 32767, 101, 151, 4, 0 }, /* region 24 */
    { { 1, 67, 67 }, -7400, 32767, 101, 151, 4, 0 }, /* region 25 */
    { { 1, 68, 68 }, -7600, 32767, 101, 151, 4, 0 }, /* region 26 */
    { { 1, 69, 69 }, -7800, 32767, 101, 151, 4, 0 }, /* region 27 */
    { { 1, 70, 70 }, -8000, 32767, 101, 151, 4, 0 }, /* region 28 */
    { { 1, 71, 71 }, -8200, 32767, 101, 151, 4, 0 }, /* region 29 */
    { { 32769, 72, 72 }, -8400, 32767, 101, 151, 4, 0 }, /* region 30 */
    { { 1, 60, 60 }, -6000, 32767, 101, 301, 4, 0 }, /* region 31 */
    { { 1, 61, 61 }, -6099, 32767, 101, 151, 4, 0 }, /* region 32 */
    { { 1, 62, 62 }, -6190, 32767, 101, 151, 4, 0 }, /* region 33 */
    { { 1, 63, 63 }, -6250, 32767, 101, 151, 4, 0 }, /* region 34 */
    { { 1, 64, 64 }, -6300, 32767, 101, 151, 4, 0 }, /* region 35 */
    { { 1, 65, 65 }, -6500, 32767, 101, 151, 4, 0 }, /* region 36 */
    { { 1, 66, 66 }, -6601, 32767, 101, 151, 4, 0 }, /* region 37 */
    { { 1, 67, 67 }, -6710, 32767, 101, 151, 4, 0 }, /* region 38 */
    { { 1, 68, 68 }, -6850, 32767, 101, 151, 4, 0 }, /* region 39 */
    { { 32769, 69, 69 }, -7000, 32767, 101, 151, 4, 0 }, /* region 40 */
    { { 1, 0, 0 }, 0, 32767, 101, 151, 4, 1 }, /* region 41 */
    { { 1, 1, 1 }, -100, 32767, 101, 151, 4, 10 }, /* region 42 */
    { { 1, 2, 2 }, -200, 32767, 101, 151, 4, 11 }, /* region 43 */
    { { 1, 3, 3 }, -300, 32767, 101, 151, 4, 12 }, /* region 44 */
    { { 1, 4, 4 }, -400, 32767, 101, 151, 4, 13 }, /* region 45 */
    { { 1, 5, 5 }, -500, 32767, 101, 151, 4, 14 }, /* region 46 */
    { { 1, 6, 6 }, -600, 32767, 101, 151, 4, 0 }, /* region 47 */
    { { 1, 7, 7 }, -700, 32767, 101, 151, 4, 15 }, /* region 48 */
    { { 1, 8, 8 }, -800, 32767, 101, 151, 4, 16 }, /* region 49 */
    { { 1, 9, 9 }, -900, 32767, 101, 151, 4, 17 }, /* region 50 */
    { { 1, 10, 10 }, -1000, 32767, 101, 151, 4, 18 }, /* region 51 */
    { { 1, 11, 11 }, -1100, 32767, 101, 151, 4, 19 }, /* region 52 */
    { { 1, 12, 12 }, -1200, 32767, 101, 151, 4, 20 }, /* region 53 */
    { { 1, 13, 13 }, -1300, 32767, 101, 151, 4, 21 }, /* region 54 */
    { { 1, 14, 14 }, -1400, 32767, 101, 151, 4, 22 }, /* region 55 */
    { { 1, 15, 15 }, -1500, 32767, 101, 151, 4, 23 }, /* region 56 */
    { { 1, 16, 16 }, -1600, 32767, 101, 151, 4, 24 }, /* region 57 */
    { { 1, 17, 17 }, -1700, 32767, 101, 151, 4, 25 }, /* region 58 */
    { { 1, 18, 18 }, -1800, 32767, 101, 151, 4, 26 }, /* region 59 */
    { { 1, 19, 19 }, -1900, 32767, 101, 151, 4, 27 }, /* region 60 */
    { { 1, 20, 20 }, -2000, 32767, 101, 151, 4, 28 }, /* region 61 */
    { { 1, 21, 21 }, -2100, 32767, 101, 151, 4, 29 }, /* region 62 */
    { { 1, 22, 22 }, -2200, 32767, 101, 151, 4, 30 }, /* region 63 */
    { { 1, 23, 23 }, -2300, 32767, 101, 151, 4, 31 }, /* region 64 */
    { { 1, 24, 24 }, -2400, 32767, 101, 151, 4, 32 }, /* region 65 */
    { { 1, 25, 25 }, -2500, 32767, 101, 151, 4, 33 }, /* region 66 */
    { { 1, 26, 26 }, -2600, 32767, 101, 151, 4, 24 }, /* region 67 */
    { { 1, 27, 27 }, -2700, 32767, 101, 151, 4, 0 }, /* region 68 */
    { { 1, 28, 28 }, -2800, 32767, 101, 151, 4, 34 }, /* region 69 */
    { { 1, 29, 29 }, -2900, 32767, 101, 151, 4, 35 }, /* region 70 */
    { { 1, 30, 30 }, -3000, 32767, 101, 151, 4, 36 }, /* region 71 */
    { { 1, 31, 31 }, -3100, 32767, 101, 151, 4, 37 }, /* region 72 */
    { { 1, 32, 32 }, -3200, 32767, 101, 151, 4, 38 }, /* region 73 */
    { { 1, 33, 33 }, -3300, 32767, 101, 151, 4, 39 }, /* region 74 */
    { { 1, 34, 34 }, -3400, 32767, 101, 151, 4, 40 }, /* region 75 */
    { { 1, 35, 35 }, -3500, 32767, 101, 151, 4, 41 }, /* region 76 */
    { { 1, 36, 36 }, -3600, 32767, 101, 151, 4, 42 }, /* region 77 */
    { { 1, 37, 37 }, -3700, 32767, 101, 151, 4, 43 }, /* region 78 */
    { { 1, 38, 38 }, -3800, 32767, 101, 151, 4, 44 }, /* region 79 */
    { { 1, 39, 39 }, -3900, 32767, 101, 151, 4, 45 }, /* region 80 */
    { { 1, 40, 40 }, -4000, 32767, 101, 151, 4, 46 }, /* region 81 */
    { { 1, 41, 41 }, -4100, 32767, 101, 151, 4, 47 }, /* region 82 */
    { { 1, 42, 42 }, -4200, 32767, 101, 151, 4, 48 }, /* region 83 */
    { { 1, 43, 43 }, -4300, 32767, 101, 151, 4, 49 }, /* region 84 */
    { { 1, 44, 44 }, -4400, 32767, 101, 151, 4, 50 }, /* region 85 */
    { { 1, 45, 45 }, -4500, 32767, 101, 151, 4, 51 }, /* region 86 */
    { { 1, 46, 46 }, -4600, 32767, 101, 151, 4, 52 }, /* region 87 */
    { { 1, 47, 47 }, -4700, 32767, 101, 151, 4, 53 }, /* region 88 */
    { { 1, 48, 48 }, -4800, 32767, 101, 151, 4, 54 }, /* region 89 */
    { { 1, 49, 49 }, -4900, 32767, 101, 151, 4, 55 }, /* region 90 */
    { { 1, 50, 50 }, -5000, 32767, 101, 151, 4, 56 }, /* region 91 */
    { { 1, 51, 51 }, -5100, 32767, 101, 151, 4, 57 }, /* region 92 */
    { { 1, 52, 52 }, -5200, 32767, 101, 151, 4, 58 }, /* region 93 */
    { { 1, 53, 53 }, -5300, 32767, 101, 151, 4, 59 }, /* region 94 */
    { { 1, 54, 54 }, -5400, 32767, 101, 151, 4, 60 }, /* region 95 */
    { { 2, 55, 55 }, -5500, 32767, 0, 0, 0, 61 }, /* region 96 */
    { { 2, 56, 56 }, -5600, 32767, 0, 0, 0, 62 }, /* region 97 */
    { { 2, 57, 57 }, -5700, 32767, 0, 0, 0, 63 }, /* region 98 */
    { { 2, 58, 58 }, -5800, 32767, 0, 0, 0, 64 }, /* region 99 */
    { { 2, 59, 59 }, -5900, 32767, 0, 0, 0, 65 }, /* region 100 */
    { { 2, 60, 60 }, -6000, 32767, 0, 0, 0, 0 }, /* region 101 */
    { { 2, 61, 61 }, -6100, 32767, 0, 0, 0, 66 }, /* region 102 */
    { { 2, 62, 62 }, -6200, 32767, 0, 0, 0, 67 }, /* region 103 */
    { { 2, 63, 63 }, -6300, 32767, 0, 0, 0, 68 }, /* region 104 */
    { { 2, 64, 64 }, -6400, 32767, 0, 0, 0, 69 }, /* region 105 */
    { { 2, 65, 65 }, -6500, 32767, 0, 0, 0, 70 }, /* region 106 */
    { { 2, 66, 66 }, -6600, 32767, 0, 0, 0, 71 }, /* region 107 */
    { { 2, 67, 67 }, -6700, 32767, 0, 0, 0, 72 }, /* region 108 */
    { { 2, 68, 68 }, -6800, 32767, 0, 0, 0, 73 }, /* region 109 */
    { { 2, 69, 69 }, -6900, 32767, 0, 0, 0, 74 }, /* region 110 */
    { { 2, 70, 70 }, -7000, 32767, 0, 0, 0, 75 }, /* region 111 */
    { { 2, 71, 71 }, -7100, 32767, 0, 0, 0, 76 }, /* region 112 */
    { { 2, 72, 72 }, -7200, 32767, 0, 0, 0, 77 }, /* region 113 */
    { { 2, 73, 73 }, -7300, 32767, 0, 0, 0, 78 }, /* region 114 */
    { { 2, 74, 74 }, -7400, 32767, 0, 0, 0, 79 }, /* region 115 */
    { { 2, 75, 75 }, -7500, 32767, 0, 0, 0, 79 }, /* region 116 */
    { { 2, 76, 76 }, -7600, 32767, 0, 0, 0, 79 }, /* region 117 */
    { { 2, 77, 77 }, -7700, 32767, 0, 0, 0, 80 }, /* region 118 */
    { { 2, 78, 78 }, -7800, 32767, 0, 0, 0, 81 }, /* region 119 */
    { { 2, 79, 79 }, -7900, 32767, 0, 0, 0, 81 }, /* region 120 */
    { { 2, 80, 80 }, -8000, 32767, 0, 0, 0, 81 }, /* region 121 */
    { { 2, 81, 81 }, -8100, 32767, 0, 0, 0, 81 }, /* region 122 */
    { { 2, 82, 82 }, -8200, 32767, 0, 0, 0, 0 }, /* region 123 */
    { { 257, 83, 83 }, -8300, 32767, 101, 151, 4, 0 }, /* region 124 */
    { { 257, 84, 84 }, -8405, 32767, 0, 171, 5, 0 }, /* region 125 */
    { { 0, 85, 85 }, -9055, 32767, 0, 0, 2, 82 }, /* region 126 */
    { { 0, 86, 86 }, -9155, 32767, 0, 0, 2, 83 }, /* region 127 */
    { { 0, 87, 87 }, -9255, 32767, 0, 0, 2, 84 }, /* region 128 */
    { { 0, 88, 88 }, -9355, 32767, 0, 0, 2, 85 }, /* region 129 */
    { { 0, 89, 89 }, -9455, 32767, 0, 0, 2, 86 }, /* region 130 */
    { { 0, 90, 90 }, -9555, 32767, 0, 0, 2, 0 }, /* region 131 */
    { { 0, 91, 91 }, -9655, 32767, 0, 0, 2, 87 }, /* region 132 */
    { { 0, 92, 92 }, -9755, 32767, 0, 0, 2, 88 }, /* region 133 */
    { { 0, 93, 93 }, -9855, 32767, 0, 0, 2, 89 }, /* region 134 */
    { { 0, 94, 94 }, -9955, 32767, 0, 0, 2, 90 }, /* region 135 */
    { { 0, 95, 95 }, -10055, 32767, 0, 0, 2, 91 }, /* region 136 */
    { { 2, 96, 96 }, -9600, 32767, 0, 0, 0, 63 }, /* region 137 */
    { { 2, 97, 97 }, -9700, 32767, 0, 0, 0, 92 }, /* region 138 */
    { { 2, 98, 98 }, -9800, 32767, 0, 0, 0, 93 }, /* region 139 */
    { { 2, 99, 99 }, -9900, 32767, 0, 0, 0, 94 }, /* region 140 */
    { { 2, 100, 100 }, -10000, 32767, 0, 0, 0, 95 }, /* region 141 */
    { { 32770, 101, 101 }, -10100, 32767, 0, 0, 0, 0 }, /* region 142 */
    { { 1, 36, 60 }, -6000, 32767, 1481, 1565, 0, 0 }, /* region 143 */
    { { 1, 61, 61 }, -7300, 32767, 740, 782, 1, 0 }, /* region 144 */
    { { 32769, 62, 62 }, -8599, 32767, 370, 391, 3, 0 }, /* region 145 */
    { { 32769, 60, 60 }, -6000, 32767, 101, 301, 4, 1 }, /* region 146 */
    { { 32769, 60, 60 }, -6000, 32767, 101, 301, 4, 50 }, /* region 147 */
    { { 32769, 60, 60 }, -6000, 32767, 101, 301, 4, 11 }, /* region 148 */
    { { 32769, 60, 60 }, -6000, 32767, 101, 301, 4, 96 }, /* region 149 */
    { { 32769, 60, 60 }, -6000, 32767, 101, 301, 4, 13 }, /* region 150 */
    { { 32769, 60, 60 }, -6000, 32767, 101, 301, 4, 14 } /* region 151 */
}; /* end Regions */

/*----------------------------------------------------------------------------
 * Programs
 *----------------------------------------------------------------------------
*/
const S_PROGRAM testPrograms[] =
{
    { 0, 41 } /* program 0 */,
    { 1, 10 } /* program 1 */,
    { 2, 11 } /* program 2 */,
    { 3, 12 } /* program 3 */,
    { 4, 18 } /* program 4 */,
    { 5, 31 } /* program 5 */,
    { 6, 143 } /* program 6 */,
    { 7, 146 } /* program 7 */,
    { 8, 147 } /* program 8 */,
    { 9, 148 } /* program 9 */,
    { 10, 149 } /* program 10 */,
    { 11, 150 } /* program 11 */,
    { 12, 151 } /* program 12 */,
    { 13, 0 } /* program 13 */,
    { 14, 9 } /* program 14 */,
    { 15, 1 } /* program 15 */
}; /* end Programs */

/*----------------------------------------------------------------------------
 * Banks
 *----------------------------------------------------------------------------
*/
#define testBanks NULL

/*----------------------------------------------------------------------------
 * Samples
 *----------------------------------------------------------------------------
*/

const EAS_SAMPLE testSamples[] =
{
      -1,   -1,   -1,   -1,    0,    1,    2,    3,    4,    5,    6,    7,    9,   10,   11,   12,
      13,   13,   14,   13,   13,   13,   12,   12,   10,    9,    8,    6,    5,    3,    2,    0,
      -1,   -3,   -5,   -8,  -10,  -12,  -14,  -15,  -16,  -17,  -17,  -17,  -17,  -16,  -14,  -13,
     -11,  -10,   -8,   -6,   -5,   -4,   -4,   -3,   -3,   -2,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -2,   -3,   -3,   -3,   -3,   -3,   -2,   -2,   -2,   -1,   -1,   -1,   -1,    0,    0,
       0,    0,    0,    0,    0,    1,    2,    4,    6,    9,   11,   12,   13,   15,   16,   17,
      19,   20,   22,   23,   25,   28,   32,   34,   36,   36,   35,   31,   25,   18,   11,    3,
      -5,  -13,  -20,  -26,  -31,  -34,  -35,  -36,  -36,  -35,  -34,  -32,  -29,  -26,  -23,  -19,
     -16,  -12,   -8,   -5,   -4,   -4,   -4,   -6,   -8,   -9,  -11,  -11,  -12,  -13,  -13,  -13,
     -12,  -11,  -10,   -9,   -7,   -5,   -4,   -3,   -2,   -1,   -1,    0,    0,    2,    4,    5,
       7,    7,    7,    7,    6,    6,    6,    6,    6,    6,    7,    9,   12,   14,   17,   20,
      24,   27,   30,   33,   36,   39,   41,   43,   46,   49,   51,   51,   50,   48,   43,   35,
      25,   14,    1,  -12,  -25,  -37,  -48,  -56,  -61,  -63,  -62,  -60,  -57,  -53,  -48,  -42,
     -35,  -29,  -23,  -17,  -12,   -8,   -5,   -3,   -3,   -4,   -5,   -7,   -9,  -11,  -12,  -14,
     -14,  -14,  -14,  -13,  -11,   -9,   -7,   -5,   -3,   -1,    0,    1,    1,    1,    2,    3,
       4,    5,    6,    6,    7,    8,    9,   10,   11,   11,   11,   11,   10,    9,    9,   10,
      12,   14,   17,   20,   23,   26,   30,   34,   38,   40,   43,   46,   49,   52,   55,   57,
      58,   56,   50,   42,   30,   16,    1,  -15,  -29,  -43,  -54,  -63,  -68,  -69,  -68,  -65,
     -60,  -55,  -49,  -42,  -35,  -29,  -22,  -16,  -10,   -6,   -2,   -1,    0,   -1,   -3,   -6,
      -9,  -12,  -16,  -18,  -20,  -21,  -21,  -21,  -19,  -17,  -14,  -11,   -8,   -5,   -2,    1,
       3,    5,    7,    9,   11,   12,   12,   12,   11,   10,    9,    8,    7,    7,    7,    7,
       8,    9,   10,   12,   15,   17,   19,   22,   24,   26,   28,   30,   32,   34,   36,   38,
      42,   44,   47,   49,   53,   56,   55,   52,   45,   35,   22,    8,   -8,  -23,  -37,  -50,
     -60,  -67,  -71,  -71,  -69,  -63,  -56,  -48,  -40,  -33,  -27,  -21,  -16,  -12,   -8,   -6,
      -5,   -5,   -6,   -8,  -11,  -14,  -17,  -19,  -21,  -22,  -22,  -22,  -20,  -18,  -16,  -13,
      -9,   -6,   -2,    1,    5,    7,    8,    9,   10,   11,   11,   11,   10,   10,    9,    9,
       9,    8,    8,    9,    9,   10,   10,   12,   13,   14,   16,   18,   19,   21,   24,   26,
      29,   32,   35,   39,   42,   46,   49,   51,   53,   56,   59,   59,   55,   48,   37,   22,
       5,  -12,  -29,  -45,  -58,  -68,  -74,  -77,  -77,  -75,  -69,  -62,  -53,  -44,  -35,  -28,
     -21,  -15,  -11,   -8,   -5,   -4,   -4,   -4,   -6,   -8,  -10,  -13,  -15,  -17,  -19,  -19,
     -19,  -18,  -16,  -13,  -10,   -8,   -4,   -1,    1,    4,    5,    7,    8,   10,   11,   12,
      13,   14,   14,   13,   12,   12,   11,    9,    8,    7,    6,    6,    7,    8,   10,   12,
      15,   18,   21,   25,   29,   34,   39,   45,   51,   57,   61,   67,   73,   77,   82,   84,
      81,   70,   52,   29,    3,  -24,  -49,  -72,  -90, -103, -110, -112, -109, -102,  -91,  -78,
     -64,  -49,  -35,  -23,  -13,   -5,    1,    5,    8,    9,    9,    7,    4,    0,   -4,   -9,
     -12,  -15,  -18,  -18,  -18,  -17,  -14,  -12,   -9,   -6,   -3,    0,    3,    6,    8,   10,
      11,   12,   11,   11,   10,    8,    7,    5,    4,    2,    2,    1,    2,    3,    4,    6,
       8,   11,   13,   15,   18,   21,   26,   31,   36,   42,   48,   53,   60,   66,   72,   77,
      82,   87,   91,   91,   86,   73,   54,   28,   -2,  -32,  -61,  -86, -105, -119, -126, -126,
    -121, -111,  -98,  -82,  -65,  -48,  -33,  -19,   -7,    1,    8,   12,   14,   14,   12,   10,
       6,    1,   -4,   -9,  -14,  -18,  -20,  -21,  -22,  -21,  -19,  -17,  -14,  -11,   -8,   -4,
       0,    3,    7,   10,   12,   13,   14,   14,   13,   12,   11,   10,    9,    8,    7,    5,
       4,    3,    2,    2,    4,    6,    9,   12,   16,   20,   26,   31,   36,   42,   48,   53,
      58,   64,   69,   74,   79,   82,   84,   83,   80,   72,   59,   39,   14,  -14,  -43,  -70,
     -92, -109, -119, -123, -120, -113, -102,  -88,  -73,  -56,  -40,  -25,  -12,   -2,    5,   10,
      12,   12,   11,    9,    5,    1,   -3,   -8,  -12,  -15,  -18,  -20,  -21,  -21,  -20,  -18,
     -16,  -13,   -9,   -6,   -2,    1,    5,    8,   11,   13,   15,   16,   16,   16,   15,   14,
      12,   10,    7,    5,    4,    3,    3,    5,    6,    8,    9,   12,   15,   19,   23,   27,
      31,   35,   38,   42,   46,   50,   54,   59,   65,   71,   75,   77,   78,   76,   68,   54,
      34,   10,  -16,  -43,  -68,  -88, -103, -112, -114, -112, -105,  -94,  -80,  -65,  -50,  -35,
     -22,  -10,   -2,    5,    9,   11,   10,    9,    6,    2,   -3,   -7,  -12,  -15,  -18,  -20,
     -21,  -22,  -21,  -20,  -17,  -14,  -11,   -7,   -3,    0,    4,    7,    9,   11,   13,   15,
      17,   17,   17,   16,   14,   12,   11,   10,    8,    7,    5,    5,    5,    6,    7,    8,
      10,   11,   14,   17,   20,   24,   28,   32,   37,   43,   49,   57,   63,   70,   77,   82,
      83,   80,   73,   60,   42,   18,   -8,  -34,  -59,  -80,  -95, -105, -110, -109, -103,  -94,
     -81,  -67,  -53,  -38,  -24,  -13,   -3,    4,    9,   11,   11,    9,    6,    3,   -2,   -6,
     -10,  -14,  -17,  -19,  -20,  -20,  -20,  -19,  -17,  -15,  -12,   -8,   -5,   -1,    2,    6,
       9,   11,   13,   15,   15,   16,   16,   15,   14,   12,   11,    9,    8,    6,    6,    5,
       5,    5,    6,    7,    8,   10,   12,   15,   19,   23,   28,   32,   38,   44,   50,   58,
      66,   74,   82,   87,   90,   89,   83,   69,   48,   21,   -9,  -41,  -69,  -93, -111, -121,
    -124, -121, -113, -100,  -85,  -68,  -50,  -33,  -18,   -5,    5,   12,   16,   17,   16,   13,
       9,    4,   -1,   -6,  -11,  -15,  -18,  -20,  -21,  -21,  -21,  -19,  -17,  -15,  -12,   -8,
      -4,   -1,    3,    6,    9,   12,   14,   15,   15,   14,   13,   12,   11,   10,    9,    9,
       8,    8,    6,    6,    5,    5,    6,    7,    8,   11,   15,   18,   23,   27,   31,   36,
      41,   46,   51,   58,   66,   74,   82,   88,   91,   90,   83,   68,   46,   16,  -16,  -48,
     -77, -101, -118, -127, -128, -124, -114, -101,  -84,  -66,  -47,  -30,  -14,   -1,    9,   16,
      19,   20,   19,   15,   11,    5,   -1,   -6,  -11,  -16,  -19,  -21,  -23,  -23,  -23,  -21,
     -19,  -16,  -12,   -8,   -4,    0,    4,    8,   11,   13,   14,   15,   15,   14,   13,   12,
      11,   10,    9,    8,    7,    7,    7,    7,    7,    8,    8,    9,   11,   12,   14,   16,
      19,   23,   27,   31,   35,   40,   45,   51,   58,   66,   74,   82,   88,   90,   88,   77,
      58,   32,    1,  -31,  -62,  -87, -107, -119, -125, -123, -117, -105,  -90,  -73,  -56,  -38,
     -22,   -8,    2,   10,   15,   17,   17,   15,   11,    7,    2,   -4,   -9,  -14,  -17,  -20,
     -22,  -23,  -22,  -21,  -19,  -17,  -14,  -10,   -6,   -2,    2,    5,    9,   12,   14,   15,
      17,   18,   18,   18,   17,   15,   12,   10,    8,    6,    4,    4,    4,    5,    6,    7,
       8,   10,   13,   16,   19,   22,   25,   28,   32,   35,   40,   45,   52,   59,   67,   75,
      81,   85,   86,   80,   66,   45,   18,  -12,  -42,  -69,  -91, -107, -116, -119, -115, -107,
     -95,  -80,  -64,  -47,  -31,  -17,   -5,    4,   10,   13,   14,   14,   11,    7,    3,   -2,
      -7,  -12,  -15,  -18,  -20,  -21,  -21,  -20,  -18,  -16,  -14,  -11,   -7,   -4,    0,    4,
       7,   10,   12,   14,   16,   16,   16,   16,   16,   15,   14,   12,   10,    9,    7,    6,
       5,    4,    4,    5,    6,    7,    8,   10,   12,   15,   19,   23,   27,   31,   36,   41,
      47,   55,   64,   73,   81,   87,   90,   86,   75,   56,   30,    1,  -30,  -58,  -82, -100,
    -112, -117, -115, -109,  -98,  -84,  -69,  -52,  -37,  -22,  -10,    0,    8,   12,   14,   14,
      13,   10,    6,    2,   -3,   -8,  -12,  -16,  -18,  -20,  -20,  -20,  -19,  -17,  -15,  -12,
      -9,   -5,   -1,    2,    6,    9,   12,   14,   16,   17,   17,   17,   16,   14,   13,   11,
       8,    6,    4,    3,    2,    2,    2,    3,    5,    6,    8,   10,   12,   15,   18,   22,
      26,   30,   35,   40,   47,   55,   63,   71,   80,   87,   90,   88,   78,   59,   34,    4,
     -27,  -57,  -82, -101, -113, -118, -117, -110,  -99,  -85,  -69,  -53,  -37,  -22,   -9,    2,
       9,   14,   17,   17,   15,   12,    8,    3,   -2,   -7,  -12,  -16,  -19,  -20,  -21,  -21,
     -19,  -18,  -15,  -12,   -9,   -6,   -2,    2,    6,    9,   12,   14,   16,   17,   17,   16,
      14,   12,   10,    8,    6,    5,    4,    3,    3,    2,    3,    4,    6,    7,    9,   11,
      13,   16,   19,   22,   26,   30,   34,   39,   46,   53,   61,   70,   80,   88,   93,   91,
      80,   61,   34,    3,  -30,  -59,  -84, -102, -114, -119, -117, -110,  -99,  -84,  -68,  -51,
     -35,  -20,   -7,    3,   11,   15,   17,   18,   16,   13,    9,    4,   -2,   -7,  -11,  -15,
     -18,  -20,  -21,  -21,  -20,  -19,  -16,  -14,  -11,   -8,   -4,    0,    3,    7,   10,   13,
      15,   16,   17,   16,   14,   12,   10,    9,    7,    6,    5,    4,    4,    4,    5,    6,
       7,    8,    9,   11,   13,   15,   18,   21,   24,   27,   31,   35,   41,   48,   55,   64,
      73,   82,   89,   91,   85,   71,   48,   19,  -13,  -44,  -71,  -93, -108, -117, -118, -114,
    -105,  -92,  -77,  -60,  -43,  -27,  -13,   -1,    8,   14,   17,   18,   17,   14,    8,   13,
      -1,   -1,    0,    2,    4,    6,    9,   11,   13,   14,   13,   12,   11,    8,    5,    2,
      -1,   -5,  -10,  -14,  -16,  -17,  -16,  -14,  -11,   -8,   -5,   -4,   -3,   -1,   -1,   -1,
      -1,   -3,   -3,   -3,   -2,   -1,   -1,    0,    0,    0,    0,    2,    6,   11,   14,   16,
      19,   22,   25,   32,   36,   34,   25,   11,   -5,  -20,  -31,  -35,  -36,  -34,  -29,  -23,
     -16,   -8,   -4,   -4,   -8,  -11,  -12,  -13,  -12,  -10,   -7,   -4,   -2,   -1,    1,    4,
       7,    7,    6,    6,    6,    7,   12,   17,   24,   30,   36,   41,   46,   51,   50,   43,
      25,    2,  -25,  -48,  -61,  -62,  -57,  -48,  -35,  -23,  -12,   -5,   -3,   -5,   -9,  -12,
     -14,  -14,  -12,   -7,   -3,    0,    1,    2,    4,    6,    7,    9,   11,   11,   10,    9,
      12,   17,   23,   30,   37,   43,   49,   55,   58,   50,   30,    1,  -29,  -54,  -68,  -68,
     -60,  -49,  -35,  -22,  -10,   -2,    0,   -3,   -9,  -16,  -20,  -21,  -19,  -14,   -8,   -2,
       3,    7,   11,   12,   11,    9,    7,    7,    8,   10,   15,   19,   24,   28,   33,   36,
      42,   47,   53,   56,   45,   23,   -8,  -37,  -60,  -71,  -69,  -56,  -40,  -27,  -16,   -8,
      -5,   -6,  -11,  -17,  -21,  -22,  -20,  -16,   -9,   -2,    5,    8,   10,   11,   10,    9,
       8,    8,    9,   10,   13,   16,   19,   24,   29,   35,   42,   49,   53,   59,   55,   37,
       5,  -29,  -58,  -74,  -77,  -69,  -53,  -35,  -21,  -11,   -5,   -4,   -6,  -10,  -15,  -19,
     -19,  -16,  -10,   -5,    1,    5,    8,   11,   13,   14,   12,   10,    8,    6,    7,   10,
      15,   21,   29,   39,   51,   62,   72,   82,   81,   52,    3,  -50,  -90, -110, -109,  -91,
     -64,  -35,  -13,    1,    8,    9,    4,   -4,  -12,  -18,  -18,  -14,   -9,   -3,    3,    8,
      11,   11,   10,    7,    4,    2,    2,    4,    8,   13,   18,   26,   36,   48,   60,   72,
      82,   91,   86,   54,   -2,  -61, -105, -126, -121,  -98,  -65,  -33,   -7,    8,   14,   12,
       6,   -4,  -14,  -20,  -22,  -19,  -14,   -8,    0,    7,   12,   14,   13,   11,    9,    7,
       4,    2,    4,    9,   16,   26,   36,   48,   58,   69,   79,   84,   80,   59,   14,  -43,
     -92, -119, -120, -102,  -73,  -40,  -12,    5,   12,   11,    5,   -3,  -12,  -18,  -21,  -20,
     -16,   -9,   -2,    5,   11,   15,   16,   15,   12,    7,    4,    4,    6,    9,   15,   23,
      31,   38,   46,   54,   65,   75,   78,   68,   34,  -16,  -68, -103, -114, -105,  -80,  -50,
     -22,   -1,    9,   10,    6,   -3,  -12,  -18,  -21,  -21,  -17,  -11,   -3,    4,    9,   13,
      16,   17,   14,   11,    8,    5,    5,    7,   10,   14,   20,   28,   37,   49,   64,   77,
      83,   73,   42,   -8,  -59,  -95, -110, -103,  -81,  -53,  -24,   -3,    9,   11,    6,   -2,
     -10,  -17,  -20,  -20,  -17,  -12,   -5,    2,    9,   13,   15,   16,   14,   11,    8,    6,
       5,    6,    8,   12,   19,   28,   38,   50,   66,   82,   90,   83,   48,   -9,  -69, -111,
    -124, -113,  -85,  -50,  -18,    5,   16,   16,    9,   -1,  -11,  -18,  -21,  -21,  -17,  -12,
      -5,    3,    9,   14,   15,   13,   11,    9,    8,    6,    5,    6,    8,   15,   23,   31,
      41,   52,   66,   82,   91,   83,   46,  -16,  -77, -118, -128, -114,  -84,  -47,  -14,    9,
      19,   19,   10,   -1,  -11,  -19,  -23,  -23,  -19,  -12,   -4,    4,   11,   14,   15,   13,
      11,    9,    7,    7,    7,    8,   11,   14,   19,   27,   35,   45,   58,   74,   88,   88,
      58,    1,  -62, -107, -125, -116,  -90,  -56,  -22,    2,   15,   17,   11,    2,   -9,  -17,
     -22,  -22,  -20,  -14,   -6,    2,    9,   14,   17,   18,   17,   12,    8,    4,    4,    6,
       8,   13,   19,   25,   32,   40,   52,   67,   81,   86,   66,   18,  -42,  -91, -116, -115,
     -95,  -64,  -31,   -5,   10,   14,   11,    3,   -7,  -15,  -20,  -21,  -18,  -14,   -7,    0,
       7,   12,   16,   17,   16,   14,   10,    7,    5,    4,    6,    8,   12,   19,   27,   36,
      47,   64,   81,   90,   75,   30,  -30,  -82, -112, -115,  -98,  -69,  -37,  -10,    8,   14,
      13,    6,   -3,  -12,  -18,  -20,  -19,  -15,   -9,   -1,    6,   12,   16,   17,   16,   13,
       8,    4,    2,    2,    5,    8,   12,   18,   26,   35,   47,   63,   80,   90,   78,   34,
     -27,  -82, -113, -117,  -99,  -69,  -37,   -9,    9,   17,   15,    8,   -2,  -12,  -19,  -21,
     -19,  -15,   -9,   -2,    6,   12,   16,   17,   14,   10,    6,    4,    3,    3,    6,    9,
      13,   19,   26,   34,   46,   61,   80,   93,   80,   34,  -30,  -84, -114, -117,  -99,  -68,
     -35,   -7,   11,   17,   16,    9,   -2,  -11,  -18,  -21,  -20,  -16,  -11,   -4,    3,   10,
      15,   17,   14,   10,    7,    5,    4,    5,    7,    9,   13,   18,   24,   31,   41,   55,
      73,   89,   85,   48,  -12,  -71, -108, -118, -104,  -77,  -43,  -13,    8,   16,   17,   16,
       0,   -3,   -4,   -5,   -4,    0,   -4,   -8,  -20,  -25,   51,   11,  -55,    9,   39,   55,
     -76,  -19,   92,  -23,  -58,    2,  -15,   57,   71,   34,  -41,   20,   51,   22,   63,  -21,
      63,   74,   32,   36,   99,  -14,   27,  102,   66,   90,   79,   77,   58,   66,   65,  114,
      69,   26,   30,   92,   90,   53,   78,   97,   77,   66,   39,   -4,   60,   57,   64,   68,
     -16,   36,   49,   12,   19,   12,  -12,   21,   11,  -32,  -19,  -41,  -44,  -12,  -36,  -44,
     -45,  -51,  -55,  -70,  -69,  -73,  -85, -102,  -86,  -99,  -92, -105, -108, -103, -100, -107,
    -112, -104, -113, -112, -104, -119, -124, -115,  -87, -100, -128, -106,  -83, -105, -108, -109,
     -91,  -95,  -90,  -83,  -80,  -79,  -83,  -68,  -59,  -53,  -63,  -69,  -57,  -28,  -11,  -38,
     -43,  -23,  -10,   -6,    3,    1,    6,   14,   21,   23,   34,   40,   42,   48,   57,   61,
      63,   65,   73,   82,   90,   82,   89,   98,  100,  110,  111,  109,  115,  120,  121,  121,
     123,  123,  123,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  121,  121,
     121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  120,  120,  120,  120,  120,  120,
     120,  120,  120,  120,  113,  104,  103,  113,  110,   94,   80,   88,   96,   89,   81,   70,
      68,   64,   59,   59,   54,   44,   44,   39,   31,   31,   21,   18,   16,    8,    6,    2,
      -3,   -6,  -13,  -19,  -27,  -31,  -34,  -30,  -38,  -47,  -48,  -51,  -56,  -64,  -68,  -67,
     -68,  -76,  -73,  -79,  -85,  -94,  -89,  -90,  -94,  -92,  -99, -100, -107, -107, -104, -107,
    -106, -112, -114, -113, -112, -111, -112, -116, -116, -115, -115, -115, -115, -115, -115, -115,
    -114, -114, -114, -114, -114, -114, -114, -114, -113, -113, -113, -113, -113, -108, -106, -107,
    -111, -110, -105, -108, -107, -102, -100, -103, -103, -100, -100,  -97,  -97, -100,  -99,  -97,
     -94,  -90,  -94,  -94,  -93,  -93,  -92,  -92,  -90,  -89,  -89,  -90,  -91,  -87,  -87,  -88,
     -89,  -88,  -84,  -85,  -88,  -87,  -86,  -85,  -85,  -84,  -82,  -83,  -83,  -82,  -81,  -80,
     -79,  -79,  -79,  -78,  -75,  -74,  -75,  -73,  -74,  -71,  -69,  -67,  -69,  -66,  -64,  -66,
     -65,  -64,  -62,  -58,  -57,  -57,  -57,  -56,  -52,  -51,  -50,  -48,  -46,  -43,  -43,  -42,
     -39,  -36,  -35,  -34,  -32,  -31,  -29,  -26,  -23,  -23,  -21,  -15,  -18,  -15,  -11,   -8,
      -6,   -7,    0,    2,    0,    2,    7,   15,   14,   15,   16,   19,   23,   27,   29,   30,
      31,   34,   41,   41,   42,   44,   45,   51,   55,   54,   56,   57,   60,   65,   67,   69,
      69,   71,   74,   77,   79,   78,   80,   82,   86,   86,   84,   86,   88,   87,   87,   87,
      87,   87,   86,   86,   86,   86,   86,   85,   85,   85,   85,   85,   84,   84,   84,   84,
      84,   83,   83,   83,   83,   83,   83,   82,   82,   82,   82,   82,   81,   81,   81,   81,
      81,   80,   80,   80,   80,   80,   79,   79,   79,   79,   79,   78,   78,   78,   78,   76,
      75,   72,   69,   67,   65,   64,   63,   59,   55,   54,   52,   50,   48,   45,   42,   38,
      36,   34,   31,   30,   27,   24,   21,   18,   16,   14,   12,    9,    7,    4,    1,   -2,
      -4,   -7,  -10,  -11,  -13,  -16,  -17,  -18,  -21,  -24,  -26,  -27,  -28,  -30,  -32,  -33,
     -35,  -36,  -38,  -39,  -41,  -42,  -43,  -45,  -45,  -46,  -47,  -48,  -49,  -50,  -51,  -50,
     -51,  -52,  -53,  -53,  -53,  -53,  -53,  -53,  -53,  -54,  -54,  -54,  -54,  -53,  -53,  -52,
     -52,  -52,  -51,  -51,  -51,  -50,  -50,  -50,  -48,  -49,  -48,  -47,  -46,  -45,  -45,  -44,
     -43,  -42,  -41,  -41,  -40,  -39,  -38,  -37,  -36,  -35,  -34,  -33,  -31,  -30,  -29,  -28,
     -27,  -26,  -24,  -24,  -23,  -22,  -21,  -20,  -19,  -18,  -17,  -16,  -15,  -14,  -13,  -13,
     -12,  -11,  -11,  -10,   -9,   -9,   -8,   -8,   -7,   -6,   -7,   -6,   -5,   -5,   -5,   -4,
      -4,   -3,   -3,   -3,   -3,   -3,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,    0,    0,
       0,    0,   -1,    0,    4,    9,   13,   13,   11,    5,   -1,  -10,  -16,  -17,  -11,   -5,
      -2,   -1,   -2,   -3,   -2,   -1,    0,    0,    6,   14,   19,   26,   36,   25,   -5,  -30,
     -36,  -29,  -16,   -4,   -7,  -13,  -12,   -7,   -2,    1,    6,    7,    6,   11,   24,   36,
      46,   50,   26,  -25,  -60,  -57,  -36,  -12,   -3,   -9,  -14,  -12,   -3,    1,    4,    7,
      11,   10,   12,   23,   37,   49,   58,   31,  -29,  -67,  -61,  -36,  -10,    0,   -9,  -20,
     -19,   -8,    3,   11,   11,    7,    8,   15,   24,   32,   41,   53,   45,   -7,  -60,  -68,
     -41,  -16,   -5,  -11,  -21,  -20,  -10,    4,   10,   10,    8,    9,   13,   19,   29,   42,
      54,   55,    6,  -57,  -77,  -54,  -21,   -6,   -6,  -15,  -19,  -11,    1,    8,   13,   12,
       8,    7,   15,   29,   50,   73,   80,    5,  -90, -109,  -65,  -13,    8,    4,  -13,  -18,
     -10,    3,   11,   10,    4,    2,    8,   18,   36,   60,   82,   86,    1, -105, -121,  -66,
      -8,   13,    6,  -14,  -22,  -15,   -1,   12,   13,    9,    4,    3,   16,   36,   58,   78,
      81,   15,  -91, -121,  -74,  -13,   12,    5,  -11,  -21,  -16,   -2,   11,   16,   12,    4,
       6,   15,   31,   46,   64,   79,   36,  -66, -115,  -81,  -23,    9,    6,  -11,  -21,  -17,
      -4,    9,   16,   15,    8,    5,    9,   20,   37,   63,   83,   43,  -57, -110,  -83,  -25,
       8,    7,  -10,  -20,  -17,   -5,    9,   15,   14,    8,    5,    8,   18,   37,   65,   91,
      50,  -67, -124,  -86,  -19,   16,    9,  -10,  -21,  -18,   -5,    9,   15,   11,    8,    5,
       8,   22,   40,   65,   92,   48,  -74, -128,  -85,  -16,   19,   11,  -11,  -23,  -19,   -4,
      10,   15,   11,    8,    7,   11,   19,   35,   57,   88,   60,  -58, -125,  -92,  -24,   15,
      12,   -8,  -22,  -20,   -7,    9,   17,   17,    8,    4,    8,   18,   31,   51,   81,   67,
     -38, -116,  -96,  -33,    9,   11,   -6,  -20,  -19,   -8,    7,   16,   16,   11,    5,    5,
      12,   26,   47,   80,   76,  -26, -111,  -99,  -39,    7,   13,   -3,  -18,  -19,   -9,    5,
      16,   16,    8,    2,    4,   12,   25,   46,   79,   79,  -23, -112, -101,  -39,    9,   15,
      -2,  -18,  -20,   -9,    5,   16,   14,    7,    3,    5,   13,   25,   44,   79,   81,  -25,
    -113, -100,  -37,   10,   16,   -1,  -18,  -20,  -11,    3,   15,   15,    7,    4,    6,   13,
      23,   40,   72,   86,   -7, -107, -106,  -46,    7,   16,    0,   16,   31,   47,   61,   75,
      87,   98,  107,  115,  121,  125,  127,  127,  125,  121,  116,  108,   99,   88,   75,   62,
      47,   32,   16,    0,  -16,  -31,  -47,  -61,  -75,  -87,  -98, -108, -116, -122, -126, -128,
    -128, -126, -123, -117, -109, -100,  -89,  -77,  -64,  -49,  -34,  -18,   -2,   14,   29,   45,
      59,   73,   86,   97,  106,  114,  121,  125,  127,  127,  126,  122,  116,  109,  100,   89,
      77,   63,   49,   34,   18,    2,  -14,  -30,  -45,  -60,  -73,  -86,  -97, -107, -115, -121,
    -126, -128, -128, -127, -123, -118, -110, -101,  -91,  -79,  -65,  -51,  -36,  -20,   -4,   12,
      28,   43,   58,   72,   84,   96,  106,  114,  120,  124,  127,  127,  126,  122,  117,  109,
     100,   90,   78,   64,   50,   35,   19,    3,  -13,  -29,  -44,  -59,  -73,  -85,  -97, -107,
    -115, -121, -125, -128, -128, -127, -123, -118, -110, -101,  -91,  -79,  -65,  -51,  -36,  -20,
      -4,   12,   28,   43,   58,   72,   84,   96,  106,  114,  120,  124,  127,  127,  126,  122,
     117,  109,  100,   90,   78,   64,   50,   35,   19,    3,  -13,  -29,  -44,  -59,  -73,  -85,
     -97, -107, -115, -121, -125, -128, -128, -127, -123, -118, -110, -101,  -91,  -79,  -65,  -51,
     -36,  -20,   -4,   12,   28,   43,   58,   72,   84,   96,  106,  114,  120,  124,  127,  127,
     126,  122,  117,  109,  100,   90,   78,   64,   50,   35,   19,    3,  -13,  -29,  -44,  -59,
     -73,  -85,  -97, -107, -115, -121, -125, -128, -128, -127, -123, -118, -110, -101,  -91,  -79,
     -65,  -51,  -36,  -20,   -4,   12,   28,   43,   58,   72,   84,   96,  106,  114,  120,  124,
     127,  127,  126,  122,  117,  109,  100,   90,   78,   64,   50,   35,   19,    3,  -13,  -29,
     -44,  -59,  -73,  -85,  -97, -107, -115, -121, -125, -128, -128, -127, -123, -118, -110, -101,
     -91,  -79,  -65,  -51,  -36,  -20,   -4,   12,    0, -104,  -55,  -11,   24,   33,   30,    7,
     -15,  -31,  -30,  -25,  -23,  -20,   -9,   10,   31,   59,   91,  111,  115,   92,   51,    7,
     -33,  -64,  -81,  -81,  -71,  -51,  -22,   16,   52,   74,   82,   81,   68,   38,    0,  -40,
     -81, -112, -124, -102,  -57,  -11,   24,   33,   30,    7,  -15,  -31,  -30,  -25,  -23,  -20,
      -9,   10,   31,   59,   91,  111,  115,   92,   51,    7,  -33,  -64,  -81,  -81,  -71,  -51,
     -22,   16,   52,   74,   82,   81,   68,   38,    0,  -40,  -81, -112, -124, -102,  -57,  -11,
      24,   33,   30,    7,  -15,  -31,  -30,  -25,  -23,  -20,   -9,   10,   31,   59,   91,  111,
     115,   92,   51,    7,  -33,  -64,  -81,  -81,  -71,  -51,  -22,   16,   52,   74,   82,   81,
      68,   38,    0,  -40,  -81, -112, -124, -102,  -57,  -11,   24,   33,   30,    7,  -15,  -31,
     -30,  -25,  -23,  -20,   -9,   10,   31,   59,   91,  111,  115,   92,   51,    7,  -33,  -64,
     -81,  -81,  -71,  -51,  -22,   16,   52,   74,   82,   81,   68,   38,    0,  -40,  -81, -112,
    -124, -102,  -57,  -11,    0
};

const EAS_U32 testSampleLengths[] =
{
    1568, 784, 642, 392, 302, 172
};

const EAS_U32 testSampleOffsets[] =
{
    0x00000000, 0x00000620, 0x00000930, 0x00000bb2, 0x00000d3a, 0x00000e68
};

/*----------------------------------------------------------------------------
 * S_EAS
 *----------------------------------------------------------------------------
*/
const S_EAS easTestLib =
{
    0x01534145,
    0x00105622,
    testBanks,
    testPrograms,
    testRegions,
    testArticulations,
    testSampleLengths,
    testSampleOffsets,
    testSamples,
    0,
    0,
    16,
    152,
    97,
    6,
    0
}; /* end S_EAS */

/*----------------------------------------------------------------------------
 * Statistics
 *
 * Number of banks: 0
 * Number of programs: 16
 * Number of regions: 152
 * Number of articulations: 97
 * Number of samples: 6
 * Size of sample pool: 3861
 *----------------------------------------------------------------------------
*/
/* end ..\..\EASLib\WTLibrary\eastestv37.c */
