/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "SubversionSettingsInfo.h"
#include "SubversionSettingsWidget.h"
#include "SubversionSettings.h"


SubversionSettingsInfo::SubversionSettingsInfo( const QString& title,
  const QString& id, SubversionSettings* ss, int sortIndex )
: _title(title), _id(id), _sortIndex(sortIndex), _ss(ss)
{
  _aspDotNetHack = ss->getAspDotNetHack();
}

SubversionSettingsInfo::~SubversionSettingsInfo()
{
}

const QString& SubversionSettingsInfo::getTitle()
{
  return _title;
}

const QString& SubversionSettingsInfo::getSettingsId()
{
  return _id;
}

void SubversionSettingsInfo::initWidgetData( SettingsWidget* sw )
{
  SubversionSettingsWidget* ssw = dynamic_cast<SubversionSettingsWidget*>(sw);

  ssw->setAspDotNetHack(_aspDotNetHack);
}

void SubversionSettingsInfo::storeWidgetData( SettingsWidget* sw )
{
  SubversionSettingsWidget* ssw = dynamic_cast<SubversionSettingsWidget*>(sw);
  _aspDotNetHack = ssw->getAspDotNetHack();
}

bool SubversionSettingsInfo::isModified()
{
  return _aspDotNetHack != _ss->getAspDotNetHack();
}

void SubversionSettingsInfo::ok()
{
  apply();
}

void SubversionSettingsInfo::apply()
{
  _ss->setAspDotNetHack(_aspDotNetHack);
}

void SubversionSettingsInfo::cancel()
{
  // nop
}

int SubversionSettingsInfo::getSortIndex()
{
  return _sortIndex;
}
