<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Component\Form\Tests\Fixtures;

use Symfony\Contracts\Translation\TranslatableInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

enum TranslatableTextAlign implements TranslatableInterface
{
    case Left;
    case Center;
    case Right;

    public function trans(TranslatorInterface $translator, string $locale = null): string
    {
        return $translator->trans($this->name, locale: $locale);
    }
}
