/*----- PROTECTED REGION ID(AccessControlStateMachine.cpp) ENABLED START -----*/
static const char *RcsId = "$Id: AccessControlStateMachine.cpp 19207 2012-02-07 17:20:25Z taurel $";
//=============================================================================
//
// file :        AccessControlStateMachine.cpp
//
// description : C++ source for the name and its alowed
//               methods for commands and attributes
//
// project :     Access Control abstract class.
//
//
// Copyright (C) :      2004,2005,2006,2007,2008,2009,2010,2011
//						European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
// This file is part of Tango.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
//
// $Author: taurel $
//
// $Revision: 19207 $
// $Date: 2012-02-07 18:20:25 +0100 (Tue, 07 Feb 2012) $
//
// SVN only:
// $HeadURL:  $
//
// CVS only:
// $Source$
// $Log$
// Revision 1.4  2011/02/11 14:20:27  pascal_verdier
// GetAccessForMutiIP  command added.
//
// Revision 1.3  2011/02/11 13:43:12  pascal_verdier
// Pogo-7 compatibility.
//
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================



#include <AccessControl.h>
#include <AccessControlClass.h>

/*----- PROTECTED REGION END -----*/


/*
 * AccessControl states description:
 *
 * ON :	The MySql database handle is OK. 
 * FAULT :	The MySql database handle is not OK. 
 */

namespace AccessControl_ns
{

//=================================================
//		Attributes Allowed Methods
//=================================================


	/*----- PROTECTED REGION ID(AccessControl::are_dynamic_attributes_allowed) ENABLED START -----*/

	//	Add your code to check if dynamic attributes are alowed

	/*----- PROTECTED REGION END -----*/	//	AccessControl::are_dynamic_attributes_allowed


//=================================================
//		Commands Allowed Methods
//=================================================


//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_AddAddressForUserState_allowed()
 *	Description : Execution allowed for AddAddressForUser command.
 */
//--------------------------------------------------------

bool AccessControl::is_AddAddressForUser_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (	//	Compare device state with not allowed states for command 
		get_state() == Tango::FAULT)
	{

	/*----- PROTECTED REGION ID(AccessControl::AddAddressForUserStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::AddAddressForUserStateAllowed

		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_AddDeviceForUserState_allowed()
 *	Description : Execution allowed for AddDeviceForUser command.
 */
//--------------------------------------------------------

bool AccessControl::is_AddDeviceForUser_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (	//	Compare device state with not allowed states for command 
		get_state() == Tango::FAULT)
	{

	/*----- PROTECTED REGION ID(AccessControl::AddDeviceForUserStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::AddDeviceForUserStateAllowed

		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_CloneUserState_allowed()
 *	Description : Execution allowed for CloneUser command.
 */
//--------------------------------------------------------

bool AccessControl::is_CloneUser_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (	//	Compare device state with not allowed states for command 
		get_state() == Tango::FAULT)
	{

	/*----- PROTECTED REGION ID(AccessControl::CloneUserStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::CloneUserStateAllowed

		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_GetAccessState_allowed()
 *	Description : Execution allowed for GetAccess command.
 */
//--------------------------------------------------------

bool AccessControl::is_GetAccess_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for GetAccess command.

	/*----- PROTECTED REGION ID(AccessControl::GetAccessStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::GetAccessStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_GetAccessForMultiIPState_allowed()
 *	Description : Execution allowed for GetAccessForMultiIP command.
 */
//--------------------------------------------------------

bool AccessControl::is_GetAccessForMultiIP_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for GetAccessForMultiIP command.

	/*----- PROTECTED REGION ID(AccessControl::GetAccessForMultiIPStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::GetAccessForMultiIPStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_GetAddressByUserState_allowed()
 *	Description : Execution allowed for GetAddressByUser command.
 */
//--------------------------------------------------------

bool AccessControl::is_GetAddressByUser_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (	//	Compare device state with not allowed states for command 
		get_state() == Tango::FAULT)
	{

	/*----- PROTECTED REGION ID(AccessControl::GetAddressByUserStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::GetAddressByUserStateAllowed

		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_GetAllowedCommandsState_allowed()
 *	Description : Execution allowed for GetAllowedCommands command.
 */
//--------------------------------------------------------

bool AccessControl::is_GetAllowedCommands_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (	//	Compare device state with not allowed states for command 
		get_state() == Tango::FAULT)
	{

	/*----- PROTECTED REGION ID(AccessControl::GetAllowedCommandsStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::GetAllowedCommandsStateAllowed

		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_GetDeviceByUserState_allowed()
 *	Description : Execution allowed for GetDeviceByUser command.
 */
//--------------------------------------------------------

bool AccessControl::is_GetDeviceByUser_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (	//	Compare device state with not allowed states for command 
		get_state() == Tango::FAULT)
	{

	/*----- PROTECTED REGION ID(AccessControl::GetDeviceByUserStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::GetDeviceByUserStateAllowed

		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_GetDeviceClassState_allowed()
 *	Description : Execution allowed for GetDeviceClass command.
 */
//--------------------------------------------------------

bool AccessControl::is_GetDeviceClass_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (	//	Compare device state with not allowed states for command 
		get_state() == Tango::FAULT)
	{

	/*----- PROTECTED REGION ID(AccessControl::GetDeviceClassStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::GetDeviceClassStateAllowed

		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_GetUsersState_allowed()
 *	Description : Execution allowed for GetUsers command.
 */
//--------------------------------------------------------

bool AccessControl::is_GetUsers_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (	//	Compare device state with not allowed states for command 
		get_state() == Tango::FAULT)
	{

	/*----- PROTECTED REGION ID(AccessControl::GetUsersStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::GetUsersStateAllowed

		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_RegisterServiceState_allowed()
 *	Description : Execution allowed for RegisterService command.
 */
//--------------------------------------------------------

bool AccessControl::is_RegisterService_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for RegisterService command.

	/*----- PROTECTED REGION ID(AccessControl::RegisterServiceStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::RegisterServiceStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_RemoveAddressForUserState_allowed()
 *	Description : Execution allowed for RemoveAddressForUser command.
 */
//--------------------------------------------------------

bool AccessControl::is_RemoveAddressForUser_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (	//	Compare device state with not allowed states for command 
		get_state() == Tango::FAULT)
	{

	/*----- PROTECTED REGION ID(AccessControl::RemoveAddressForUserStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::RemoveAddressForUserStateAllowed

		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_RemoveDeviceForUserState_allowed()
 *	Description : Execution allowed for RemoveDeviceForUser command.
 */
//--------------------------------------------------------

bool AccessControl::is_RemoveDeviceForUser_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (	//	Compare device state with not allowed states for command 
		get_state() == Tango::FAULT)
	{

	/*----- PROTECTED REGION ID(AccessControl::RemoveDeviceForUserStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::RemoveDeviceForUserStateAllowed

		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_RemoveUserState_allowed()
 *	Description : Execution allowed for RemoveUser command.
 */
//--------------------------------------------------------

bool AccessControl::is_RemoveUser_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (	//	Compare device state with not allowed states for command 
		get_state() == Tango::FAULT)
	{

	/*----- PROTECTED REGION ID(AccessControl::RemoveUserStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::RemoveUserStateAllowed

		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_UnregisterServiceState_allowed()
 *	Description : Execution allowed for UnregisterService command.
 */
//--------------------------------------------------------

bool AccessControl::is_UnregisterService_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for UnregisterService command.

	/*----- PROTECTED REGION ID(AccessControl::UnregisterServiceStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::UnregisterServiceStateAllowed

	return true;
}


	/*----- PROTECTED REGION ID(AccessControl::are_dynamic_commands_allowed) ENABLED START -----*/

	//	Add your code to check if dynamic commands are alowed

	/*----- PROTECTED REGION END -----*/	//	AccessControl::are_dynamic_commands_allowed

}	// namespace AccessControl_ns
