const char box_net_lua[] =
"-- box_net.lua (internal file)\n"
"\n"
"box.net = {\n"
"--\n"
"-- The idea of box.net.box implementation is that\n"
"-- most calls are simply wrappers around 'process'\n"
"-- function. The embedded 'process' function sends\n"
"-- requests to the local server, the remote 'process'\n"
"-- routes requests to a remote.\n"
"--\n"
"    box = {\n"
"        delete = function(self, space, ...)\n"
"            local key_part_count = select('#', ...)\n"
"            return self:process(21,\n"
"                    box.pack('iiV',\n"
"                        space,\n"
"                        box.flags.BOX_RETURN_TUPLE,  -- flags\n"
"                        key_part_count, ...))\n"
"        end,\n"
"\n"
"        replace = function(self, space, ...)\n"
"            local field_count = select('#', ...)\n"
"            return self:process(13,\n"
"                    box.pack('iiV',\n"
"                        space,\n"
"                        box.flags.BOX_RETURN_TUPLE,  -- flags\n"
"                        field_count, ...))\n"
"        end,\n"
"\n"
"        -- insert a tuple (produces an error if the tuple already exists)\n"
"        insert = function(self, space, ...)\n"
"            local field_count = select('#', ...)\n"
"            return self:process(13,\n"
"                   box.pack('iiV',\n"
"                        space,\n"
"                        bit.bor(box.flags.BOX_RETURN_TUPLE,\n"
"                                box.flags.BOX_ADD),  -- flags\n"
"                        field_count, ...))\n"
"        end,\n"
"\n"
"        -- update a tuple\n"
"        update = function(self, space, key, format, ...)\n"
"            local op_count = select('#', ...)/2\n"
"            return self:process(19,\n"
"                   box.pack('iiVi'..format,\n"
"                        space,\n"
"                        box.flags.BOX_RETURN_TUPLE,\n"
"                        1, key,\n"
"                        op_count,\n"
"                        ...))\n"
"        end,\n"
"\n"
"        select_limit = function(self, space, index, offset, limit, ...)\n"
"            local key_part_count = select('#', ...)\n"
"            return self:process(17,\n"
"                   box.pack('iiiiiV',\n"
"                         space,\n"
"                         index,\n"
"                         offset,\n"
"                         limit,\n"
"                         1, -- key count\n"
"                         key_part_count, ...))\n"
"        end,\n"
"\n"
"        select = function(self, space, index, ...)\n"
"            local key_part_count = select('#', ...)\n"
"            return self:process(17,\n"
"                    box.pack('iiiiiV',\n"
"                         space,\n"
"                         index,\n"
"                         0, -- offset\n"
"                         4294967295, -- limit\n"
"                         1, -- key count\n"
"                         key_part_count, ...))\n"
"        end,\n"
"\n"
"\n"
"        ping = function(self)\n"
"            return self:process(65280, '')\n"
"        end,\n"
"\n"
"        call    = function(self, proc_name, ...)\n"
"            local count = select('#', ...)\n"
"            return self:process(22,\n"
"                box.pack('iwaV',\n"
"                    0,                      -- flags\n"
"                    string.len(proc_name),\n"
"                    proc_name,\n"
"                    count,\n"
"                    ...))\n"
"        end,\n"
"\n"
"        select_range = function(self, sno, ino, limit, ...)\n"
"            return self:call(\n"
"                'box.select_range',\n"
"                tostring(sno),\n"
"                tostring(ino),\n"
"                tostring(limit),\n"
"                ...\n"
"            )\n"
"        end,\n"
"\n"
"        select_reverse_range = function(self, sno, ino, limit, ...)\n"
"            return self:call(\n"
"                'box.select_reverse_range',\n"
"                tostring(sno),\n"
"                tostring(ino),\n"
"                tostring(limit),\n"
"                ...\n"
"            )\n"
"        end,\n"
"\n"
"        -- To make use of timeouts safe across multiple\n"
"        -- concurrent fibers do not store timeouts as\n"
"        -- part of conection state, but put it inside\n"
"        -- a helper object.\n"
"\n"
"        timeout = function(self, timeout)\n"
"\n"
"            local wrapper = {}\n"
"\n"
"            setmetatable(wrapper, {\n"
"                __index = function(wrp, name, ...)\n"
"                    local func = self[name]\n"
"                    if func ~= nil then\n"
"                        return\n"
"                            function(wr, ...)\n"
"                                self.request_timeout = timeout\n"
"                                return func(self, ...)\n"
"                            end\n"
"                    end\n"
"\n"
"                    error(string.format('Can not find \"box.net.box.%s\" function',\n"
"                            name))\n"
"                end\n"
"            });\n"
"\n"
"            return wrapper\n"
"        end,\n"
"    },\n"
"\n"
"\n"
"    -- local tarantool\n"
"    self = {\n"
"        process = function(self, ...)\n"
"            return box.process(...)\n"
"        end,\n"
"\n"
"        select_range = function(self, sno, ino, limit, ...)\n"
"            return box.space[tonumber(sno)].index[tonumber(ino)]\n"
"                :select_range(tonumber(limit), ...)\n"
"        end,\n"
"\n"
"        select_reverse_range = function(self, sno, ino, limit, ...)\n"
"            return box.space[tonumber(sno)].index[tonumber(ino)]\n"
"                :select_reverse_range(tonumber(limit), ...)\n"
"        end,\n"
"\n"
"        -- for compatibility with the networked version,\n"
"        -- implement call\n"
"        call = function(self, proc_name, ...)\n"
"            local proc = box.call_loadproc(proc_name)\n"
"            return proc(...)\n"
"        end,\n"
"\n"
"        ping = function(self)\n"
"            return true\n"
"        end,\n"
"\n"
"        -- local tarantool doesn't provide timeouts\n"
"        timeout = function(self, timeout)\n"
"            return self\n"
"        end,\n"
"\n"
"        close = function(self)\n"
"            return true\n"
"        end\n"
"    }\n"
"}\n"
"\n"
"--\n"
"-- Make sure box.net.box.select(conn, ...) works\n"
"-- just as well as conn:select(...)\n"
"--\n"
"setmetatable(box.net.self, { __index = box.net.box })\n"
"\n"
"box.net.box.new = function(host, port, reconnect_timeout)\n"
"    if reconnect_timeout == nil then\n"
"        reconnect_timeout = 0\n"
"    else\n"
"        reconnect_timeout = tonumber(reconnect_timeout)\n"
"    end\n"
"\n"
"    local remote = {\n"
"        host                = host,\n"
"        port                = port,\n"
"        reconnect_timeout   = reconnect_timeout,\n"
"        closed              = false,\n"
"\n"
"        processing = {\n"
"            last_sync = 0,\n"
"            next_sync = function(self)\n"
"                while true do\n"
"                    self.last_sync = self.last_sync + 1\n"
"                    if self[ self.last_sync ] == nil then\n"
"                        return self.last_sync\n"
"                    end\n"
"\n"
"                    if self.last_sync > 0x7FFFFFFF then\n"
"                        self.last_sync = 0\n"
"                    end\n"
"                end\n"
"            end,\n"
"\n"
"            -- write channel\n"
"            wch = box.ipc.channel(1),\n"
"\n"
"            -- ready socket channel\n"
"            rch = box.ipc.channel(1),\n"
"        },\n"
"\n"
"\n"
"\n"
"        process = function(self, op, request)\n"
"            local started = box.time()\n"
"            local timeout = self.request_timeout\n"
"            self.request_timeout = nil\n"
"\n"
"            -- get an auto-incremented request id\n"
"            local sync = self.processing:next_sync()\n"
"            self.processing[sync] = box.ipc.channel(1)\n"
"            request = box.pack('iiia', op, string.len(request), sync, request)\n"
"\n"
"\n"
"            if timeout ~= nil then\n"
"                timeout = tonumber(timeout)\n"
"                if not self.processing.wch:put(request, timeout) then\n"
"                    self.processing[sync] = nil\n"
"                    return nil\n"
"                end\n"
"\n"
"                timeout = timeout - (box.time() - started)\n"
"            else\n"
"                self.processing.wch:put(request)\n"
"            end\n"
"\n"
"            local res\n"
"            if timeout ~= nil then\n"
"                res = self.processing[sync]:get(timeout)\n"
"            else\n"
"                res = self.processing[sync]:get()\n"
"            end\n"
"            self.processing[sync] = nil\n"
"\n"
"\n"
"            -- timeout\n"
"            if res == nil then\n"
"                if op == 65280 then\n"
"                    return false\n"
"                else\n"
"                    return nil\n"
"                end\n"
"            end\n"
"\n"
"            -- results { status, response } received\n"
"            if res[1] then\n"
"                if op == 65280 then\n"
"                    return true\n"
"                else\n"
"                    local rop, blen, sync, code, body =\n"
"                        box.unpack('iiiia', res[2])\n"
"                    if code ~= 0 then\n"
"                        box.raise(code, body)\n"
"                    end\n"
"\n"
"            -- boc.unpack('R') unpacks response body for us (tuple)\n"
"                    return box.unpack('R', body)\n"
"                end\n"
"            else\n"
"                error(res[2])\n"
"            end\n"
"        end,\n"
"\n"
"\n"
"        try_connect = function(self)\n"
"            if self.s ~= nil then\n"
"                return true\n"
"            end\n"
"\n"
"            local sc = box.socket.tcp()\n"
"            if sc == nil then\n"
"                self:fatal(\"Can't create socket\")\n"
"                return false\n"
"            end\n"
"\n"
"            local s = { sc:connect( self.host, self.port ) }\n"
"            if s[1] == nil then\n"
"                self:fatal(\"Can't connect to %s:%s: %s\",\n"
"                    self.host, self.port, s[4])\n"
"                return false\n"
"            end\n"
"\n"
"            self.s = sc\n"
"\n"
"            return true\n"
"        end,\n"
"\n"
"        read_response = function(self)\n"
"            if self.s == nil then\n"
"                return\n"
"            end\n"
"            local res = { self.s:recv(12) }\n"
"            if res[4] ~= nil then\n"
"                self:fatal(\"Can't read socket: %s\", res[3])\n"
"                return\n"
"            end\n"
"            local header = res[1]\n"
"            if string.len(header) ~= 12 then\n"
"                self:fatal(\"Unexpected eof while reading header\")\n"
"                return\n"
"            end\n"
"\n"
"            local op, blen, sync = box.unpack('iii', header)\n"
"\n"
"            local body = ''\n"
"            if blen > 0 then\n"
"                res = { self.s:recv(blen) }\n"
"                if res[4] ~= nil then\n"
"                    self:fatal(\"Error while reading socket: %s\", res[4])\n"
"                    return\n"
"                end\n"
"                body = res[1]\n"
"                if string.len(body) ~= blen then\n"
"                    self:fatal(\"Unexpected eof while reading body\")\n"
"                    return\n"
"                end\n"
"            end\n"
"            return sync, header .. body\n"
"        end,\n"
"\n"
"        rfiber = function(self)\n"
"            while not self.closed do\n"
"                while not self.closed do\n"
"                    if self:try_connect(self.host, self.port) then\n"
"                        break\n"
"                    end\n"
"                    -- timeout between reconnect attempts\n"
"                    box.fiber.sleep(self.reconnect_timeout)\n"
"                end\n"
"\n"
"                -- wakeup write fiber\n"
"                self.processing.rch:put(true, 0)\n"
"\n"
"                while not self.closed do\n"
"                    local sync, resp = self:read_response()\n"
"                    if sync == nil then\n"
"                        break\n"
"                    end\n"
"\n"
"                    if self.processing[sync] ~= nil then\n"
"                        self.processing[sync]:put({true, resp}, 0)\n"
"                    else\n"
"                        print(\"Unexpected response \", sync)\n"
"                    end\n"
"                end\n"
"\n"
"            end\n"
"            self.irfiber = nil\n"
"        end,\n"
"\n"
"\n"
"        wfiber = function(self)\n"
"            local request\n"
"            while not self.closed do\n"
"                while self.s == nil do\n"
"                    self.processing.rch:get(1)\n"
"                end\n"
"                if request == nil then\n"
"                    request = self.processing.wch:get(1)\n"
"                end\n"
"                if self.s ~= nil and request ~= nil then\n"
"                    local res = { self.s:send(request) }\n"
"                    if res[1] ~= string.len(request) then\n"
"                        self:fatal(\"Error while write socket: %s\", res[4])\n"
"                    end\n"
"                    request = nil\n"
"                end\n"
"            end\n"
"            self.iwfiber = nil\n"
"        end,\n"
"\n"
"        fatal = function(self, message, ...)\n"
"            message = string.format(message, ...)\n"
"            self.s = nil\n"
"            for sync, ch in pairs(self.processing) do\n"
"                if type(sync) == 'number' then\n"
"                    ch:put({ false, message }, 0)\n"
"                end\n"
"            end\n"
"        end,\n"
"\n"
"        close = function(self)\n"
"            if self.closed then\n"
"                error(\"box.net.box: already closed\")\n"
"            end\n"
"            self.closed = true\n"
"            local message = 'box.net.box: connection was closed'\n"
"            self.process = function()\n"
"                error(message)\n"
"            end\n"
"            self:fatal(message)\n"
"\n"
"            -- wake up write fiber\n"
"            self.processing.rch:put(true, 0)\n"
"            self.processing.wch:put(true, 0)\n"
"            return true\n"
"        end\n"
"    }\n"
"\n"
"\n"
"    setmetatable( remote, { __index = box.net.box } )\n"
"\n"
"    remote.irfiber = box.fiber.wrap(remote.rfiber, remote)\n"
"    remote.iwfiber = box.fiber.wrap(remote.wfiber, remote)\n"
"\n"
"    return remote\n"
"end\n"
"\n"
"-- vim: set et ts=4 sts\n"
""
;
