from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


localhost = _Mock()

logging = _Mock()

os = _Mock()

select_random_ports = _Mock()

zmq = _Mock()



class Configurable(_Mock):
  pass


class IOLoop(_Mock):
  pass
  ERROR = 24
  NONE = 0
  READ = 1
  WRITE = 4
  _EPOLLERR = 8
  _EPOLLET = 2147483648
  _EPOLLHUP = 16
  _EPOLLIN = 1
  _EPOLLONESHOT = 1073741824
  _EPOLLOUT = 4
  _EPOLLPRI = 2
  _EPOLLRDHUP = 8192

class Instance(_Mock):
  pass
  info_text = 'any value'

class Integer(_Mock):
  pass
  default_value = 0
  info_text = 'an integer'

class RegistrationFactory(_Mock):
  pass


class Session(_Mock):
  pass


class SessionFactory(_Mock):
  pass


class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

