'\"
'\" Generated from file 'pt_peg_op\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2009 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\"
.TH "pt_peg_op" i 1\&.1\&.0 tcllib "Parser Tools"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
pt_peg_op \- Parser Tools PE Grammar Utility Operations
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBpt::peg::op  ?1\&.1\&.0?\fR
.sp
\fB::peg::peg::op\fR \fBcalled\fR \fIcontainer\fR
.sp
\fB::peg::peg::op\fR \fBdechain\fR \fIcontainer\fR
.sp
\fB::peg::peg::op\fR \fBdrop unreachable\fR \fIcontainer\fR
.sp
\fB::peg::peg::op\fR \fBdrop unrealizable\fR \fIcontainer\fR
.sp
\fB::peg::peg::op\fR \fBflatten\fR \fIcontainer\fR
.sp
\fB::peg::peg::op\fR \fBminimize\fR \fIcontainer\fR
.sp
\fB::peg::peg::op\fR \fBmodeopt\fR \fIcontainer\fR
.sp
\fB::peg::peg::op\fR \fBreachable\fR \fIcontainer\fR
.sp
\fB::peg::peg::op\fR \fBrealizable\fR \fIcontainer\fR
.sp
.BE
.SH DESCRIPTION
.PP
Are you lost ?
Do you have trouble understanding this document ?
In that case please read the overview provided by the
\fIIntroduction to Parser Tools\fR\&. This document is the
entrypoint to the whole system the current package is a part of\&.
.PP
This package provides a number of utility commands manipulating a PE
grammar (container) in various ways\&.
.SH API
.TP
\fB::peg::peg::op\fR \fBcalled\fR \fIcontainer\fR
This command determines the static call structure for the nonterminal
symbols of the grammar stored in the \fIcontainer\fR\&.
.sp
The result of the command is a dictionary mapping from each
symbol to the symbols it calls\&. The empty string is the key used to
represent the start expression of the grammar\&.
.sp
The grammar in the container is not modified\&.
.sp
The \fIcontainer\fR instance has to expose a method API as is
provided by the package \fBpt::peg::container\fR\&.
.TP
\fB::peg::peg::op\fR \fBdechain\fR \fIcontainer\fR
This command simplifies all symbols which just chain to a different
symbol by inlining the right hand side of the called symbol in its
callers\&. This works if and only the modes match properly, per the
decision table below\&.
.sp
.CS


caller called | dechain | notes
--------------+---------+-----------------------
value  value  |  yes    |  value is passed
value  leaf   |  yes    |  value is passed
value  void   |  yes    |  caller is implied void
leaf   value  |  no     |  generated value was discarded, inlined would not\&. called may be implied void\&.
leaf   leaf   |  no     |  s\&.a\&.
leaf   void   |  no     |  s\&.a\&.
void   value  |  no     |  caller drops value, inlined would not\&.
void   leaf   |  no     |  s\&.a\&.
void   void   |  yes    |

.CE
.sp
The result of the command is the empty string\&.
.sp
The grammar in the container is directly modified\&. If that is
not wanted, a copy of the original container has to be used\&.
.sp
The \fIcontainer\fR instance has to expose a method API as is
provided by the package \fBpt::peg::container\fR\&.
.TP
\fB::peg::peg::op\fR \fBdrop unreachable\fR \fIcontainer\fR
This command removes all symbols from the grammar which are not
\fBreachable\fR\&.
.sp
The result of the command is the empty string\&.
.sp
The grammar in the container is directly modified\&. If that is
not wanted, a copy of the original container has to be used\&.
.sp
The \fIcontainer\fR instance has to expose a method API as is
provided by the package \fBpt::peg::container\fR\&.
.TP
\fB::peg::peg::op\fR \fBdrop unrealizable\fR \fIcontainer\fR
This command removes all symbols from the grammar which are not
\fBrealizable\fR\&.
.sp
The result of the command is the empty string\&.
.sp
The grammar in the container is directly modified\&. If that is
not wanted, a copy of the original container has to be used\&.
.sp
The \fIcontainer\fR instance has to expose a method API as is
provided by the package \fBpt::peg::container\fR\&.
.TP
\fB::peg::peg::op\fR \fBflatten\fR \fIcontainer\fR
This command flattens (see \fBpt::pe::op\fR) all expressions in
the grammar, i\&.e\&. the start expression and the right hand sides of all
nonterminal symbols\&.
.sp
The result of the command is the empty string\&.
.sp
The grammar in the container is directly modified\&. If that is
not wanted, a copy of the original container has to be used\&.
.sp
The \fIcontainer\fR instance has to expose a method API as is
provided by the package \fBpt::peg::container\fR\&.
.TP
\fB::peg::peg::op\fR \fBminimize\fR \fIcontainer\fR
This command reduces the provided grammar by applying most of the other methods of this package\&.
.sp
After flattening the expressions it removes unreachable and
unrealizable symbols, flattens the expressions again, then optimizes
the symbol modes before collapsing symbol chains as much as possible\&.
.sp
The result of the command is the empty string\&.
.sp
The grammar in the container is directly modified\&. If that is
not wanted, a copy of the original container has to be used\&.
.sp
The \fIcontainer\fR instance has to expose a method API as is
provided by the package \fBpt::peg::container\fR\&.
.TP
\fB::peg::peg::op\fR \fBmodeopt\fR \fIcontainer\fR
This command optimizes the semantic modes of non-terminal symbols
according to the two rules below\&.
.RS
.IP [1]
If a symbol X with mode \fBvalue\fR calls no other symbols,
i\&.e\&. uses only terminal symbols in whatever combination, then
this can be represented simpler by using mode \fBleaf\fR\&.
.IP [2]
If a symbol X is only called from symbols with modes
\fBleaf\fR or \fBvoid\fR then this symbol should have mode
\fBvoid\fR also, as any AST it could generate will be
discarded anyway\&.
.RE
.sp
The result of the command is the empty string\&.
.sp
The grammar in the container is directly modified\&. If that is
not wanted, a copy of the original container has to be used\&.
.sp
The \fIcontainer\fR instance has to expose a method API as is
provided by the package \fBpt::peg::container\fR\&.
.TP
\fB::peg::peg::op\fR \fBreachable\fR \fIcontainer\fR
This command computes the set of all nonterminal symbols which are
reachable from the start expression of the grammar\&. This is
essentially the transitive closure over \fBcalled\fR and the
symbol's right hand sides, beginning with the start expression\&.
.sp
The result of the command is the list of reachable symbols\&.
.sp
The grammar in the container is not modified\&.
.sp
The \fIcontainer\fR instance has to expose a method API as is
provided by the package \fBpt::peg::container\fR\&.
.TP
\fB::peg::peg::op\fR \fBrealizable\fR \fIcontainer\fR
This command computes the set of all nonterminal symbols which are
realizable, i\&.e\&. can derive pure terminal phrases\&. This is done
iteratively, starting with state unrealizable for all and any, and
then updating all symbols which are realizable, propagating changes,
until nothing changes any more\&.
.sp
The result of the command is the list of realizable symbols\&.
.sp
The grammar in the container is not modified\&.
.sp
The \fIcontainer\fR instance has to expose a method API as is
provided by the package \fBpt::peg::container\fR\&.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIpt\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
EBNF, LL(k), PEG, TDPL, context-free languages, expression, grammar, matching, parser, parsing expression, parsing expression grammar, push down automaton, recursive descent, state, top-down parsing languages, transducer
.SH CATEGORY
Parsing and Grammars
.SH COPYRIGHT
.nf
Copyright (c) 2009 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>

.fi
