package contracts

// NOTE: This file was automatically generated.

// Instances of AvailabilityData represent the result of executing an
// availability test.
type AvailabilityData struct {
	Domain

	// Schema version
	Ver int `json:"ver"`

	// Identifier of a test run. Use it to correlate steps of test run and
	// telemetry generated by the service.
	Id string `json:"id"`

	// Name of the test that these availability results represent.
	Name string `json:"name"`

	// Duration in format: DD.HH:MM:SS.MMMMMM. Must be less than 1000 days.
	Duration string `json:"duration"`

	// Success flag.
	Success bool `json:"success"`

	// Name of the location where the test was run from.
	RunLocation string `json:"runLocation"`

	// Diagnostic message for the result.
	Message string `json:"message"`

	// Collection of custom properties.
	Properties map[string]string `json:"properties,omitempty"`

	// Collection of custom measurements.
	Measurements map[string]float64 `json:"measurements,omitempty"`
}

// Returns the name used when this is embedded within an Envelope container.
func (data *AvailabilityData) EnvelopeName(key string) string {
	if key != "" {
		return "Microsoft.ApplicationInsights." + key + ".Availability"
	} else {
		return "Microsoft.ApplicationInsights.Availability"
	}
}

// Returns the base type when placed within a Data object container.
func (data *AvailabilityData) BaseType() string {
	return "AvailabilityData"
}

// Truncates string fields that exceed their maximum supported sizes for this
// object and all objects it references.  Returns a warning for each affected
// field.
func (data *AvailabilityData) Sanitize() []string {
	var warnings []string

	if len(data.Id) > 64 {
		data.Id = data.Id[:64]
		warnings = append(warnings, "AvailabilityData.Id exceeded maximum length of 64")
	}

	if len(data.Name) > 1024 {
		data.Name = data.Name[:1024]
		warnings = append(warnings, "AvailabilityData.Name exceeded maximum length of 1024")
	}

	if len(data.RunLocation) > 1024 {
		data.RunLocation = data.RunLocation[:1024]
		warnings = append(warnings, "AvailabilityData.RunLocation exceeded maximum length of 1024")
	}

	if len(data.Message) > 8192 {
		data.Message = data.Message[:8192]
		warnings = append(warnings, "AvailabilityData.Message exceeded maximum length of 8192")
	}

	if data.Properties != nil {
		for k, v := range data.Properties {
			if len(v) > 8192 {
				data.Properties[k] = v[:8192]
				warnings = append(warnings, "AvailabilityData.Properties has value with length exceeding max of 8192: "+k)
			}
			if len(k) > 150 {
				data.Properties[k[:150]] = data.Properties[k]
				delete(data.Properties, k)
				warnings = append(warnings, "AvailabilityData.Properties has key with length exceeding max of 150: "+k)
			}
		}
	}

	if data.Measurements != nil {
		for k, v := range data.Measurements {
			if len(k) > 150 {
				data.Measurements[k[:150]] = v
				delete(data.Measurements, k)
				warnings = append(warnings, "AvailabilityData.Measurements has key with length exceeding max of 150: "+k)
			}
		}
	}

	return warnings
}

// Creates a new AvailabilityData instance with default values set by the schema.
func NewAvailabilityData() *AvailabilityData {
	return &AvailabilityData{
		Ver: 2,
	}
}
