/* Copyright 2023 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/
#ifndef TENSORFLOW_LITE_KERNELS_VARIANTS_REGISTER_LIST_OPS_H_
#define TENSORFLOW_LITE_KERNELS_VARIANTS_REGISTER_LIST_OPS_H_

#include "tensorflow/lite/mutable_op_resolver.h"

namespace tflite {
namespace variants {
namespace ops {

// Register all tflite TensorList kernels as custom ops with the given resolver.
void RegisterListOps(MutableOpResolver* resolver);

}  // namespace ops
}  // namespace variants
}  // namespace tflite

#endif  // TENSORFLOW_LITE_KERNELS_VARIANTS_REGISTER_LIST_OPS_H_
