## TFSA-2020-001: Segmentation fault when converting a Python string to `tf.float16`

### CVE Number

CVE-2020-5215

### Issue Description

Converting a string (from Python) to a `tf.float16` value results in a
segmentation fault in eager mode as the format checks for this use case are only
in the graph mode.

### Impact

This issue can lead to denial of service in inference/training where a malicious
attacker can send a data point which contains a string instead of a `tf.float16`
value.

Similar effects can be obtained by manipulating saved models and checkpoints
whereby replacing a scalar `tf.float16` value with a scalar string will trigger
this issue due to automatic conversions.

This can be easily reproduced by `tf.constant("hello", tf.float16)`, if eager
execution is enabled.

### Vulnerable Versions

TensorFlow 1.12.0, 1.12.1, 1.12.2, 1.12.3, 1.13.0, 1.13.1, 1.13.2, 1.14.0,
1.15.0, 2.0.0.

### Mitigation

We have patched the vulnerability in GitHub commit
[5ac1b9](https://github.com/tensorflow/tensorflow/commit/5ac1b9e24ff6afc465756edf845d2e9660bd34bf).

We are additionally releasing TensorFlow 1.15.2 and 2.0.1 with this
vulnerability patched.

TensorFlow 2.1.0 was released after we fixed the issue, thus it is not affected.

We encourage users to switch to TensorFlow 1.15.2, 2.0.1 or 2.1.0.
