/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.pswing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import org.piccolo2d.PCamera;
import org.piccolo2d.PLayer;
import org.piccolo2d.PNode;
import org.piccolo2d.extras.pswing.PSwingCanvas;
import org.piccolo2d.extras.pswing.PSwingRepaintManager;
import org.piccolo2d.util.PBounds;
import org.piccolo2d.util.PPaintContext;

public class PSwing
extends PNode
implements Serializable,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    public static final String PSWING_PROPERTY = "PSwing";
    private static final PBounds TEMP_REPAINT_BOUNDS2 = new PBounds();
    private static final Color BUFFER_BACKGROUND_COLOR = new Color(0, 0, 0, 0);
    private static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();
    private static final double DEFAULT_GREEK_THRESHOLD = 0.3;
    private double greekThreshold = 0.3;
    private JComponent component = null;
    private boolean useBufferedPainting = false;
    private BufferedImage buffer;
    private double minFontSize = Double.MAX_VALUE;
    private Stroke defaultStroke = new BasicStroke();
    private static final Font DEFAULT_FONT = new Font("Serif", 0, 12);
    private PSwingCanvas canvas;
    private final ArrayList listeningTo = new ArrayList();
    private final PropertyChangeListener parentListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            PNode parent = (PNode)evt.getNewValue();
            this.clearListeners((PNode)evt.getOldValue());
            if (parent == null) {
                PSwing.this.updateCanvas(null);
            } else {
                PSwing.this.listenForCanvas(parent);
            }
        }

        private void clearListeners(PNode fromParent) {
            if (fromParent != null && PSwing.this.isListeningTo(fromParent)) {
                fromParent.removePropertyChangeListener("parent", PSwing.this.parentListener);
                PSwing.this.listeningTo.remove(fromParent);
                this.clearListeners(fromParent.getParent());
            }
        }
    };
    private final ContainerListener doubleBufferRemover = new ContainerAdapter(){

        public void componentAdded(ContainerEvent event) {
            Component childComponent = event.getChild();
            if (childComponent != null && childComponent instanceof JComponent) {
                this.disableDoubleBuffering((JComponent)childComponent);
            }
        }

        private void disableDoubleBuffering(JComponent targetComponent) {
            targetComponent.setDoubleBuffered(false);
            for (int i = 0; i < targetComponent.getComponentCount(); ++i) {
                Component c = targetComponent.getComponent(i);
                if (!(c instanceof JComponent)) continue;
                this.disableDoubleBuffering((JComponent)c);
            }
        }
    };

    public PSwing(JComponent component) {
        this.component = component;
        component.putClientProperty(PSWING_PROPERTY, this);
        this.initializeComponent(component);
        component.revalidate();
        this.updateBounds();
        this.listenForCanvas(this);
    }

    public PSwing(PSwingCanvas swingCanvas, JComponent component) {
        this(component);
    }

    public void setUseBufferedPainting(boolean useBufferedPainting) {
        this.useBufferedPainting = useBufferedPainting;
    }

    public boolean isUseBufferedPainting() {
        return this.useBufferedPainting;
    }

    public void updateBounds() {
        if (this.componentNeedsResizing()) {
            this.updateComponentSize();
        }
        this.setBounds(0.0, 0.0, this.component.getPreferredSize().width, this.component.getPreferredSize().height);
    }

    private void updateComponentSize() {
        this.component.setBounds(0, 0, this.component.getPreferredSize().width, this.component.getPreferredSize().height);
    }

    private boolean componentNeedsResizing() {
        return this.component.getWidth() != this.component.getPreferredSize().width || this.component.getHeight() != this.component.getPreferredSize().height;
    }

    public void paint(PPaintContext renderContext) {
        if (this.componentNeedsResizing()) {
            this.updateComponentSize();
            this.component.validate();
        }
        Graphics2D g2 = renderContext.getGraphics();
        Stroke originalStroke = g2.getStroke();
        Font originalFont = g2.getFont();
        g2.setStroke(this.defaultStroke);
        g2.setFont(DEFAULT_FONT);
        if (this.shouldRenderGreek(renderContext)) {
            this.paintAsGreek(g2);
        } else {
            this.paint(g2);
        }
        g2.setStroke(originalStroke);
        g2.setFont(originalFont);
    }

    protected boolean shouldRenderGreek(PPaintContext paintContext) {
        return paintContext.getScale() < this.greekThreshold || this.minFontSize * paintContext.getScale() < 0.5;
    }

    public void paintAsGreek(Graphics2D g2) {
        Color originalColor = g2.getColor();
        if (this.component.getBackground() != null) {
            g2.setColor(this.component.getBackground());
        }
        g2.fill((Shape)this.getBounds());
        if (this.component.getForeground() != null) {
            g2.setColor(this.component.getForeground());
        }
        g2.draw((Shape)this.getBounds());
        g2.setColor(originalColor);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.component.isVisible() != visible) {
            this.component.setVisible(visible);
        }
    }

    public void removeFromSwingWrapper() {
        if (this.canvas != null && this.isComponentSwingWrapped()) {
            this.canvas.getSwingWrapper().remove(this.component);
        }
    }

    private boolean isComponentSwingWrapped() {
        return Arrays.asList(this.canvas.getSwingWrapper().getComponents()).contains(this.component);
    }

    public void paint(Graphics2D g2) {
        if (this.component.getBounds().isEmpty()) {
            return;
        }
        PSwingRepaintManager manager = (PSwingRepaintManager)RepaintManager.currentManager(this.component);
        manager.lockRepaint(this.component);
        RenderingHints oldHints = g2.getRenderingHints();
        if (this.useBufferedPainting) {
            Graphics2D bufferedGraphics = this.getBufferedGraphics(g2);
            this.component.paint(bufferedGraphics);
            g2.drawRenderedImage(this.buffer, IDENTITY_TRANSFORM);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            this.component.paint(g2);
        }
        g2.setRenderingHints(oldHints);
        manager.unlockRepaint(this.component);
    }

    private Graphics2D getBufferedGraphics(Graphics2D source) {
        Graphics2D bufferedGraphics;
        if (!this.isBufferValid()) {
            this.buffer = new BufferedImage(this.component.getWidth(), this.component.getHeight(), 3);
            bufferedGraphics = this.buffer.createGraphics();
        } else {
            bufferedGraphics = this.buffer.createGraphics();
            bufferedGraphics.setBackground(BUFFER_BACKGROUND_COLOR);
            bufferedGraphics.clearRect(0, 0, this.component.getWidth(), this.component.getHeight());
        }
        bufferedGraphics.setRenderingHints(source.getRenderingHints());
        return bufferedGraphics;
    }

    private boolean isBufferValid() {
        return this.buffer != null && this.buffer.getWidth() == this.component.getWidth() && this.buffer.getHeight() == this.component.getHeight();
    }

    public void repaint(PBounds repaintBounds) {
        Shape sh = this.getTransform().createTransformedShape((Shape)repaintBounds);
        TEMP_REPAINT_BOUNDS2.setRect(sh.getBounds2D());
        this.repaintFrom(TEMP_REPAINT_BOUNDS2, this);
    }

    public JComponent getComponent() {
        return this.component;
    }

    private void initializeComponent(Component c) {
        if (c.getFont() != null) {
            this.minFontSize = Math.min(this.minFontSize, (double)c.getFont().getSize());
        }
        c.addPropertyChangeListener("font", this);
        if (c instanceof Container) {
            this.initializeChildren((Container)c);
            ((Container)c).addContainerListener(this.doubleBufferRemover);
        }
        if (c instanceof JComponent) {
            ((JComponent)c).setDoubleBuffered(false);
        }
    }

    private void initializeChildren(Container c) {
        Component[] children = c.getComponents();
        if (children != null) {
            for (int j = 0; j < children.length; ++j) {
                this.initializeComponent(children[j]);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Component source = (Component)evt.getSource();
        if (source.getFont() != null && this.component.isAncestorOf(source)) {
            this.minFontSize = Math.min(this.minFontSize, (double)source.getFont().getSize());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeComponent(this.component);
    }

    private void listenForCanvas(PNode node) {
        block0: for (PNode p = node; p != null; p = p.getParent()) {
            this.listenToNode(p);
            PNode parent = p;
            if (!(parent instanceof PLayer)) continue;
            PLayer player = (PLayer)parent;
            for (int i = 0; i < player.getCameraCount(); ++i) {
                PCamera cam = player.getCamera(i);
                if (!(cam.getComponent() instanceof PSwingCanvas)) continue;
                this.updateCanvas((PSwingCanvas)cam.getComponent());
                continue block0;
            }
        }
    }

    private void listenToNode(PNode node) {
        if (!this.isListeningTo(node)) {
            this.listeningTo.add(node);
            node.addPropertyChangeListener("parent", this.parentListener);
        }
    }

    private boolean isListeningTo(PNode node) {
        for (int i = 0; i < this.listeningTo.size(); ++i) {
            PNode pNode = (PNode)this.listeningTo.get(i);
            if (pNode != node) continue;
            return true;
        }
        return false;
    }

    private void updateCanvas(PSwingCanvas newCanvas) {
        if (newCanvas == this.canvas) {
            return;
        }
        if (this.canvas != null) {
            this.canvas.removePSwing(this);
        }
        if (newCanvas == null) {
            this.canvas = null;
        } else {
            this.canvas = newCanvas;
            this.canvas.addPSwing(this);
            this.updateBounds();
            this.repaint();
            this.canvas.invalidate();
            this.canvas.revalidate();
            this.canvas.repaint();
        }
    }

    public double getGreekThreshold() {
        return this.greekThreshold;
    }

    public void setGreekThreshold(double greekThreshold) {
        this.greekThreshold = greekThreshold;
        this.invalidatePaint();
    }
}

