/* This is part of tmview, a dvi previewer. (c) 1995 Thomas Moor         */
/*                                                                       */
/* This program may be used without any warranty. It may be modified and */
/* distributed without any restrictions as far  I'm concerned ...        */

/* The code for reading vf-files is to some extent from vf.c of xdvi.    */


#include "defs.h"


/* #define DEBUGVF */


FILE* vffile;


void vfopen(char* fname) {
  if((vffile = fopen(fname, "rb"))==0) {
    pfprot("\n fatal error: vf-file \"%s\" disapeard. \n",fname);
    exit(1);
  }
}


#define vfclose()     fclose(vffile)
#define vfskip(delta) fseek(vffile,(long) delta,1)
#define vfposit(to)   fseek(vffile,to,0)
#define vftell()      ftell(vffile)


#define vfn1() (uchar) fgetc(vffile)


unsigned short vfn2(void)  {  
  short b;
  b = vfn1();  
  return (b * 256 + vfn1());
}

unsigned long vfn3(void)  {  
  long b;  
  short c;
  b = vfn1();  
  c = vfn1();
  return ((b * 256 + c) * 256 + vfn1());
}


unsigned long vfn4(void)  {  
  unsigned long b,c,d;  
  b = vfn1();  
  c = vfn1();
  d = vfn1();
  return (((b * 256 + c) * 256 +d)*256+ vfn1());
}


short vfi1(void)  {  
  short b;
  b = vfn1();  
  if (b > 127)  b -= 256;  
  return b;
}

short vfi2(void)  {  
  short b;
  b = vfn1();  
  if (b > 127)  b -= 256;
  return (b * 256 + vfn1());
}

long vfi3(void)  {  
  long b;
  b = vfi1();  return (b * 65536L + vfn2());
}

long vfi4(void)  {  
  long b;
  b = vfi2();  
  return (b * 65536L + vfn2());
}


void vfbytes(char *s, uchar  l) {
  if(l==0) return;
  s[0]=0;  
  s[l] = '\0';  
  if(fread(s,1,(long) l,vffile)==0) pfprot("vf-file ends prematurely ! ");
}

long vfnum(uchar b)  {  
  uchar i;  
  long n;
  uchar rbuf[4]={0,0,0,0};
  if(fread(rbuf, b, 1, vffile)==0) pfprot("vf-file ends prematurely ! ");
  n = 0;
  for (i = 1; i <= b; i++)  
    n = (n << 8) | (uchar) rbuf[i-1];  
  return n;
}




/* Since we are not that smart as the xdvi crew, we need to code */
/* fontdefinitions again. Bullshit. Why the hell did I start all this? */

int vfdef(char* fftuto,int fdb,long chksum, long vffontnr); /* forward */


/* this is the end, where a font is defined within some vf-font  */
/* so fontnr is the w.r.t. the vf-file (rather than the dvi-file)*/
/* and vffdb refers to the vf-fonts database entry               */
void vffontdef(long fontnr, int vffdb) { 
  uchar  p, q;
  int f,fdb;
  long dsz,scf,reldsz,relscf,chksum,vffp;
  float fontmag;   
  char ffpath[MAXPATHSTR], fftuto[MAXPATHSTR];
  char fontname[MAXPATHSTR];

  if (fontnr < 0)  {
    dvibad("vf-file: negative fontnumber");
    return;
  } 
  chksum = vfi4();
  relscf = vfi4();  
  reldsz = vfi4();
  scf= scaled(FD(vffdb)->foscf,relscf);
  dsz= ((double)reldsz / 0x10); 
  p = vfn1(); 
  q = vfn1();  
  vfbytes(fontname, q);
  if (p != 0)  vfbytes(ffpath, p); 
  fontmag = xres * (dvimag / 1000.0 * ((double)scf / dsz));
  pfprot("\n  prep. vffont: %8s at %6.1f ", fontname, fontmag);
  pfverb("(scf %d dsz %d) ",scf,dsz);

  fdb=-1;
  if(p==0) {
    if((fdb=searchfontdatabase(vfprefix,fontname,dvimag,scf,dsz))==-1)
      fdb=searchfontdatabase(fontprefix,fontname,dvimag,scf,dsz);
  } else {
    fdb=searchfontdatabase(ffpath,fontname,dvimag,scf,dsz);
  }
  if(fdb!=-1) {
    pfprot(" - fontdatabase");
    if(FD(fdb)->vffile!=NULL){ /* look for involved pks/tfms */
      vffp=vftell();                          /* save where we are */
      vfclose();
      vflookuppk(fdb);
      vfopen(FD(vffdb)->vffile);                 
      vfposit(vffp);                          /* back where we've left it */
    }
  } else {
    if (p==0) strcpy(ffpath, vfprefix);
    fdb=allocfontdesc(ffpath,fontname,dvimag,scf,dsz); /* this might reallocate fontdatabase!*/
    allocmem(&(FD(fdb)->chv),(MAXCHARS+1) * sizeof(chdesc)); 
    memset(FD(fdb)->chv,0,(MAXCHARS+1) * sizeof(chdesc));  
                                               /* unsused bitmaps=NULL */
                                               /* unused  fty  0 */
                                               /* unused macros = 0*/
                                               /* unused dimensions 0*/
    if(tfmfind(tfmprefix,fontname,fftuto))
       tfmdef(fftuto,fdb,chksum);
    /* vf's in vf's looks too dangerous ... still give it a try*/ 
    if(vffind(ffpath,fontname,fftuto)) { 
      vffp=vftell();                          /* save where we are */
      vfclose();
      vfdef(fftuto,fdb,chksum,fontnr); 
      vfopen(FD(vffdb)->vffile);                 
      vfposit(vffp);                          /* back where we've left it */
    } else {
      if(p==0) strcpy(ffpath,fontprefix);
      if(pkfind(ffpath,fontname,fontmag,fftuto)) {
        pkdef(fftuto,fdb,chksum);
  	stralloccpy(&(FD(fdb)->fopath),ffpath);
      }
    }
    reallocmem(&(FD(fdb)->chv),sizeof(chdesc)*(FD(fdb)->mch + 2));
  }
  /* assign an internal font number, ie an index in vffontvec */
  f = fontnr % VFMAXFONTS; 
  if(FD(vffdb)->vffontvect[f].fontdataptr != -1){
    if(FD(vffdb)->vffontvect[f].dfn == fontnr) dvibad("double fontnumber in vf");
    for(f=VFMAXFONTS-1; f>=0; f--){
      if(FD(vffdb)->vffontvect[f].fontdataptr == -1)  break;
      if(FD(vffdb)->vffontvect[f].dfn == fontnr) dvibad("double fontnumber in vf");
    }  
  }
  if(f<0) 
    dvibad("too many fonts in vf");
  else {
    FD(fdb)->usecount++;
    FD(vffdb)->vffontvect[f].fontdataptr=fdb;
    FD(vffdb)->vffontvect[f].dfn = fontnr;
  } 
}


void setvfname(char* fn, char* result) {
  *result=0;
  strcpy(result,fn);
  strcat(result,".vf");
}


#ifdef KPATHSEA  /* use kpathsea if wanted */
int vffind(char* ffpath,char* fontname,char* fftuto)  {  
  int foundfile;
  FILE* fofile;
  char* kpsename=NULL;

  kpsename=kpse_find_vf(fontname);
  foundfile = (kpsename!=NULL);
  if(kpsename){
    strncpy(fftuto, kpsename,MAXPATHSTR-1);
    fftuto[MAXPATHSTR-1]=0;
    freemem(&kpsename);         
  }       

#else  /* use my own subs (slow) */
int vffind(char* ffpath,char* fontname,char* fftuto)  {  
  char ffname[MAXPATHSTR];
  int foundfile;
  FILE* fofile;
  setvfname(fontname,ffname);
  foundfile=msearch(ffpath,ffname,fftuto);      

#endif /* tail of vffind */
  if(foundfile==0) { 
        return(0);
  }
  fofile=fopen(fftuto,"rb");
  if ((fgetc(fofile)!=0xf7)||(fgetc(fofile)!=202)){  
    pfprot(" - error in VFfile ");  
    fclose(fofile);
    return(0);
  }
  pfprot(" - VFfile ");
  pfverb("%s ",fftuto);
  fclose(fofile);
  return(1);
}


void vflookuppk(int fdb)  {
  int i;
  long il,f;
  uchar  o;

  
#ifdef DEBUGVF
  pfprot("(vflookuppk: ");
#endif
  vfopen(FD(fdb)->vffile);

/* Read preamble.*/
  vfposit(2);	/* skip comment */
  i=vfn1();
  vfskip(i);
  il = vfi4();
  vfskip(4);	   /* skip design size */

/* Read the fonts. */
#ifdef DEBUGVF
  pfprot(" %s -- lookup fonts: ",FD(fdb)->fonam);
#endif
  for(i=0;i<VFMAXFONTS;i++) FD(fdb)->vffontvect[i].fontdataptr=-1; /* clear vffontvect */
  while ((o = vfn1()) >= 243 && o <= 246) {
     f = vfnum(o - 242);
     vffontdef(f,fdb); 
  }
  vfclose();
}


/* this is the end where the a vf-font is defined within the dvi-file */ 
/* fdb is where it shall go in the database and vffontnr is its number in the dvi-file */
int vfdef(char* fftuto,int fdb,long chksum, long vffontnr)  {  
  long il,f;
  int mchvf, i;
  chdesc *achar;
  uchar  o;

#ifdef DEBUGVF
  pfprot("(vfdef: ");
#endif
  allocmem(&(FD(fdb)->vffile),strlen(fftuto)+1);
  strcpy(FD(fdb)->vffile, fftuto);
  allocmem(&(FD(fdb)->vffontvect),VFMAXFONTS*sizeof(fontdescvect));
  for(i=0;i<VFMAXFONTS;i++) FD(fdb)->vffontvect[i].fontdataptr=-1;

  /* Read preamble.*/
  vfopen(fftuto);	
  vfposit(2);	/* skip comment */
  i=vfn1();
  vfskip(i);
  il = vfi4();
  if (il !=0 && chksum !=0 && il != chksum ) 
    pfverb(" - wrong checksum "); 
  vfskip(4);	   /* skip design size */

  /* Read the fonts. */
#ifdef DEBUGVF
  pfprot(" %s -- load fonts: ",FD(fdb)->fonam);
#endif

  while ((o = vfn1()) >= 243 && o <= 246) {
     f = vfnum(o - 242);
     if(FD(fdb)->vffirst==-1) FD(fdb)->vffirst=f; /* tag the fist one as default */
     /*printf("--%lu--",f);*/
     vffontdef(f,fdb);    
  }
  mchvf=-1;
  for (; o <= 242; o = vfn1()) {
    int len;
    unsigned long c;
    long fpwidth;
     if (o == 242) {	/* long form packet */
       len =   vfn4();
       c =     vfn4();
       fpwidth = vfn4();
       if (c >= MAXCHARS) {
         pfprot(" -  ignoring character %lu ",c);
	 vfskip(len);
	 continue;
       }
     }
     else {	/* short form packet */
       len = o;
       c = vfn1();
       fpwidth = vfnum(3);
     }
     achar = FD(fdb)->chv+c;
     achar->fty |= VFTYPE;
     achar->fontdataptr = fdb;
     achar->ch = (uchar) c; 
     achar->tfw = scaled(fpwidth,FD(fdb)->foscf);
     achar->addr = vftell();
     achar->mlen = len;
     allocmem(&achar->macro,achar->mlen+1);
     vfbytes(achar->macro, achar->mlen);
#ifdef DEBUGVF
     pfprot(" c %d data 0x%x len %u", c, achar->macro,achar->mlen); 
#endif     
     /*vfskip(len);*/
     if (mchvf < (int) c)  mchvf = (int) c;
  }
  vfclose();
#ifdef DEBUGVF
  pfprot("... vfdef)");
#endif
  if (mchvf < 0 || o !=248) {
    pfprot(" - VFfile in error ");
    freemem(&(FD(fdb)->vffile));
    return(0);
  } else  pfverb(" - VFfile ok ");
  if (mchvf > FD(fdb)->mch)  FD(fdb)->mch=mchvf;
  return(1);
}


  
