Changelog
---------

<!-- Do not edit. This file is automatically generated from changelog.yaml.-->

**0.47.1 (2024-11-27)**

* Fix last post ID not being stored when using --json, which broke --reply-last
* Don't set default post visibility to public, let the server decide instead

**0.47.0 (2024-11-14)**

* Add `toot tui --show-display-names` option to show display names instead of
  account names (#501)
* Add missing descriptions for notification types (#502)
* Fix bug in paging timelines where limit parameter was sent twice (#505)
* TUI: Fix exception when loading followed accounts when server does not support
  it (#504)

**0.46.0 (2024-11-14)**

* Add `--limit` and `--offset` options to `search` command (thanks @Oblomov)
* Add `--min-id` and `--max-id` options to `search` command
* Add `--type` and `--exclude-type` options to `notifications` command
* Fix bug when identifying lists by their ID

**0.45.0 (2024-09-29)**

* Add `post --reply-last` for replying to last posted toot, for creating threads
* Deprecate `env` command in favour of `diag`

**0.44.1 (2024-08-12)**

* Make it possible to pass status URL as status_id, experimental (thanks
  @nemobis)
* Show statuses in search results (thanks @nemobis)

**0.44.0 (2024-08-12)**

* **BREAKING:** Require Python 3.8+
* Add `toot diag` for displaying diagnostic info (thanks Dan Schwarz)
* TUI: Improve image support (thanks @AnonymouX47)
* TUI: Add support for indexed color image rendering (#483) (thanks Dan Schwarz)
* TUI: Fix crash bug (#483) (thanks Dan Schwarz)

**0.43.0 (2024-04-13)**

* TUI: Support displaying images (thanks Dan Schwarz)
* Improve GoToSocial compatibility (thanks Luca Matei Pintilie)
* Show visibility in timeline (thanks Sandra Snan)
* Flag `notifications --clear` no longer requires an argument (thanks Sandra
  Snan)
* TUI: Fix crash when rendering invalid URLs (thanks Dan Schwarz)
* Migrated to pyproject.toml finally

**0.42.0 (2024-03-09)**

* TUI: Add `toot tui --always-show-sensitive` option (thanks Lexi Winter)
* TUI: Document missing shortcuts (thanks Denis Laxalde)
* TUI: Use rounded boxes for nicer visuals (thanks Dan Schwarz)
* TUI: Don't break if edited_at status field does not exist

**0.41.1 (2024-01-02)**

* Fix a crash in settings parsing code

**0.41.0 (2024-01-02)**

* Honour user's default visibility set in Mastodon preferences instead of always
  defaulting to public visibility (thanks Lexi Winter)
* TUI: Add editing toots (thanks Lexi Winter)
* TUI: Fix a bug which made palette config in settings not work
* TUI: Show edit datetime in status detail (thanks Lexi Winter)

**0.40.2 (2023-12-28)**

* Reinstate `toot post --using` option.
* Add shell completion for instances.

**0.40.1 (2023-12-28)**

* Add `toot --as` option to replace `toot post --using`. This now works for all
  commands.

**0.40.0 (2023-12-27)**

This release includes a rather extensive change to use the Click library
(https://click.palletsprojects.com/) for creating the command line interface.
This allows for some new features like nested commands, setting parameters via
environment variables, and shell completion. Backward compatibility should be
mostly preserved, except for cases noted below. Please report any issues.

* BREAKING: Remove deprecated `--disable-https` option for `login` and
  `login_cli`, pass the base URL instead
* BREAKING: Options `--debug` and `--color` must be specified after `toot` but
  before the command
* BREAKING: Option `--quiet` has been removed. Redirect output instead.
* Add passing parameters via environment variables, see:
  https://toot.bezdomni.net/environment_variables.html
* Add shell completion, see: https://toot.bezdomni.net/shell_completion.html
* Add `tags info`, `tags featured`, `tags feature`, and `tags unfeature`
  commands
* Add `tags followed`, `tags follow`, and `tags unfollow` sub-commands,
  deprecate `tags_followed`, `tags_follow`, and `tags tags_unfollow`
* Add `lists accounts`, `lists add`, `lists create`, `lists delete`, `lists
  list`, `lists remove` subcommands, deprecate `lists`, `lists_accounts`,
  `lists_add`, `lists_create`, `lists_delete`, `lists_remove` commands.
* Add `--json` option to tags and lists commands
* Add `toot --width` option for setting your preferred terminal width
* Add `--media-viewer` and `--colors` options to `toot tui`. These were
  previously accessible only via settings.
* TUI: Fix issue where UI did not render until first input (thanks Urwid devs)

**0.39.0 (2023-11-23)**

* Add `--json` option to many commands, this makes them print the JSON data
  returned by the server instead of human-readable data. Useful for scripting.
* TUI: Make media viewer configurable in settings, see:
  https://toot.bezdomni.net/settings.html#tui-view-images
* TUI: Add rich text rendering (thanks Dan Schwarz)

**0.38.2 (2023-11-16)**

* Fix compatibility with Pleroma (#399, thanks Sandra Snan)
* Fix language documentation (thanks Sandra Snan)

**0.38.1 (2023-07-25)**

* Fix relative datetimes option in TUI

**0.38.0 (2023-07-25)**

* Add `toot muted` and `toot blocked` commands (thanks Florian Obser)
* Add settings file, allows setting common options, defining defaults for
  command arguments, and the TUI palette
* TUI: Remap shortcuts so they don't override HJKL used for navigation (thanks
  Dan Schwarz)

**0.37.0 (2023-06-28)**

* **BREAKING:** Require Python 3.7+
* Add `timeline --account` option to show the account timeline (thanks Dan
  Schwarz)
* Add `toot status` command to show a single status
* TUI: Add personal timeline (thanks Dan Schwarz)
* TUI: Highlight followed accounts in status details (thanks Dan Schwarz)
* TUI: Restructured goto menu (thanks Dan Schwarz)
* TUI: Fix boosting boosted statuses (thanks Dan Schwarz)
* TUI: Add support for list timelines (thanks Dan Schwarz)

**0.36.0 (2023-03-09)**

* Move docs from toot.readthedocs.io to toot.bezdomni.net
* Add specifying media thumbnails to `toot post` (#301)
* Add creating polls to `toot post`
* Handle custom instance domains (e.g. when server is located at
  `social.vivaldi.net`, but uses the `vivaldi.net` mastodon domain. (#217)
* TUI: Inherit post visibility when replying (thanks @rogarb)
* TUI: Add conversations timeline (thanks @rogarb)
* TUI: Add shortcut to copy toot contents (thanks Dan Schwarz)

**0.35.0 (2023-03-01)**

* Save toot contents when using --editor so it's recoverable if posting fails
  (#311)
* TUI: Add voting on polls (thanks Dan Schwarz)
* TUI: Add following/blocking/muting accounts (thanks Dan Schwarz)
* TUI: Add notifications timeline (thanks Dan Schwarz)

**0.34.1 (2023-02-20)**

* TUI: Fix bug where TUI would break on older Mastodon instances (#309)

**0.34.0 (2023-02-03)**

* Fix Python version detection which would fail in some cases (thanks K)
* Fix toot --help not working (thanks Norman Walsh)
* TUI: Add option to save status JSON data from source window (thanks Dan
  Schwarz)
* TUI: Add `--relative-datetimes` option to show relative datetimes (thanks Dan
  Schwarz)
* TUI: Don't focus newly created post (#188, thanks Dan Schwarz)
* TUI: Add ability to scroll long status messages (#166, thanks Dan Schwarz)
* TUI: Add action to view account details (thanks Dan Schwarz)

**0.33.1 (2023-01-03)**

* TUI: Fix crash when viewing toot in browser

**0.33.0 (2023-01-02)**

* Add CONTRIBUTING.md containing a contribution guide
* Add `env` command which prints local env to include in issues
* Add TOOT_POST_VISIBILITY environment to control default post visibility
  (thanks Lim Ding Wen)
* Add `tags_followed`, `tags_follow`, and `tags_unfollow` commands (thanks
  Daniel Schwarz)
* Add `tags_bookmarks` command (thanks Giuseppe Bilotta)
* TUI: Show an error if attemptint to boost a private status (thanks Lim Ding
  Wen)
* TUI: Hide polls, cards and media attachments for sensitive posts (thanks
  Daniel Schwarz)
* TUI: Add bookmarking and bookmark timeline (thanks Daniel Schwarz)
* TUI: Show status visibility (thanks Lim Ding Wen)
* TUI: Reply to original account instead of boosting account (thanks Lim Ding
  Wen)
* TUI: Refresh screen after exiting browser, required for text browsers (thanks
  Daniel Schwarz)
* TUI: Highlight followed tags (thanks Daniel Schwarz)

**0.32.1 (2022-12-12)**

* Fix packaging issue, missing toot.utils module

**0.32.0 (2022-12-12)**

* TUI: Press N to translate status, if available on your instance (thanks Daniel
  Schwarz)
* Fix: `post --language` option now accepts two-letter country code instead of
  3-letter. This was changed by mastodon at some point.
* Fix: Failing to find accounts using qualified usernames (#254)

**0.31.0 (2022-12-07)**

* **BREAKING:** Require Python 3.6+
* Add `post --scheduled-in` option for easier scheduling
* Fix posting toots to Pleroma
* Improved testing

**0.30.1 (2022-11-30)**

* Remove usage of deprecated `text_url` status field. Fixes posting media
  without text.

**0.30.0 (2022-11-29)**

* Display polls in `timeline` (thanks Daniel Schwarz)
* TUI: Add [,] shortcut to reload timeline (thanks Daniel Schwarz)
* TUI: Add [Z] shortcut to zoom status - allows scrolling (thanks
  @PeterFidelman)
* Internals: add integration tests against a local mastodon instance

**0.29.0 (2022-11-21)**

* Add `bookmark` and `unbookmark` commands
* Add `following` and `followers` commands (thanks @Oblomov)
* TUI: Show media attachments in links list (thanks @PeterFidelman)
* Fix tests so that they don't depend on the local timezone

**0.28.1 (2022-11-12)**

* Fix account search to be case insensitive (thanks @TheJokersThief)
* Fix account search to use v2 endpoint, since v1 endpoint was removed on some
  instances (thanks @kaja47)
* Add '.toot' extension to temporary files when composing toot in an editor
  (thanks @larsks)
* Display localized datetimes in timeline (thanks @mmmmmmbeer)
* Don't use # for comments when composing toot in an editor, since that made it
  impossible to post lines starting with #.
* TUI: Fix crash when poll does not have an expiry date

**0.28.0 (2021-08-28)**

* **BREAKING**: Removed `toot curses`, deprecated since 2019-09-03
* Add `--scheduled-at` option to `toot post`, allows scheduling toots
* Add `--description` option to `toot post`, for adding descriptions to media
  attachments (thanks @ansuz)
* Add `--mentions` option to `toot notifications` to show only mentions (thanks
  @alexwennerberg)
* Add `--content-type` option to `toot post` to allow specifying mime type, used
  on Pleroma (thanks Sandra Snan)
* Allow post IDs to be strings as used on Pleroma (thanks Sandra Snan)
* TUI: Allow posts longer than 500 characters if so configured on the server
  (thanks Sandra Snan)
* Allow piping the password to login_cli for testing purposes (thanks
  @NinjaTrappeur)
* Disable paging timeline when output is piped (thanks @stacyharper)

**0.27.0 (2020-06-15)**

* TUI: Fix access to public and tag timelines when on private mastodon instances
  (#168)
* Add `--reverse` option to `toot notifications` (#151)
* Fix `toot timeline` to respect `--instance` option
* TUI: Add option to pin/save tag timelines (#163, thanks @dlax)
* TUI: Fixed crash on empty timeline (#138, thanks ecs)

**0.26.0 (2020-04-15)**

* Fix datetime parsing on Python 3.5 (#162)
* TUI: Display status links and open them (#154, thanks @dlax)
* TUI: Fix visibility descriptions (#153, thanks @finnoleary)
* **IMPORTANT:** Starting from this release, new releases will not be uploaded
  to the APT package repository at `bezdomni.net`. Please use the official
  Debian or Ubuntu repos or choose another [installation
  option](https://toot.bezdomni.net/installation.html).

**0.25.2 (2020-01-23)**

* Revert adding changelog and readme to sourceballs (#149)
* TUI: Fall back to username when display_name is unset (thanks @dlax)
* Note: 0.25.1 was skipped due to error when releasing

**0.25.0 (2020-01-21)**

* TUI: Show character count when composing (#121)
* Include changelog and license in sourceballs (#133)
* Fix searching by hashtag which include the '#' (#134)
* Upgrade search to v2 (#135)
* Fix compatibility with Python < 3.6 (don't use fstrings)

**0.24.0 (2019-09-18)**

* On Windows store config files under %APPDATA%
* CLI: Don't use ANSI colors if not supported by terminal or when not in a tty
* TUI: Implement deleting own status messages
* TUI: Improve rendering of reblogged statuses (thanks @dlax)
* TUI: Set urwid encoding to UTF-8 (thanks @bearzk)

**0.23.1 (2019-09-04)**

* Fix a date parsing bug in Python versions <3.7 (#114)

**0.23.0 (2019-09-03)**

* Add `toot tui`, new and improved TUI implemented written with the help of the
  [urwid](http://urwid.org/) library
* Deprecate `toot curses`. It will show a deprecation notice when started. To be
  removed in a future release
* Add `--editor` option to `toot post` to allow composing toots in an editor
  (#90)
* Fix config file permissions, set them to 0600 when creating the initial config
  file (#109)
* Add user agent string to all requests, fixes interaction with instances
  protected by Cloudflare (#106)

**0.22.0 (2019-08-01)**

* **BREAKING:** Dropped support for Python 3.3
* Add `toot notifications` to show notifications (thanks @dlax)
* Add posting and replying to curses interface (thanks @Skehmatics)
* Add `--language` option to `toot post`
* Enable attaching upto 4 files via `--media` option on `toot post`

**0.21.0 (2019-02-15)**

* **BREAKING:** in `toot timeline` short argument for selecting a list is no
  longer `-i`, this has been changed to select the instance, so that it is the
  same as on other commands, please use the long form `--list` instead
* Add `toot reblogged_by` to show who reblogged a status (#88)
* Add `toot thread` to show a status with its replies (#87)
* Better handling of wide characters (eastern scripts, emojis) (#84)
* Improved `timeline`, nicer visuals, and it will now ask to show next batch of
  toots, unless given the `--once` option
* Add public/local/tag timelines to `timeline` and `curses`
* Support for boosting and favouriting in `toot curses`, press `f`/`b` (#88,
  #93)

**0.20.0 (2019-02-01)**

* Enable interaction with instances using http instead of https (#56)
* Enable proxy usage via environment variables (#47)
* Make `toot post` prompt for input if no text is given (#82)
* Add post-related commands: `favourite`, `unfavourite`, `reblog`, `unreblog`,
  `pin` & `unpin` (#75)

**0.19.0 (2018-06-27)**

* Add support for replying to a toot (#6)
* Add `toot delete` command for deleting a toot (#54)
* Add global `--quiet` flag to silence output (#46)
* Make `toot login` provide browser login, and `toot login_cli` log in via
  console. This makes it clear what's the preferred option.
* Use Idempotency-Key header to prevent multiple toots being posted if request
  is retried
* Fix a bug where all media would be marked as sensitive

**0.18.0 (2018-06-12)**

* Add support for public, tag and list timelines in `toot timeline` (#52)
* Add `--sensitive` and `--spoiler-text` options to `toot post` (#63)
* Curses app improvements (respect sensitive content, require keypress to show,
  add help modal, misc improvements)

**0.17.1 (2018-01-15)**

* Create config folder if it does not exist (#40)
* Fix packaging to include `toot.ui` package (#41)

**0.17.0 (2018-01-15)**

* Changed configuration file format to allow switching between multiple logged
  in accounts (#32)
* Respect XDG_CONFIG_HOME environment variable to locate config home (#12)
* Dynamically calculate left window width, supports narrower windows (#27)
* Redraw windows when terminal size changes (#25)
* Support scrolling the status list
* Fetch next batch of statuses when bottom is reached
* Support up/down arrows (#30)
* Misc visual improvements

**0.16.2 (2018-01-02)**

* No changes, pushed to fix a packaging issue

**0.16.1 (2017-12-30)**

* Fix bug with app registration

**0.16.0 (2017-12-30)**

* **BREAKING:** Dropped support for Python 2, because it's a pain to support and
  caused bugs with handling unicode.
* Remove hacky `login_2fa` command, use `login_browser` instead
* Add `instance` command
* Allow `post`ing media without text (#24)

**0.15.1 (2017-12-12)**

* Fix crash when toot's URL is None (#33), thanks @veer66

**0.15.0 (2017-09-09)**

* Fix Windows compatibility (#18)

**0.14.0 (2017-09-07)**

* Add `--debug` option to enable debug logging instead of using the `TOOT_DEBUG`
  environment variable.
* Fix: don't read requirements.txt from setup.py, this fails when packaging deb
  and potentially in some other cases (see #18)

**0.13.0 (2017-08-26)**

* Allow passing `--instance` and `--email` to login command
* Add `login_browser` command for proper two factor authentication through the
  browser (#19, #23)

**0.12.0 (2017-05-08)**

* Add option to disable ANSI color in output (#15)
* Return nonzero error code on error (#14)
* Change license to GPLv3

**0.11.0 (2017-05-07)**

* Fix error when running toot from crontab (#11)
* Minor tweaks

**0.10.0 (2017-04-26)**

* Add commands: `block`, `unblock`, `mute`, `unmute`
* Internal improvements

**0.9.1 (2017-04-24)**

* Fix conflict with curses package name

**0.9.0 (2017-04-21)**

* Add `whois` command
* Add experimental `curses` app for viewing the timeline

**0.8.0 (2017-04-19)**

* **BREAKING:** Renamed command `2fa` to `login_2fa`
* It is now possible to pipe text into `toot post`

**0.7.0 (2017-04-18)**

* **WARNING:** Due to changes in configuration format, after upgrading to this
  version, you will be required to log in to your Mastodon instance again.
* Experimental 2FA support (#3)
* Do not create a new application for each login

**0.6.0 (2017-04-17)**

* Add `whoami` command
* Migrate from `optparse` to `argparse`

**0.5.0 (2017-04-16)**

* Add `search`, `follow` and `unfollow` commands
* Migrate from `optparse` to `argparse`

**0.4.0 (2017-04-15)**

* Add `upload` command to post media
* Add `--visibility` and `--media` options to `post` command

**0.3.0 (2017-04-13)**

* Add: view timeline
* Require an explicit login

**0.2.1 (2017-04-13)**

* Fix invalid requirements in setup.py

**0.2.0 (2017-04-12)**

* Bugfixes

**0.1.0 (2017-04-12)**

* Initial release

